/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.data.BaseScan;
import ice.event.ScanListEvent;
import ice.event.ScanListListener;
import ice.gui.panel.sans.data.SansScan;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.util.ArrayList;
import java.util.Iterator;

public class ScanList {
    public ArrayList<BaseScan> scanList = new ArrayList();
    private ICEListenerList<ScanListListener, ScanListEvent> listeners = new ICEListenerList();

    public void addScanListListener(ScanListListener sll) throws ICEListenerListExceptionBase {
        this.listeners.addListener(sll);
    }

    public void removeScanListListener(ScanListListener sll) {
        this.listeners.removeListener(sll);
    }

    public synchronized ArrayList<BaseScan> getScanList() {
        return this.scanList;
    }

    public synchronized void setScanList(ArrayList<BaseScan> scanList) {
        this.scanList = scanList;
    }

    public synchronized void replaceScanList(ArrayList<BaseScan> newScanList) {
        int j;
        boolean matchFound;
        ArrayList<BaseScan> scansToRemove = new ArrayList<BaseScan>();
        ArrayList<Integer> removeIndices = new ArrayList<Integer>();
        ArrayList<BaseScan> scansToAdd = new ArrayList<BaseScan>();
        ArrayList<Integer> addIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < this.scanList.size()) {
            BaseScan serverScan = this.scanList.get(i);
            matchFound = false;
            j = 0;
            while (j < newScanList.size()) {
                if (serverScan.getName().equals(newScanList.get(j).getName())) {
                    this.updateScan(serverScan, newScanList.get(j));
                    matchFound = true;
                    break;
                }
                ++j;
            }
            if (!matchFound) {
                scansToRemove.add(serverScan);
                removeIndices.add(new Integer(i));
            }
            ++i;
        }
        i = 0;
        while (i < newScanList.size()) {
            BaseScan newScan = newScanList.get(i);
            matchFound = false;
            j = 0;
            while (j < this.scanList.size()) {
                if (newScan.getName().equals(this.scanList.get(j).getName())) {
                    matchFound = true;
                    break;
                }
                ++j;
            }
            if (!matchFound) {
                scansToAdd.add(newScan);
                addIndices.add(new Integer(i));
            }
            ++i;
        }
        Iterator removeIterator = scansToRemove.iterator();
        while (removeIterator.hasNext()) {
            this.scanList.remove(removeIterator.next());
        }
        Iterator addIterator = scansToAdd.iterator();
        Iterator addIndicesIterator = addIndices.iterator();
        while (addIterator.hasNext()) {
            this.scanList.add((Integer)addIndicesIterator.next(), (BaseScan)addIterator.next());
        }
        int[] removeIndicesArray = new int[removeIndices.size()];
        int i2 = 0;
        while (i2 < removeIndices.size()) {
            removeIndicesArray[i2] = (Integer)removeIndices.get(i2);
            ++i2;
        }
        BaseScan[] removedScans = new BaseScan[scansToRemove.size()];
        int i3 = 0;
        while (i3 < scansToRemove.size()) {
            removedScans[i3] = (BaseScan)scansToRemove.get(i3);
            ++i3;
        }
        int[] addIndicesArray = new int[addIndices.size()];
        int i4 = 0;
        while (i4 < addIndices.size()) {
            addIndicesArray[i4] = (Integer)addIndices.get(i4);
            ++i4;
        }
        this.notifyListenersOfAdd(addIndicesArray);
        this.notifyListenersOfRemove(removeIndicesArray, removedScans);
    }

    public synchronized void updateScanList(ArrayList<BaseScan> changedScanList) {
        ArrayList<BaseScan> scansToAdd = new ArrayList<BaseScan>();
        ArrayList<Integer> addIndices = new ArrayList<Integer>();
        ArrayList<Integer> updateIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < changedScanList.size()) {
            BaseScan newScan = changedScanList.get(i);
            boolean matchFound = false;
            int j = 0;
            while (j < this.scanList.size()) {
                if (newScan.getName().equals(this.scanList.get(j).getName())) {
                    updateIndices.add(j);
                    this.updateScan(this.scanList.get(j), newScan);
                    matchFound = true;
                    break;
                }
                ++j;
            }
            if (!matchFound) {
                scansToAdd.add(newScan);
                addIndices.add(new Integer(i));
            }
            ++i;
        }
        if (updateIndices.size() > 0) {
            int[] updateIndicesArray = new int[updateIndices.size()];
            int i2 = 0;
            while (i2 < updateIndices.size()) {
                updateIndicesArray[i2] = (Integer)updateIndices.get(i2);
                ++i2;
            }
            this.notifyListenersOfUpdate(updateIndicesArray);
        }
        Iterator addIterator = scansToAdd.iterator();
        Iterator addIndicesIterator = addIndices.iterator();
        while (addIterator.hasNext()) {
            this.scanList.add((Integer)addIndicesIterator.next(), (BaseScan)addIterator.next());
        }
        int[] addIndicesArray = new int[addIndices.size()];
        int i3 = 0;
        while (i3 < addIndices.size()) {
            addIndicesArray[i3] = (Integer)addIndices.get(i3);
            ++i3;
        }
        this.notifyListenersOfAdd(addIndicesArray);
    }

    public synchronized void removeScanList(ArrayList<BaseScan> deletedScanList) {
        ArrayList<BaseScan> scansToRemove = new ArrayList<BaseScan>();
        ArrayList<Integer> removeIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < this.scanList.size()) {
            BaseScan serverScan = this.scanList.get(i);
            int j = 0;
            while (j < deletedScanList.size()) {
                if (serverScan.getName().equals(deletedScanList.get(j).getName())) {
                    scansToRemove.add(serverScan);
                    removeIndices.add(new Integer(i));
                    break;
                }
                ++j;
            }
            ++i;
        }
        Iterator removeIterator = scansToRemove.iterator();
        while (removeIterator.hasNext()) {
            this.scanList.remove(removeIterator.next());
        }
        int[] removeIndicesArray = new int[removeIndices.size()];
        int i2 = 0;
        while (i2 < removeIndices.size()) {
            removeIndicesArray[i2] = (Integer)removeIndices.get(i2);
            ++i2;
        }
        BaseScan[] removedScans = new BaseScan[scansToRemove.size()];
        int i3 = 0;
        while (i3 < scansToRemove.size()) {
            removedScans[i3] = (BaseScan)scansToRemove.get(i3);
            ++i3;
        }
        this.notifyListenersOfRemove(removeIndicesArray, removedScans);
    }

    private void updateScan(BaseScan oldScan, BaseScan newScan) {
        oldScan.setName(newScan.getName());
        oldScan.setPrefix(newScan.getPrefix());
        oldScan.setComments(newScan.getComments());
        oldScan.setScanType(newScan.getScanType());
        oldScan.setSubmissionID(newScan.getSubmissionID());
        oldScan.setNumPoints(newScan.getNumPoints());
        oldScan.setPrefactor(newScan.getPrefactor());
        oldScan.setBaseCount(newScan.getBaseCount());
        oldScan.setDataOfInterest(newScan.getDataOfInterest());
        oldScan.setCountType(newScan.getCountType());
        oldScan.setCountTimeout(newScan.getCountTimeout());
        oldScan.setFixedEnergyDevice(newScan.getFixedEnergyDevice());
        oldScan.setFixedEnergy(newScan.getFixedEnergy());
        oldScan.setPointHold(newScan.getPointHold());
        oldScan.setPreScanHold(newScan.getPreScanHold());
        oldScan.setRangeMode(newScan.getRangeMode());
        oldScan.setDeviceRanges(newScan.getDeviceRanges());
        oldScan.settempSetPoint(newScan.gettempSetPoint());
        oldScan.settempMaxWaitTime(newScan.gettempMaxWaitTime());
        oldScan.settempTolerance(newScan.gettempTolerance());
        oldScan.settempToleranceBT(newScan.gettempToleranceBT());
        oldScan.setmagSetPoint(newScan.getmagSetPoint());
        oldScan.setmagTolerance(newScan.getmagTolerance());
        if (oldScan instanceof SansScan) {
            ((SansScan)oldScan).updateScanValues(((SansScan)newScan).getScanValues());
            ((SansScan)oldScan).updateSampleValues(((SansScan)newScan).getSampleValues());
            ((SansScan)oldScan).updateAngleValues(((SansScan)newScan).getAngleValues());
        }
        oldScan.updatePresetDeviceProperties(newScan.getPresetDeviceProperties());
    }

    private void notifyListenersOfAdd(int[] indices) {
        ScanListEvent event = new ScanListEvent(ScanListEvent.Type.ADD, this, this.scanList, indices);
        this.listeners.notifyListeners(event);
    }

    private void notifyListenersOfRemove(int[] indices, BaseScan[] removedScans) {
        ScanListEvent event = new ScanListEvent(ScanListEvent.Type.REMOVE, this, this.scanList, indices, removedScans);
        this.listeners.notifyListeners(event);
    }

    private void notifyListenersOfUpdate(int[] indices) {
        ScanListEvent event = new ScanListEvent(ScanListEvent.Type.UPDATE, this, this.scanList, indices);
        this.listeners.notifyListeners(event);
    }
}

