/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.data.DataSet;
import ice.event.communication.DataMessageEvent;
import ice.event.communication.DataMessageListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DataManager
implements DataMessageListener {
    private static final Logger logger = Logger.getLogger("DataLogger.DataManager");
    private DataSet currentDataSet = null;
    private int maxDataSets = 4;
    private final List<DataSet> recentDataSetList = new Vector<DataSet>(this.maxDataSets);
    private final Map<Long, DataSet> dataSetsByCommandId = new Hashtable<Long, DataSet>(this.maxDataSets);
    private DataSet previousDataSet = null;

    public synchronized void addDataSet(DataSet dataSet) {
        if (this.recentDataSetList.size() >= this.maxDataSets) {
            this.removeOldestDataSet();
        }
        this.recentDataSetList.add(dataSet);
        this.dataSetsByCommandId.put(dataSet.getCommandId(), dataSet);
    }

    private synchronized DataSet removeOldestDataSet() {
        DataSet removeSet = this.recentDataSetList.remove(0);
        this.dataSetsByCommandId.remove(removeSet.getCommandId());
        return removeSet;
    }

    public DataSet getCurrentDataSet() {
        return this.currentDataSet;
    }

    public DataSet getPreviousDataSet() {
        return this.previousDataSet;
    }

    public synchronized int getMaxDataSets() {
        return this.maxDataSets;
    }

    public synchronized void setMaxDataSets(int maxDataSets) {
        this.maxDataSets = maxDataSets;
        int i = this.recentDataSetList.size();
        while (i > maxDataSets) {
            this.removeOldestDataSet();
            --i;
        }
    }

    public DataSet getDataSetByCommandId(long commandId) {
        return this.dataSetsByCommandId.get(commandId);
    }

    @Override
    public void actionPerformed(DataMessageEvent de) {
        try {
            if (this.currentDataSet == null || de.isNewStart() || this.currentDataSet.getCommandId() != (long)de.getCommandId()) {
                this.previousDataSet = this.currentDataSet;
                this.currentDataSet = new DataSet(de);
                this.addDataSet(this.currentDataSet);
            } else if (de.getPointNum() > 0) {
                this.currentDataSet.addPointData(de);
            } else if (de.hasFitData()) {
                this.currentDataSet.addFitData(de);
            } else if (de.hasFinished()) {
                this.currentDataSet.setCompleted(true);
            }
        }
        catch (Exception e) {
            logger.error("Error receiving data message", e);
        }
    }
}

