/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class TransferCommand
extends ImmediateCommand {
    protected static final String BASE_COMMAND_STRING = "Transfer ";
    protected static final String VALID_BEGINING = "File ";
    protected static final String VALID_ENDING = " transfered";
    private String magicWord = null;
    private String fileName = null;
    private String contents = null;
    private String result = "";

    public TransferCommand(String magicWord, String fileName, String contents) throws NoClientAPIInstanceException {
        this.magicWord = magicWord;
        this.fileName = fileName;
        this.contents = contents;
    }

    public TransferCommand(String magicWord, String fileName, String contents, ClientAPI clientApiRef) throws NoClientAPIInstanceException {
        super(clientApiRef);
        this.magicWord = magicWord;
        this.fileName = fileName;
        this.contents = contents;
    }

    protected TransferCommand() throws NoClientAPIInstanceException {
    }

    protected TransferCommand(ClientAPI clientApiRef) {
        super(clientApiRef);
    }

    protected TransferCommand(String command, ClientAPI clientApiRef) {
        super(command, clientApiRef);
    }

    protected TransferCommand(String command) throws NoClientAPIInstanceException {
        super(command);
    }

    @Override
    public synchronized String generateCommandString() {
        String commandString = BASE_COMMAND_STRING;
        if (this.magicWord != null && !this.magicWord.equals("")) {
            commandString = String.valueOf(commandString) + this.magicWord + ":";
        }
        commandString = String.valueOf(commandString) + this.fileName;
        commandString = String.valueOf(commandString) + " " + this.contents;
        this.setCommandString(commandString);
        return commandString;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        String response = this.getResponse();
        Object limits = null;
        boolean success = false;
        success = (response = response.trim()).startsWith(VALID_BEGINING);
        if (success) {
            success = response.endsWith(VALID_ENDING);
            if (!success) {
                this.setSuccess(false);
                this.setError(true);
            }
            this.setSuccess(true);
            this.setError(false);
        } else {
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public String getResult() {
        return this.result;
    }
}

