/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class SetInterfaceResetBrokenStateCommand
extends ImmediateCommand {
    private static final String command = "SETINTERFACERESETBROKENSTATE";
    private int state = 0;
    private String deviceName = null;

    public SetInterfaceResetBrokenStateCommand() throws NoClientAPIInstanceException {
    }

    public SetInterfaceResetBrokenStateCommand(String deviceName, int state) throws NoClientAPIInstanceException {
        super("SETINTERFACERESETBROKENSTATE " + deviceName + " " + state);
        this.deviceName = deviceName;
        this.state = state;
        this.generateCommandString();
    }

    public SetInterfaceResetBrokenStateCommand(String deviceName, int state, ClientAPI clientApiRef) {
        super("SETINTERFACERESETBROKENSTATE " + deviceName + " " + state, clientApiRef);
        this.deviceName = deviceName;
        this.state = state;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString("SETINTERFACERESETBROKENSTATE " + this.deviceName + " " + this.state);
        return "SETINTERFACERESETBROKENSTATE " + this.deviceName + " " + this.state;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        String expectedResponse;
        String response = this.getResponse();
        if (response.equals(expectedResponse = "The interface reset broken state of device " + this.deviceName + " has been set")) {
            this.setSuccess(true);
            this.setError(false);
        } else {
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        this.generateCommandString();
    }

    public String getImmediateCommandString() {
        return "SETINTERFACERESETBROKENSTATE " + this.deviceName + " " + this.state;
    }
}

