/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class GetDeviceProbeStateCommand
extends ImmediateCommand {
    private static final String command = "GETDEVICEPROBESTATE";
    private String deviceName = null;
    private int state = 0;

    public GetDeviceProbeStateCommand() throws NoClientAPIInstanceException {
    }

    public GetDeviceProbeStateCommand(String deviceName) throws NoClientAPIInstanceException {
        super("GETDEVICEPROBESTATE " + deviceName);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public GetDeviceProbeStateCommand(String deviceName, ClientAPI clientApiRef) {
        super("GETDEVICEPROBESTATE " + deviceName, clientApiRef);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString("GETDEVICEPROBESTATE " + this.deviceName);
        return "GETDEVICEPROBESTATE " + this.deviceName;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        String response = this.getResponse();
        try {
            this.state = Integer.parseInt(response);
            if (this.state < 0 || this.state > 1) {
                this.state = 0;
                this.setSuccess(false);
                this.setError(true);
            } else {
                this.setSuccess(true);
                this.setError(false);
            }
        }
        catch (NumberFormatException notInteger) {
            this.state = 0;
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public int getState() {
        return this.state;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public String getImmediateCommandString() {
        return "GETDEVICEPROBESTATE " + this.deviceName;
    }
}

