/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class DevicePositionsCommand
extends ImmediateCommand {
    private static final String command = "DEVICE POSITIONS ";
    private String deviceName = null;
    private String[] responseValues;

    public DevicePositionsCommand() throws NoClientAPIInstanceException {
    }

    public DevicePositionsCommand(String deviceName) throws NoClientAPIInstanceException {
        super(command + deviceName);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public DevicePositionsCommand(String deviceName, ClientAPI clientApiRef) {
        super(command + deviceName, clientApiRef);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString(command + this.deviceName);
        return command + this.deviceName;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        try {
            String response = this.getResponse();
            if (response.contains("[")) {
                response = response.replace("[", "");
                response = response.replace("]", "");
                String delims = "[,]";
                this.responseValues = response.split(delims);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public String getImmediateCommandString() {
        return command + this.deviceName;
    }

    public String[] getParsedResponse() {
        return this.responseValues;
    }
}

