/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.IceServerException;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.exceptions.CommandException;
import ice.communication.messageHandlers.serverExceptions.IceServerExceptionQueue;
import ice.communication.messageHandlers.serverExceptions.ServerExceptionListener;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class Command
implements ServerExceptionListener {
    private String response = null;
    private boolean success = false;
    private boolean error = false;
    private String commandString = null;
    private ClientAPI clientApiRef = null;
    private Logger logger = Logger.getLogger("ICE.ClientAPI.command");
    protected List<IceServerException> commandExceptions = null;
    private IssueTypes issueType = null;
    protected Date issuedTimestamp;
    protected Date responseTimestamp;

    public Command(ClientAPI clientApiRef) {
        this.clientApiRef = clientApiRef;
    }

    public Command() throws NoClientAPIInstanceException {
        this(ClientAPI.getInstance());
    }

    public void finalize() {
        IceServerExceptionQueue.removeListenerFromAll(this);
    }

    public ClientAPI getClientApiRef() {
        return this.clientApiRef;
    }

    public boolean isSuccess() {
        return this.success;
    }

    protected void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isError() {
        return this.error;
    }

    protected void setError(boolean error) {
        this.error = error;
    }

    public String getCommandString() {
        return this.commandString;
    }

    protected void setCommandString(String cmd) {
        this.commandString = cmd;
    }

    public String getResponse() {
        return this.response;
    }

    public abstract String generateCommandString();

    protected abstract void parseSynchronousResponse();

    protected abstract void parseAsynchronousResponse();

    public Date getIssuedTimestamp() {
        return this.issuedTimestamp;
    }

    public Date getResponseTimestamp() {
        return this.responseTimestamp;
    }

    protected void setIssuedTimestamp(Date d) {
        this.issuedTimestamp = d;
    }

    protected void setResponseTimestamp(Date d) {
        this.responseTimestamp = d;
    }

    public void run() throws ICEListenerListExceptionBase {
        this.runSynchronous();
    }

    public void runSynchronous() throws ICEListenerListExceptionBase {
        this.resetState();
        this.setIssueType(IssueTypes.synchronous);
        this.generateCommandString();
        if (this.issueSynchronous()) {
            this.parseSynchronousResponse();
        } else {
            this.setError(true);
            this.setSuccess(false);
        }
    }

    public void runAsynchronous() {
        this.resetState();
        this.setIssueType(IssueTypes.asynchronous);
        this.generateCommandString();
        if (this.issueAsynchronous()) {
            this.parseAsynchronousResponse();
        } else {
            this.setError(true);
            this.setSuccess(false);
        }
    }

    protected void resetState() {
        this.setSuccess(false);
        this.setError(false);
        this.setResponseString("");
        this.setIssueType(null);
    }

    protected abstract boolean issueSynchronous() throws ICEListenerListExceptionBase;

    protected abstract boolean issueAsynchronous();

    protected void setResponseString(String response) {
        this.response = response;
    }

    public IssueTypes getIssueType() {
        return this.issueType;
    }

    protected void setIssueType(IssueTypes issueType) {
        this.issueType = issueType;
    }

    public List<IceServerException> getCommandExceptions() {
        return this.commandExceptions;
    }

    public String runAndRespond() throws IceServerException, CommandException {
        try {
            this.runSynchronous();
        }
        catch (ICEListenerListExceptionBase e) {
            this.logger.error("Listener list error encountered while running command: " + this.getCommandString(), e);
            throw new CommandException(this, "Listener list error encountered", e);
        }
        return this.getResponse();
    }

    public static enum IssueTypes {
        synchronous,
        asynchronous;

    }
}

