/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.RootClassNotFound;
import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.Hollow;
import hep.io.root.core.HollowBuilder;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TBranchObject;
import hep.io.root.interfaces.TLeafObject;
import java.io.IOException;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.Type;

public abstract class TLeafObjectRep
extends AbstractRootObject
implements TLeafObject,
Constants {
    private Class hollowClass;
    private Object lastValue;
    private RootInput rin;
    private TBranchObject branch;
    private long lastValueIndex;

    public void setBranch(TBranch branch) {
        this.branch = (TBranchObject)branch;
        this.lastValueIndex = -1L;
    }

    public Object getValue(long index) throws IOException {
        try {
            boolean hollow;
            if (index == this.lastValueIndex) {
                return this.lastValue;
            }
            this.lastValueIndex = index;
            boolean bl = hollow = this.branch.getEntryNumber() == 0L;
            if (!hollow) {
                RootInput in = this.branch.setPosition(this, index);
                String type = in.readString();
                in.readByte();
                this.lastValue = in.readObject(type);
                return this.lastValue;
            }
            if (this.hollowClass == null) {
                HollowBuilder builder = new HollowBuilder(this.branch);
                String name = "hep.io.root.hollow." + this.branch.getClassName();
                RootClassFactory factory = this.rin.getFactory();
                GenericRootClass gc2 = (GenericRootClass)factory.create(this.branch.getClassName());
                this.hollowClass = factory.getLoader().loadSpecial(builder, name, gc2);
                builder.populateStatics(this.hollowClass, factory);
            }
            Hollow h = (Hollow)this.hollowClass.newInstance();
            h.setHollowIndex(index);
            this.lastValue = h;
            return this.lastValue;
        }
        catch (IOException x) {
            this.lastValueIndex = -1L;
            throw x;
        }
        catch (RootClassNotFound x) {
            this.lastValueIndex = -1L;
            throw new IOException("RootClassNotFound " + x.getClassName());
        }
        catch (Throwable x) {
            this.lastValueIndex = -1L;
            IOException io = new IOException("Error instantiating hollow object");
            io.initCause(x);
            throw io;
        }
    }

    public Object getWrappedValue(long index) throws IOException {
        return this.getValue(index);
    }

    public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, String className) {
        String leafClassName = this.getClass().getName();
        il.append(factory.createInvoke(leafClassName, "getValue", Type.OBJECT, new Type[]{Type.LONG}, (short)182));
    }

    public void read(RootInput in) throws IOException {
        super.read(in);
        this.rin = in.getTop();
    }
}

