/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.DaemonInputStream;
import hep.io.root.daemon.xrootd.ConnectionDescriptor;
import hep.io.root.daemon.xrootd.Multiplexor;
import hep.io.root.daemon.xrootd.ResponseHandler;
import hep.io.root.daemon.xrootd.XrootdInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class Session {
    private String userName;
    private Short handle;
    private Multiplexor multiplexor;
    private int bufferSize = 32768;
    private Object result;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream(20);
    private DataOutputStream out = new DataOutputStream(this.bos);
    private IOException exception = null;

    public Session(String host, int port, String userName) throws IOException {
        Multiplexor multiplexor;
        this.userName = userName;
        this.multiplexor = multiplexor = this.connectTo(host, port, userName);
        this.handle = multiplexor.allocate(this);
    }

    private Multiplexor connectTo(String host, int port, String userName) throws UnknownHostException, IOException {
        InetAddress[] addresses = InetAddress.getAllByName(host);
        Collections.shuffle(Arrays.asList(addresses));
        int i = 0;
        while (i < addresses.length) {
            try {
                InetAddress address = addresses[i];
                ConnectionDescriptor desc = new ConnectionDescriptor(address, port, userName);
                return Multiplexor.allocate(desc);
            }
            catch (IOException x) {
                if (++i < addresses.length) continue;
                throw x;
            }
        }
        throw new UnknownHostException("Host " + host + " has no known inet addresses");
    }

    void redirectConnection(ResponseHandler handler, String host, int port) throws IOException {
        Multiplexor multiplexor;
        try {
            multiplexor = this.connectTo(host, port, this.userName);
        }
        catch (Exception x) {
            IOException iox = new IOException("Error during redirect");
            iox.initCause(x);
            handler.handleError(iox);
            return;
        }
        this.multiplexor.deregisterResponseHandler(this.handle);
        this.close();
        this.multiplexor = multiplexor;
        this.handle = multiplexor.allocate(this);
        multiplexor.registerResponseHandler(this.handle, handler);
        handler.sendMessage();
    }

    Short getHandle() {
        return this.handle;
    }

    synchronized void close() throws IOException {
        if (this.multiplexor != null) {
            this.multiplexor.free(this);
            this.handle = null;
        }
    }

    synchronized List dirList(final String path) throws IOException {
        final ArrayList result = new ArrayList();
        ResponseHandler handler = new ResponseHandler(this){

            void handleResponse(Multiplexor.Response response) throws IOException {
                int rlen = response.getLength();
                DataInputStream in = response.getInputStream();
                byte[] data = new byte[rlen];
                in.readFully(data);
                String files = new String(data);
                int pos = 0;
                for (int i = 0; i < files.length(); ++i) {
                    char c = files.charAt(i);
                    if (c != '\n' && c != '\u0000') continue;
                    result.add(files.substring(pos, i));
                    if (c == '\u0000') break;
                    pos = i + 1;
                }
                if (response.getStatus() != 4000) {
                    Session.this.responseComplete();
                }
            }

            void sendMessage() throws IOException {
                Session.this.multiplexor.sendMessage(Session.this.handle, 3004, null, path);
            }
        };
        this.multiplexor.registerResponseHandler(this.handle, handler);
        handler.sendMessage();
        this.waitForResponse();
        return result;
    }

    synchronized void ping() throws IOException {
        ResponseHandler handler = new ResponseHandler(this){

            void sendMessage() throws IOException {
                Session.this.multiplexor.sendMessage(Session.this.handle, 3011);
            }
        };
        this.multiplexor.registerResponseHandler(this.handle, handler);
        handler.sendMessage();
        this.waitForResponse();
    }

    synchronized String[] stat(final String path) throws IOException {
        ResponseHandler handler = new ResponseHandler(this){

            void handleResponse(Multiplexor.Response response) throws IOException {
                int rlen = response.getLength();
                byte[] data = new byte[rlen];
                response.getInputStream().readFully(data);
                Session.this.result = new String(data, 0, rlen - 1).split(" +");
                Session.this.responseComplete();
            }

            void sendMessage() throws IOException {
                Session.this.multiplexor.sendMessage(Session.this.handle, 3017, null, path);
            }
        };
        this.multiplexor.registerResponseHandler(this.handle, handler);
        handler.sendMessage();
        this.waitForResponse();
        return (String[])this.result;
    }

    synchronized String query(int queryType, final String path) throws IOException {
        ResponseHandler handler = new ResponseHandler(this){

            void handleResponse(Multiplexor.Response response) throws IOException {
                int rlen = response.getLength();
                byte[] data = new byte[rlen];
                response.getInputStream().readFully(data);
                Session.this.result = new String(data, 0, rlen);
                Session.this.responseComplete();
            }

            void sendMessage() throws IOException {
                Session.this.multiplexor.sendMessage(Session.this.handle, 3001, Session.this.bos.toByteArray(), path);
            }
        };
        this.bos.reset();
        this.out.writeShort(queryType);
        for (int i = 0; i < 14; ++i) {
            this.out.writeByte(0);
        }
        this.multiplexor.registerResponseHandler(this.handle, handler);
        handler.sendMessage();
        this.waitForResponse();
        return (String)this.result;
    }

    synchronized String prepare(String[] path, int options, int priority) throws IOException {
        final StringBuffer plist = new StringBuffer();
        for (int i = 0; i < path.length; ++i) {
            plist.append(path[i]);
            plist.append('\n');
        }
        ResponseHandler handler = new ResponseHandler(this){

            void handleResponse(Multiplexor.Response response) throws IOException {
                int rlen = response.getLength();
                byte[] data = new byte[rlen];
                response.getInputStream().readFully(data);
                Session.this.result = new String(data, 0, rlen - 1);
                Session.this.responseComplete();
            }

            void sendMessage() throws IOException {
                Session.this.multiplexor.sendMessage(Session.this.handle, 3021, Session.this.bos.toByteArray(), plist.toString());
            }
        };
        this.bos.reset();
        this.out.writeByte(options);
        this.out.writeByte(priority);
        for (int i = 0; i < 14; ++i) {
            this.out.writeByte(0);
        }
        this.out.flush();
        this.multiplexor.registerResponseHandler(this.handle, handler);
        handler.sendMessage();
        this.waitForResponse();
        return (String)this.result;
    }

    synchronized int open(final String path, int mode, int options) throws IOException {
        ResponseHandler handler = new ResponseHandler(this){

            void handleResponse(Multiplexor.Response response) throws IOException {
                int rlen = response.getLength();
                Session.this.result = new Integer(response.getInputStream().readInt());
                for (int i = 4; i < rlen; ++i) {
                    response.getInputStream().readByte();
                }
                Session.this.responseComplete();
            }

            void sendMessage() throws IOException {
                Session.this.multiplexor.sendMessage(Session.this.handle, 3010, Session.this.bos.toByteArray(), path);
            }
        };
        this.multiplexor.registerResponseHandler(this.handle, handler);
        this.bos.reset();
        this.out.writeShort(mode);
        this.out.writeShort(options);
        for (int i = 0; i < 12; ++i) {
            this.out.writeByte(0);
        }
        this.out.flush();
        handler.sendMessage();
        this.waitForResponse();
        return ((Number)this.result).intValue();
    }

    synchronized void close(int fileHandle) throws IOException {
        ResponseHandler handler = new ResponseHandler(this){

            void sendMessage() throws IOException {
                Session.this.multiplexor.sendMessage(Session.this.handle, 3003, Session.this.bos.toByteArray());
            }
        };
        this.multiplexor.registerResponseHandler(this.handle, handler);
        this.bos.reset();
        this.out.writeInt(fileHandle);
        for (int i = 0; i < 12; ++i) {
            this.out.writeByte(0);
        }
        this.out.flush();
        handler.sendMessage();
        this.waitForResponse();
    }

    synchronized int read(int fileHandle, byte[] buffer, long fileOffset) throws IOException {
        return this.read(fileHandle, buffer, fileOffset, 0, buffer.length);
    }

    synchronized int read(int fileHandle, final byte[] buffer, long fileOffset, final int bufOffset, int size) throws IOException {
        ResponseHandler handler = new ResponseHandler(this){
            private int l;
            {
                super(x0);
                this.l = 0;
            }

            void handleResponse(Multiplexor.Response response) throws IOException {
                int dlen = response.getLength();
                response.getInputStream().readFully(buffer, bufOffset + this.l, dlen);
                this.l += dlen;
                if (response.getStatus() != 4000) {
                    Session.this.result = new Integer(this.l);
                    Session.this.responseComplete();
                }
            }

            void sendMessage() throws IOException {
                Session.this.multiplexor.sendMessage(Session.this.handle, 3013, Session.this.bos.toByteArray());
            }
        };
        this.multiplexor.registerResponseHandler(this.handle, handler);
        this.bos.reset();
        this.out.writeInt(fileHandle);
        this.out.writeLong(fileOffset);
        this.out.writeInt(size);
        this.out.flush();
        handler.sendMessage();
        this.waitForResponse();
        return ((Number)this.result).intValue();
    }

    DaemonInputStream openStream(String path, int mode, int options) throws IOException {
        int fh = this.open(path, mode, options);
        return new XrootdInputStream(this, fh, this.bufferSize);
    }

    synchronized void responseComplete() {
        this.multiplexor.deregisterResponseHandler(this.handle);
        this.exception = null;
        this.notify();
    }

    synchronized void responseComplete(IOException x) {
        this.multiplexor.deregisterResponseHandler(this.handle);
        this.exception = x;
        this.notify();
    }

    private void waitForResponse() throws IOException {
        try {
            this.wait();
            if (this.exception != null) {
                IOException io = new IOException(this.exception.getMessage());
                io.initCause(this.exception);
                throw io;
            }
        }
        catch (InterruptedException x) {
            InterruptedIOException io = new InterruptedIOException("Xrootd IO interrupted");
            io.initCause(x);
            throw io;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

