/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon;

import hep.io.root.daemon.DaemonInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RootProtocol {
    public static final int defaultPort = 1094;
    private static final int kROOTD_USER = 2000;
    private static final int kROOTD_PASS = 2001;
    private static final int kROOTD_AUTH = 2002;
    private static final int kROOTD_FSTAT = 2003;
    private static final int kROOTD_OPEN = 2004;
    private static final int kROOTD_PUT = 2005;
    private static final int kROOTD_GET = 2006;
    private static final int kROOTD_FLUSH = 2007;
    private static final int kROOTD_CLOSE = 2008;
    private static final int kROOTD_STAT = 2009;
    private static final int kROOTD_ACK = 2010;
    private static final int kROOTD_ERR = 2011;
    private static final int kROOTD_PROTOCOL = 2012;
    private static final int kROOTD_SRPUSER = 2013;
    private static final int kROOTD_SRPN = 2014;
    private static final int kROOTD_SRPG = 2015;
    private static final int kROOTD_SRPSALT = 2016;
    private static final int kROOTD_SRPA = 2017;
    private static final int kROOTD_SRPB = 2018;
    private static final int kROOTD_SRPRESPONSE = 2019;
    private static final int kROOTD_PUTFILE = 2020;
    private static final int kROOTD_GETFILE = 2021;
    private static final int kROOTD_CHDIR = 2022;
    private static final int kROOTD_MKDIR = 2023;
    private static final int kROOTD_RMDIR = 2024;
    private static final int kROOTD_LSDIR = 2025;
    private static final int kROOTD_PWD = 2026;
    private static final int kROOTD_MV = 2027;
    private static final int kROOTD_RM = 2028;
    private static final int kROOTD_CHMOD = 2029;
    private static final int kROOTD_KRB5 = 2030;
    private static final int kROOTD_PROTOCOL2 = 2031;
    private static final int kROOTD_BYE = 2032;
    private static final int kROOTD_GLOBUS = 2033;
    private static final int kROOTD_CLEANUP = 2034;
    private static final int kROOTD_SSH = 2035;
    private static final int kROOTD_RFIO = 2036;
    private static final int kROOTD_NEGOTIA = 2037;
    private static final int kROOTD_RSAKEY = 2038;
    private static final int kROOTD_ENCRYPT = 2039;
    private int bufferSize = 8096;
    private static int MAXGETSIZE = -1;
    private static Logger logger = Logger.getLogger("hep.io.root.daemon");
    private Socket socket;
    private Message message;
    private Response response;

    public RootProtocol(String host, int port, String auth, String username, String password) throws IOException {
        if (port == -1) {
            port = 1094;
        }
        logger.fine("Opening rootd connection to: " + host + ":" + port);
        this.socket = new Socket(host, port);
        this.socket.setSoTimeout(Integer.getInteger("root.timeout", 10000));
        OutputStream out = this.socket.getOutputStream();
        DataOutputStream data = new DataOutputStream(out);
        logger.fine("Sending welcome");
        data.writeInt(0);
        data.writeInt(0);
        data.writeInt(0);
        data.flush();
        this.message = new Message(data);
        InputStream in = this.socket.getInputStream();
        DataInputStream dataIn = new DataInputStream(in);
        this.response = new Response(dataIn);
        this.message.send(2012);
        int rc = this.response.read();
        if (this.response.dataAsInt() < 9) {
            throw new IOException("Unexpected response: " + rc + " " + this.response.dataAsInt());
        }
        this.message.send(2031, "9");
        if (this.response.dataAsInt() < 9) {
            throw new IOException("Unexpected response: " + rc + " " + this.response.dataAsInt());
        }
        rc = this.response.read();
        String user = "9999 -1 5 " + username.length() + " " + username;
        this.message.send(2000, user);
        rc = this.response.read();
        this.message.send(2001, password, true);
        while ((rc = this.response.read()) != 2002) {
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String[] fstat() throws IOException {
        this.message.send(2003);
        int rc = this.response.read();
        return this.response.dataAsString().split("\\s+");
    }

    public void open(String file) throws IOException {
        this.message.send(2004, file + " r");
        int rc = this.response.read();
    }

    public DaemonInputStream openStream(long size) {
        return new RootStream(size);
    }

    public String[] ls(String dir) throws IOException {
        int rc;
        this.message.send(2025, dir);
        StringBuffer result = new StringBuffer();
        do {
            rc = this.response.read();
            result.append(this.response.dataAsString());
        } while (rc != 2025);
        return result.toString().split("\n");
    }

    public String pwd() throws IOException {
        this.message.send(2026);
        int rc = this.response.read();
        return this.response.dataAsString();
    }

    public static void main(String[] args) throws IOException {
        RootProtocol rp = new RootProtocol("london.jaws.com", -1, "anonymous", "tonyj@slac", null);
        System.out.println(rp.pwd());
        String[] result = rp.ls("/bin/ls -F");
        for (int i = 0; i < result.length; ++i) {
            System.out.println(result[i]);
        }
    }

    static {
        if (System.getProperty("debugRootDaemon") != null) {
            logger.setLevel(Level.FINE);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setLevel(Level.FINE);
            logger.addHandler(handler);
        }
    }

    private class RootStream
    extends DaemonInputStream {
        private byte[] buffer;
        private int bpos;
        private int blen;
        private long fsize;

        RootStream(long fsize) {
            this.buffer = new byte[RootProtocol.this.bufferSize];
            this.bpos = 0;
            this.blen = 0;
            this.fsize = fsize;
        }

        long getSize() {
            return this.fsize;
        }

        public int read() throws IOException {
            int i;
            if (this.bpos >= this.blen && !this.fillBuffer()) {
                return -1;
            }
            if ((i = this.buffer[this.bpos++]) < 0) {
                i += 256;
            }
            return i;
        }

        public void close() throws IOException {
            RootProtocol.this.message.send(2008);
            RootProtocol.this.socket.close();
        }

        public int read(byte[] values, int offset, int size) throws IOException {
            if (this.bpos >= this.blen) {
                long position = this.position + (long)this.bpos;
                if (position >= this.fsize) {
                    return -1;
                }
                long n = Math.min(this.fsize - position, (long)size);
                if (MAXGETSIZE > 0 && n > (long)MAXGETSIZE) {
                    n = MAXGETSIZE;
                }
                String where = position + " " + n;
                RootProtocol.this.message.send(2006, where);
                int l = RootProtocol.this.response.read(values, offset, (int)n);
                this.position += (long)l;
                return l;
            }
            int l = Math.min(size, this.blen - this.bpos);
            System.arraycopy(this.buffer, this.bpos, values, offset, l);
            this.bpos += l;
            return l;
        }

        public long skip(long skip) throws IOException {
            this.setPosition(this.getPosition() + skip);
            return skip;
        }

        public void setPosition(long pos) {
            if (pos > this.position && pos < this.position + (long)this.blen) {
                this.bpos = (int)(pos - this.position);
            } else {
                this.blen = 0;
                this.bpos = 0;
                super.setPosition(pos);
            }
        }

        public int available() throws IOException {
            return this.blen - this.bpos;
        }

        private boolean fillBuffer() throws IOException {
            this.position += (long)this.bpos;
            this.bpos = 0;
            long n = Math.min(this.fsize - this.position, (long)this.buffer.length);
            if (n <= 0L) {
                return false;
            }
            if (MAXGETSIZE > 0 && n > (long)MAXGETSIZE) {
                n = MAXGETSIZE;
            }
            String where = this.position + " " + n;
            RootProtocol.this.message.send(2006, where);
            this.blen = RootProtocol.this.response.read(this.buffer, 0, (int)n);
            return true;
        }

        public long getPosition() {
            return this.position + (long)this.bpos;
        }
    }

    private static class RootdException
    extends IOException {
        RootdException(Response response) {
            super("Root Deamon exception: " + response.dataAsInt());
        }
    }

    private static class Response {
        private DataInputStream in;
        private int code;
        private int dataLength;
        private byte[] data;

        Response(DataInputStream in) {
            this.in = in;
        }

        int read() throws IOException {
            this.dataLength = this.in.readInt() - 4;
            this.code = this.in.readInt();
            logger.fine("<-" + this.code + " (" + this.dataLength + ") ");
            if (this.data == null || this.dataLength > this.data.length) {
                this.data = new byte[this.dataLength];
            }
            for (int i = 0; i < this.dataLength; ++i) {
                this.data[i] = this.in.readByte();
            }
            if (this.code == 2011) {
                throw new RootdException(this);
            }
            return this.code;
        }

        int read(byte[] values, int offset, int size) throws IOException {
            this.read();
            int n = size;
            while (n > 0) {
                int k = this.in.read(values, offset, n);
                if (k < 0) {
                    throw new IOException("Unexpected end of input");
                }
                n -= k;
                offset += k;
            }
            return size;
        }

        int dataAsInt() {
            int l = this.data[0] << 24;
            l += this.data[1] << 16;
            l += this.data[2] << 8;
            return l += this.data[3];
        }

        String dataAsString() {
            int l = this.dataLength;
            for (int i = 0; i < l; ++i) {
                if (this.data[i] != 0) continue;
                l = i;
                break;
            }
            return new String(this.data, 0, l);
        }
    }

    private static class Message {
        private DataOutputStream data;

        Message(DataOutputStream data) {
            this.data = data;
        }

        void send(int message) throws IOException {
            this.data.writeInt(4);
            this.data.writeInt(message);
            this.data.flush();
        }

        void send(int message, String extra) throws IOException {
            this.send(message, extra, false);
        }

        void send(int message, String extra, boolean invert) throws IOException {
            logger.fine("->" + message + " " + extra);
            byte[] bytes = extra.getBytes();
            if (invert) {
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = ~bytes[i];
                }
            }
            this.data.writeInt(4 + bytes.length + 1);
            this.data.writeInt(message);
            this.data.write(bytes);
            this.data.write(0);
            this.data.flush();
        }
    }
}

