/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootMember;
import hep.io.root.core.BasicMember;
import hep.io.root.core.ClassBuilder;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.NameMangler;
import hep.io.root.core.RootClassFactory;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TObjArray;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class Clones2Builder
implements ClassBuilder,
Constants {
    private static NameMangler nameMangler = NameMangler.instance();
    private Map lMap;
    private TBranch branch;
    private boolean optimize;

    public Clones2Builder(TBranch branch) {
        this.branch = branch;
    }

    public String getStem() {
        return "hep.io.root.clones2";
    }

    public JavaClass build(GenericRootClass klass) {
        String name;
        this.optimize = (klass.getStreamerInfo().getBits() & 0x1000) == 0;
        String className = this.getStem() + "." + klass.getClassName();
        ClassGen cg = new ClassGen(className, "hep/io/root/core/Clones2", "<generated>", 33, null);
        ConstantPoolGen cp = cg.getConstantPool();
        InstructionList il = new InstructionList();
        InstructionFactory factory = new InstructionFactory(cg);
        cg.addEmptyConstructor(1);
        ArrayList<GenericRootClass> sup = new ArrayList<GenericRootClass>();
        RootClass[] superClasses = klass.getSuperClasses();
        this.iterativelyAdd(sup, superClasses);
        sup.add(klass);
        HashMap nameMap = new HashMap();
        TObjArray branches = this.branch.getBranches();
        Iterator j = branches.iterator();
        while (j.hasNext()) {
            TBranch br = (TBranch)j.next();
            TObjArray leaves = br.getLeaves();
            Iterator i = leaves.iterator();
            while (i.hasNext()) {
                Object leaf = i.next();
                name = ((TLeaf)leaf).getName();
                int pos = name.indexOf(91);
                if (pos > 0) {
                    name = name.substring(0, pos);
                }
                if (name.endsWith("_")) {
                    name = name.substring(0, name.length() - 1);
                }
                if ((pos = name.indexOf(".")) > 0) {
                    name = name.substring(pos + 1);
                }
                nameMap.put(name, leaf);
            }
        }
        this.lMap = new HashMap();
        j = sup.iterator();
        while (j.hasNext()) {
            RootClass k = (RootClass)j.next();
            RootMember[] members = k.getMembers();
            for (int i = 0; i < members.length; ++i) {
                Object leaf;
                BasicMember member = (BasicMember)members[i];
                name = member.getName();
                if (name.endsWith("_")) {
                    name = name.substring(0, name.length() - 1);
                }
                if ((leaf = nameMap.remove(name)) == null) {
                    System.out.println("Warning: no leaf for " + member.getName());
                    continue;
                }
                this.lMap.put(member, leaf);
            }
        }
        Iterator<Object> i = nameMap.keySet().iterator();
        while (i.hasNext()) {
            System.out.println("Warning: unused leaf " + i.next());
        }
        i = sup.iterator();
        while (i.hasNext()) {
            this.generateFields((RootClass)i.next(), cp, cg);
        }
        i = sup.iterator();
        while (i.hasNext()) {
            this.generateStaticFields((RootClass)i.next(), cp, cg);
        }
        i = sup.iterator();
        while (i.hasNext()) {
            this.generateMethods((RootClass)i.next(), cp, il, factory, cg, className);
        }
        String cloneName = "hep.io.root.clone2." + klass.getClassName();
        MethodGen mg = new MethodGen(1, new ObjectType("hep.io.root.core.Clone2"), null, null, "createClone", className, il, cp);
        il.append(factory.createNew(new ObjectType(cloneName)));
        il.append(InstructionConstants.DUP);
        il.append(factory.createInvoke(cloneName, "<init>", Type.VOID, Type.NO_ARGS, (short)183));
        il.append(InstructionConstants.ARETURN);
        mg.setMaxStack();
        mg.setMaxLocals();
        cg.addMethod(mg.getMethod());
        il.dispose();
        MethodGen mg2 = new MethodGen(4, Type.VOID, null, null, "clearCache", className, il, cp);
        Iterator j2 = sup.iterator();
        while (j2.hasNext()) {
            RootClass k = (RootClass)j2.next();
            RootMember[] members = k.getMembers();
            for (int i2 = 0; i2 < members.length; ++i2) {
                BasicMember member = (BasicMember)members[i2];
                TLeaf leaf = (TLeaf)this.lMap.get(member);
                Type type = member.getJavaType();
                ArrayType arrayType = new ArrayType(type, 1);
                il.append(InstructionConstants.ALOAD_0);
                il.append(InstructionConstants.ACONST_NULL);
                il.append(factory.createPutField(className, member.getName(), arrayType));
            }
        }
        il.append(InstructionConstants.RETURN);
        mg2.setMaxStack();
        mg2.setMaxLocals();
        cg.addMethod(mg2.getMethod());
        il.dispose();
        return cg.getJavaClass();
    }

    public void populateStatics(Class hollowClass, RootClassFactory factory) {
        try {
            Iterator i = this.lMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                BasicMember member = (BasicMember)entry.getKey();
                Object l = entry.getValue();
                Field field = hollowClass.getField(member.getName() + "Leaf");
                field.set(null, l);
            }
        }
        catch (Exception x) {
            throw new RuntimeException("Error populating statics ", x);
        }
    }

    private void generateFields(RootClass k, ConstantPoolGen cp, ClassGen cg) {
        if (k.getClassName().equals("TObject") && this.optimize) {
            return;
        }
        RootMember[] members = k.getMembers();
        for (int i = 0; i < members.length; ++i) {
            BasicMember member = (BasicMember)members[i];
            Type type = ((BasicMember)members[i]).getJavaType();
            type = new ArrayType(type, 1);
            FieldGen fg = new FieldGen(2, type, members[i].getName(), cp);
            cg.addField(fg.getField());
        }
    }

    private void generateMethods(RootClass k, ConstantPoolGen cp, InstructionList il, InstructionFactory factory, ClassGen cg, String className) {
        RootMember[] members = k.getMembers();
        for (int i = 0; i < members.length; ++i) {
            BasicMember member = (BasicMember)members[i];
            TLeaf leaf = (TLeaf)this.lMap.get(member);
            if (leaf == null) continue;
            String leafClassName = leaf.getClass().getName();
            Type type = member.getJavaType();
            ArrayType arrayType = new ArrayType(type, 1);
            MethodGen mg = new MethodGen(1, type, new Type[]{Type.INT}, new String[]{"index"}, nameMangler.mangleMember(member.getName()), className, il, cp);
            il.append(InstructionConstants.ALOAD_0);
            il.append(factory.createGetField(className, member.getName(), arrayType));
            il.append(InstructionFactory.DUP);
            BranchHandle bh = il.append(new IFNONNULL(null));
            il.append(InstructionFactory.POP);
            il.append(factory.createGetStatic(className, member.getName() + "Leaf", new ObjectType(leafClassName)));
            il.append(InstructionConstants.ALOAD_0);
            il.append(factory.createGetField("hep.io.root.core.Clones2", "hollowIndex", Type.LONG));
            il.append(factory.createInvoke(leafClassName, "setPosition", new ObjectType("hep.io.root.core.RootInput"), new Type[]{Type.LONG}, (short)182));
            il.append(InstructionConstants.ALOAD_0);
            il.append(factory.createGetField("hep.io.root.core.Clones2", "size", Type.INT));
            il.append(factory.createNewArray(type, (short)1));
            il.append(InstructionConstants.DUP_X1);
            il.append(factory.createInvoke("hep.io.root.core.RootInput", "readFixedArray", Type.VOID, new Type[]{arrayType}, (short)185));
            il.append(InstructionConstants.DUP);
            il.append(InstructionConstants.ALOAD_0);
            il.append(InstructionConstants.SWAP);
            il.append(factory.createPutField(className, member.getName(), arrayType));
            bh.setTarget(il.append(InstructionConstants.ILOAD_1));
            il.append(InstructionFactory.createArrayLoad(type));
            il.append(InstructionFactory.createReturn(type));
            mg.setMaxStack();
            mg.setMaxLocals();
            cg.addMethod(mg.getMethod());
            il.dispose();
        }
    }

    private void generateStaticFields(RootClass k, ConstantPoolGen cp, ClassGen cg) {
        RootMember[] members = k.getMembers();
        for (int i = 0; i < members.length; ++i) {
            BasicMember member = (BasicMember)members[i];
            TLeaf leaf = (TLeaf)this.lMap.get(member);
            if (leaf == null) continue;
            ObjectType type = new ObjectType(leaf.getClass().getName());
            FieldGen fg = new FieldGen(9, type, member.getName() + "Leaf", cp);
            cg.addField(fg.getField());
        }
    }

    private void iterativelyAdd(List list, RootClass[] superClasses) {
        for (int i = 0; i < superClasses.length; ++i) {
            RootClass[] supsup = superClasses[i].getSuperClasses();
            this.iterativelyAdd(list, supsup);
            list.add(superClasses[i]);
        }
    }
}

