/*
 * Decompiled with CFR 0.152.
 */
package hep.io.hbook;

import hep.io.hbook.CompositeHbookObject;
import hep.io.hbook.Hbook;
import hep.io.hbook.HbookObject;

public class TwoDHistogram
extends HbookObject {
    private float xmax;
    private float xmin;
    private float ymax;
    private float ymin;
    private int nent;
    private int id;
    private int idx;
    private int xbins;
    private int ybins;
    private float xmean;
    private float ymean;
    private float xrms;
    private float yrms;
    private float xequiv;
    private float yequiv;

    TwoDHistogram(CompositeHbookObject parent, String name, int id, int idx, int xbins, float xmin, float xmax, int ybins, float ymin, float ymax, int nent, float xmean, float ymean, float xrms, float yrms, float xequiv, float yequiv) {
        super(parent, name);
        this.id = id;
        this.idx = idx;
        this.xmin = xmin;
        this.xmax = xmax;
        this.xbins = xbins;
        this.ymin = ymin;
        this.ymax = ymax;
        this.ybins = ybins;
        this.nent = nent;
        this.xmean = xmean;
        this.ymean = ymean;
        this.xrms = xrms;
        this.yrms = yrms;
        this.xequiv = xequiv;
        this.yequiv = yequiv;
    }

    void close() {
        super.close();
        if (this.id >= 0) {
            Hbook.delete(this.id);
        }
        this.id = -1;
    }

    public void finalize() {
        this.close();
    }

    public String toString() {
        String result = "2D Histogram: " + this.idx + " " + this.getName();
        return result;
    }

    public float getXMin() {
        return this.xmin;
    }

    public float getXMax() {
        return this.xmax;
    }

    public int getXNBins() {
        return this.xbins;
    }

    public float getYMin() {
        return this.ymin;
    }

    public float getYMax() {
        return this.ymax;
    }

    public int getYNBins() {
        return this.ybins;
    }

    public float getXMean() {
        return this.xmean;
    }

    public float getYMean() {
        return this.ymean;
    }

    public float getXRMS() {
        return this.xrms;
    }

    public float getYRMS() {
        return this.yrms;
    }

    public float getXEquivBinEntries() {
        return this.xequiv;
    }

    public float getYEquivBinEntries() {
        return this.yequiv;
    }

    public int getNEntries() {
        return this.nent;
    }

    public double[][] getBins() {
        return Hbook.Hist2DData(this.id, this.xbins, this.ybins);
    }

    public double[][] getErrors() {
        return Hbook.Hist2DErrors(this.id, this.xbins, this.ybins);
    }

    public int id() {
        return this.idx;
    }
}

