/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml.converters;

import hep.aida.ref.xml.converters.AsciiToZipHandler;
import hep.aida.ref.xml.converters.BinaryToZipHandler;
import hep.aida.ref.xml.converters.CommandHandler;
import hep.aida.ref.xml.converters.FromAsciiHandler;
import hep.aida.ref.xml.converters.FromBinaryHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.freehep.util.argv.ArgumentFormatException;
import org.freehep.util.argv.ArgumentParser;
import org.freehep.util.argv.BooleanOption;
import org.freehep.util.argv.MissingArgumentException;
import org.freehep.util.argv.StringParameter;
import org.xml.sax.SAXException;

public class ConvertHandler
implements CommandHandler {
    public void run(List args) {
        BooleanOption help = new BooleanOption("-help", "-h", "Show this help page", true);
        BooleanOption binary = new BooleanOption("-binary", "-b", "Write destination (zip)file in 'binary' format");
        BooleanOption zip = new BooleanOption("-zip", "-b", "Write destination file in 'zip' format");
        StringParameter in = new StringParameter("from", "Source file to convert from");
        StringParameter out = new StringParameter("to", "Destination file to convert to");
        ArgumentParser parser = new ArgumentParser("aida convert");
        parser.add(help);
        parser.add(binary);
        parser.add(zip);
        parser.add(in);
        parser.add(out);
        try {
            List extra = parser.parse(args);
            if (!extra.isEmpty() || help.getValue()) {
                parser.printUsage(System.out);
                return;
            }
        }
        catch (MissingArgumentException e) {
            parser.printUsage(System.out);
            return;
        }
        catch (ArgumentFormatException e) {
            parser.printUsage(System.out);
            return;
        }
        try {
            InputStream ins = new FileInputStream(in.getValue());
            byte[] magic = new byte[4];
            PushbackInputStream pin = new PushbackInputStream(ins, magic.length);
            int b = pin.read(magic);
            if (b != magic.length) {
                throw new IOException("Unexpected EOF");
            }
            pin.unread(magic);
            if ((magic[0] & 0xFF) == 31 && (magic[1] & 0xFF) == 139) {
                b = (pin = new PushbackInputStream(new GZIPInputStream(pin), magic.length)).read(magic);
                if (b != magic.length) {
                    throw new IOException("Unexpected EOF");
                }
                pin.unread(magic);
            }
            ins = pin;
            boolean isBinary = (magic[0] & 0xFF) == 3 && (magic[1] & 0xFF) == 0 && (magic[2] & 0xFF) == 0 && (magic[3] & 0xFF) == 106;
            ins = new BufferedInputStream(ins);
            FileOutputStream outs = new FileOutputStream(out.getValue());
            if (isBinary) {
                if (zip.getValue()) {
                    BinaryToZipHandler handler = new BinaryToZipHandler();
                    handler.convert(in.getValue(), out.getValue(), binary.getValue());
                } else {
                    FromBinaryHandler handler = new FromBinaryHandler();
                    handler.convert(ins, outs, binary.getValue());
                }
            } else if (zip.getValue()) {
                AsciiToZipHandler handler = new AsciiToZipHandler();
                handler.convert(in.getValue(), out.getValue(), binary.getValue());
            } else {
                FromAsciiHandler handler = new FromAsciiHandler();
                handler.convert(ins, outs, binary.getValue());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

