/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.server;

import hep.aida.IAnalysisFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.ITreeFactory;
import hep.aida.dev.IDevTree;
import hep.aida.ref.remote.RemoteConnectionException;
import hep.aida.ref.remote.RemoteServer;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaTreeServer;
import hep.aida.ref.remote.rmi.RmiRemoteUtils;
import hep.aida.ref.remote.rmi.client.RmiStoreFactory;
import hep.aida.ref.remote.rmi.interfaces.RmiClient;
import hep.aida.ref.remote.rmi.interfaces.RmiServant;
import hep.aida.ref.remote.rmi.interfaces.RmiServer;
import hep.aida.ref.remote.rmi.server.RmiServantImpl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RmiServerImpl
extends UnicastRemoteObject
implements RmiServer {
    static final long serialVersionUID = 5979753791192166996L;
    private AidaTreeServer aidaServer;
    private int port = RmiRemoteUtils.port;
    private String currentHost = null;
    private String bindName;
    private boolean useValidation;
    private Map servants;
    private transient Logger remoteLogger;

    public RmiServerImpl(AidaTreeServer aidaServer) throws MalformedURLException, RemoteException, UnknownHostException {
        this(aidaServer, null);
    }

    public RmiServerImpl(AidaTreeServer aidaServer, String bindName) throws MalformedURLException, RemoteException, UnknownHostException {
        this.aidaServer = aidaServer;
        this.bindName = bindName;
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        this.remoteLogger.setLevel(Level.SEVERE);
        this.servants = new Hashtable();
        this.currentHost = InetAddress.getLocalHost().getHostName();
        this.port = RmiRemoteUtils.port;
        this.useValidation = true;
        this.connect();
    }

    public synchronized void setUseValidation(boolean state) {
        this.useValidation = state;
    }

    public void connect() throws MalformedURLException, RemoteException, UnknownHostException {
        if (this.bindName == null) {
            this.bindName = this.createBindName();
        } else {
            int index = this.bindName.indexOf(":");
            if (index > 0) {
                String portString = this.bindName.substring(index + 1);
                int index2 = portString.indexOf("/");
                if (index2 > 0) {
                    portString = portString.substring(0, index2);
                }
                try {
                    int tmpPort;
                    this.port = tmpPort = Integer.parseInt(portString);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        this.remoteLogger.fine("RmiServer: Binding in Registry: " + this.bindName + ", port=" + this.port);
        try {
            Naming.rebind(this.bindName, this);
        }
        catch (ConnectException co) {
            this.remoteLogger.fine("RmiServer: No RMI Registry is currently available for port=" + this.port + ". Starting new RMI Registry.");
            LocateRegistry.createRegistry(this.port);
            Naming.rebind(this.bindName, this);
        }
        this.remoteLogger.info("RmiServer ready at rmi:" + this.bindName);
    }

    public void unbind() {
        try {
            this.remoteLogger.fine("RmiServer: unbinding server from Registry: " + this.bindName + ", port=" + this.port);
            Naming.unbind(this.bindName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.remoteLogger.fine("RmiServer.disconnect: Start");
        this.unbind();
        Map map = this.servants;
        synchronized (map) {
            try {
                if (!this.servants.isEmpty()) {
                    Set s = this.servants.keySet();
                    Object[] arr = new Object[s.size()];
                    s.toArray(arr);
                    for (int i = 0; i < arr.length; ++i) {
                        Object clientRef = arr[i];
                        try {
                            this.unRegisterServant(clientRef);
                            continue;
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                    }
                    s.clear();
                    this.servants.clear();
                }
                RmiServerImpl.unexportObject(this, true);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.remoteLogger.finest("RmiServer.disconnect: Finish");
        this.servants = null;
        this.aidaServer = null;
    }

    private String createBindName() {
        String name = "/RmiAidaServer";
        String dateString = RmiRemoteUtils.getCurrentDateString();
        name = "//" + this.currentHost + ":" + this.port + name + "/" + dateString;
        return name;
    }

    private boolean checkServant(Object key) throws RemoteException {
        boolean ok = false;
        if (this.servants.containsKey(key)) {
            ok = true;
        }
        return ok;
    }

    private void registerServant(Object key, RmiServantImpl rmiServant) throws RemoteException {
        this.servants.put(key, rmiServant);
    }

    private boolean unRegisterServant(Object key) throws RemoteException {
        RmiServantImpl rmiServant = (RmiServantImpl)this.servants.remove(key);
        if (rmiServant == null) {
            return false;
        }
        rmiServant.disconnect();
        return true;
    }

    public String getBindName() throws RemoteException {
        return this.bindName;
    }

    public RmiServant connectDuplex(RmiClient client) throws RemoteException {
        RmiServantImpl rmiServant = null;
        if (this.checkServant(client)) {
            String clientRef = client.toString();
            if (client instanceof RmiClient) {
                clientRef = client.getBindName();
            }
            throw new RemoteConnectionException("This client is already connected. Please disconnect first.\nClient: " + clientRef);
        }
        rmiServant = new RmiServantImpl(client);
        rmiServant.setUseValidation(this.useValidation);
        AidaTreeServant aidaServant = this.aidaServer.connectDuplex(rmiServant);
        if (aidaServant == null) {
            throw new RemoteConnectionException("Can not connect to Server: " + this.aidaServer.treeName());
        }
        rmiServant.setAidaTreeServant(aidaServant);
        this.registerServant(client, rmiServant);
        return rmiServant;
    }

    public RmiServant connectNonDuplex(String clientID) throws RemoteException {
        if (this.checkServant(clientID)) {
            throw new RemoteConnectionException("This client is already connected. Please disconnect first.\nClient: " + clientID);
        }
        AidaTreeServant aidaServant = this.aidaServer.connectNonDuplex(clientID);
        if (aidaServant == null) {
            throw new RemoteConnectionException("Can not connect to Server: " + this.aidaServer.treeName());
        }
        RmiServantImpl rmiServant = new RmiServantImpl();
        rmiServant.setUseValidation(this.useValidation);
        rmiServant.setAidaTreeServant(aidaServant);
        this.registerServant(clientID, rmiServant);
        return rmiServant;
    }

    public boolean disconnectDuplex(RmiClient client) throws RemoteException {
        if (!this.checkServant(client)) {
            String clientRef = client.toString();
            if (client instanceof RmiClient) {
                clientRef = client.getBindName();
            }
            throw new RemoteConnectionException("This client is not connected.\nClient: " + clientRef);
        }
        RmiServantImpl rmiServant = (RmiServantImpl)this.servants.get(client);
        boolean ok = this.aidaServer.disconnectDuplex(rmiServant);
        return this.unRegisterServant(client) && ok;
    }

    public boolean disconnectNonDuplex(String clientID) throws RemoteException {
        if (!this.checkServant(clientID)) {
            throw new RemoteConnectionException("This client is not connected.\nClient: " + clientID);
        }
        boolean ok = this.aidaServer.disconnectNonDuplex(clientID);
        return this.unRegisterServant(clientID) && ok;
    }

    public boolean supportDuplexMode() throws RemoteException {
        return this.aidaServer.supportDuplexMode();
    }

    public String treeName() throws RemoteException {
        return this.aidaServer.treeName();
    }

    public static void main(String[] args) throws Exception {
        RmiStoreFactory rsf = new RmiStoreFactory();
        System.out.println("Creating AIDA server tree");
        IAnalysisFactory anf = IAnalysisFactory.create();
        ITreeFactory tf = anf.createTreeFactory();
        IDevTree tree = (IDevTree)tf.create();
        System.out.println("Populating AIDA server tree");
        Vector<IHistogram1D> hist1D = new Vector<IHistogram1D>();
        tree.mkdirs("/dir1-1");
        tree.mkdirs("/dir1-2");
        tree.mkdirs("/dir1-1/dir2-1/dir3-1");
        tree.mkdirs("/dir1-1/dir2-2");
        tree.mkdirs("/dir1-2/dir2-1");
        IHistogramFactory hf = anf.createHistogramFactory(tree);
        tree.cd("/dir1-1");
        hist1D.add(hf.createHistogram1D("Hist1D 1", "Flat Histogram 1", 50, 0.0, 0.9));
        tree.cd("/dir1-2/dir2-1");
        hist1D.add(hf.createHistogram1D("Hist1D 2", "Flat Histogram 2", 50, 0.1, 1.0));
        hist1D.add(hf.createHistogram1D("Hist1D 3", "Gauss Histogram 3", 50, -3.0, 3.0));
        tree.cd("/dir1-1/dir2-1/dir3-1");
        hist1D.add(hf.createHistogram1D("Hist1D 4", "Gauss Histogram 4", 50, -3.0, 3.0));
        tree.cd("/dir1-1/dir2-2");
        System.out.println("Updating histograms in AIDA server tree");
        Random r = new Random();
        for (int k = 0; k < hist1D.size(); ++k) {
            for (int i = 0; i < 1000; ++i) {
                IHistogram1D h1D = (IHistogram1D)hist1D.get(k);
                h1D.fill(r.nextDouble());
            }
        }
        System.out.println("Creating RemoteServer");
        RemoteServer treeServer = new RemoteServer(tree);
        treeServer.setBlocking(true);
        System.out.println("Creating RmiServer");
        RmiServerImpl rmiTreeServer = new RmiServerImpl(treeServer);
        String clientName = "RmiClientTree";
        String bindName = rmiTreeServer.getBindName();
        String options = "duplex=\"false\",RmiServerName=\"" + bindName + "\"";
        System.out.println("\n\nInput: u - update histograms, a - add histogram to a tree, d - delete last added histogram, e - exit");
        System.out.print("> ");
        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
        String input = null;
        while ((input = console.readLine()) != null) {
            try {
                if (input.equalsIgnoreCase("e")) {
                    System.exit(1);
                } else if (input.equalsIgnoreCase("u")) {
                    for (int k = 0; k < hist1D.size(); ++k) {
                        for (int i = 0; i < 1000; ++i) {
                            IHistogram1D h1D = (IHistogram1D)hist1D.get(k);
                            h1D.fill(r.nextDouble());
                        }
                    }
                } else if (input.equalsIgnoreCase("a")) {
                    int id = hist1D.size() + 1;
                    hist1D.add(hf.createHistogram1D("Extra Hist1D " + id, "Extra Flat Histogram id=" + id, 50, 0.1, 0.9));
                } else if (input.equalsIgnoreCase("d")) {
                    int id = hist1D.size() - 1;
                    IManagedObject h1D = (IManagedObject)hist1D.remove(id);
                    String path = tree.findPath(h1D);
                    tree.rm(path);
                } else {
                    System.out.println("Wrong input: " + input);
                    System.out.println("\n\nInput: u - update histograms, a - add histogram to a tree, d - delete last added histogram, e - exit");
                }
                System.out.print("> ");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\n\nInput: u - update histograms, a - add histogram to a tree, d - delete last added histogram, e - exit");
                System.out.print("> ");
            }
        }
    }
}

