/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.corba;

import hep.aida.ref.remote.corba.generated.EventStruct;
import hep.aida.ref.remote.corba.generated.TreeClient;
import java.util.ArrayList;
import java.util.List;

public class CorbaServerEventQueue
implements Runnable {
    protected List queue = new ArrayList(100);
    protected boolean keepRunning = true;
    protected EventStruct[] emptyEvents = new EventStruct[0];
    protected TreeClient treeClient;

    public CorbaServerEventQueue() {
    }

    public CorbaServerEventQueue(TreeClient treeClient) {
        this.treeClient = treeClient;
        if (treeClient != null) {
            new Thread(this).start();
        }
    }

    public synchronized void close() {
        this.keepRunning = false;
        this.queue.clear();
        this.notify();
    }

    public int size() {
        return this.queue == null ? 0 : this.queue.size();
    }

    public void schedule(EventStruct event) {
        System.out.println("ServerQueue.schedule id=" + event.id + ", path=" + event.path + ", type=" + event.nodeType);
        if (this.keepRunning) {
            this.addToQueue(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventStruct[] getEvents() {
        int size = this.size();
        if (size == 0) {
            return this.emptyEvents;
        }
        EventStruct[] events = null;
        CorbaServerEventQueue corbaServerEventQueue = this;
        synchronized (corbaServerEventQueue) {
            size = this.queue.size();
            events = new EventStruct[size];
            this.queue.toArray(events);
            this.queue.clear();
        }
        return events;
    }

    protected synchronized void addToQueue(EventStruct event) {
        this.queue.add(event);
        System.out.println("ServerQueue.addToQueue queue size=" + this.queue.size() + ", path=" + event.path + ", type=" + event.nodeType);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int size = 0;
        EventStruct[] events = null;
        while (this.keepRunning) {
            try {
                CorbaServerEventQueue corbaServerEventQueue = this;
                synchronized (corbaServerEventQueue) {
                    if (this.queue.size() == 0) {
                        this.wait();
                    }
                    if ((size = this.queue.size()) > 0) {
                        events = this.getEvents();
                    }
                }
                System.out.println("UpdatableQueue.run Processing: " + size);
                if (events == null || events.length == 0) {
                    return;
                }
                this.treeClient.stateChanged(events);
            }
            catch (InterruptedException e2) {
                System.out.println("UpdatableQueue Thread InterruptedException.");
                e2.printStackTrace();
            }
            catch (Exception e3) {
                System.out.println("Problems in CorbaServerEventQueue!.");
                e3.printStackTrace();
            }
        }
    }
}

