/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.ref.plotter.style.registry.IStyleStore;
import hep.aida.ref.plotter.style.registry.StyleRegistry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.freehep.util.FreeHEPLookup;
import org.jdom.JDOMException;
import org.openide.util.Lookup;

public class OpenStyleStorePanel
extends JPanel {
    private Component parent;
    private String title;
    private JPanel thisPanel;
    private JComboBox storeList;
    private JButton update;
    private Vector list;
    private Map map;

    public OpenStyleStorePanel() {
        this("Open Style Store");
    }

    public OpenStyleStorePanel(Component parent) {
        this(parent, "Open Style Store");
    }

    public OpenStyleStorePanel(String title) {
        this(null, title);
    }

    public OpenStyleStorePanel(Component parent, String title) {
        this.parent = parent;
        this.title = title;
        this.thisPanel = this;
        this.initComponents();
    }

    private void initComponents() {
        this.list = new Vector();
        this.map = new HashMap();
        this.update = new JButton("Update");
        this.update.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                OpenStyleStorePanel.this.updateAction();
            }
        });
        this.storeList = new JComboBox();
        this.setBorder(new TitledBorder(new EtchedBorder(), this.title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.add((Component)new JLabel(" Store: "), gbc);
        gbc.gridx = 1;
        this.add((Component)this.storeList, gbc);
        gbc.gridx = 2;
        this.add((Component)this.update, gbc);
        this.updateAction();
    }

    public void updateAction() {
        this.list.clear();
        this.map.clear();
        StyleRegistry registry = StyleRegistry.getStyleRegistry();
        String[] stores = registry.getAvailableStoreNames();
        if (stores != null) {
            for (int i = 0; i < stores.length; ++i) {
                this.map.put(stores[i], registry.getStore(stores[i]));
                this.list.add(stores[i]);
            }
        }
        Lookup.Template template = new Lookup.Template(IStyleStore.class);
        Lookup.Result result = FreeHEPLookup.instance().lookup(template);
        Iterator i = result.allInstances().iterator();
        while (i.hasNext()) {
            IStyleStore store = (IStyleStore)i.next();
            if (store == null || this.map.containsValue(store)) continue;
            this.map.put(store.getStoreName(), store);
            this.list.add(store.getStoreName());
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(this.list);
        this.storeList.setModel(model);
    }

    public IStyleStore openStore() throws IOException, JDOMException {
        int reply;
        this.updateAction();
        IStyleStore store = null;
        Component comp = this.parent;
        if (comp == null) {
            comp = SwingUtilities.getAncestorOfClass(Frame.class, this);
        }
        if ((reply = JOptionPane.showOptionDialog(comp, this, this.title, 0, -1, null, new String[]{"Ok", "Cancel"}, "Cancel")) == 0) {
            String name = this.storeList.getSelectedItem() instanceof String ? (String)this.storeList.getSelectedItem() : this.storeList.getSelectedItem().toString();
            store = (IStyleStore)this.map.get(name);
        }
        return store;
    }
}

