/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import com.l2fprod.common.propertysheet.PropertySheetTable;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import com.l2fprod.common.swing.renderer.ColorCellRenderer;
import hep.aida.ref.plotter.style.editor.StyleProperty;
import hep.aida.ref.plotter.style.editor.StylePropertyEditColumnEditor;
import hep.aida.ref.plotter.style.editor.StylePropertyState;
import hep.aida.ref.plotter.style.editor.StylePropertyTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.freehep.swing.ColorConverter;

public class StylePropertyTable
extends PropertySheetTable {
    public StylePropertyTable(StylePropertyTableModel dm) {
        super(dm);
        this.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.getColumnModel().getColumn(2).setMaxWidth(60);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer tcr = null;
        Object value = this.getValueAt(row, 1);
        if (column == 2) {
            if (value instanceof StylePropertyState) {
                DefaultTableCellRenderer cr = new DefaultTableCellRenderer();
                cr.setBackground(Color.yellow);
                cr.setAlignmentX(0.5f);
                return cr;
            }
            tcr = super.getCellRenderer(row, column);
        } else if (column == 1) {
            tcr = value instanceof StylePropertyState && ((StylePropertyState)value).type == Color.class ? new ColorCellRenderer(){

                protected String convertToString(Object value) {
                    Color c = null;
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof StylePropertyState) {
                        try {
                            Object val = ((StylePropertyState)value).currentValue;
                            if (val == null) {
                                val = ((StylePropertyState)value).defaultValue;
                            }
                            if (val == null) {
                                return null;
                            }
                            c = ColorConverter.get((String)val);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        c = (Color)value;
                    }
                    return ColorConverter.get(c);
                }

                protected Icon convertToIcon(Object value) {
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof StylePropertyState) {
                        Color c = null;
                        try {
                            Object val = ((StylePropertyState)value).currentValue;
                            if (val == null) {
                                val = ((StylePropertyState)value).defaultValue;
                            }
                            if (val == null) {
                                return null;
                            }
                            c = ColorConverter.get((String)val);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return super.convertToIcon(c);
                    }
                    return super.convertToIcon(value);
                }
            } : super.getCellRenderer(row, column);
        } else if (column == 0) {
            tcr = super.getCellRenderer(row, column);
            return new StyleTableCellRenderer(tcr);
        }
        return tcr;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 2) {
            if (this.getValueAt(row, 1) instanceof StylePropertyState) {
                return new StylePropertyEditColumnEditor(this, row, column);
            }
            return null;
        }
        return super.getCellEditor(row, column);
    }

    class StyleTableCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer tcr;

        StyleTableCellRenderer(TableCellRenderer tcr) {
            this.tcr = tcr;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tcr.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            Font font = c.getFont();
            String propertyName = null;
            if (font != null) {
                boolean normal = !font.isItalic();
                String name = font.getName();
                int size = font.getSize();
                int style = 0;
                boolean isSet = false;
                boolean isSetHere = false;
                StyleProperty sp = null;
                if (value instanceof StyleProperty) {
                    sp = (StyleProperty)value;
                } else if (value instanceof PropertySheetTableModel.Item) {
                    sp = (StyleProperty)((PropertySheetTableModel.Item)value).getProperty();
                }
                if (sp != null) {
                    isSet = sp.isParameterSet(true);
                    isSetHere = sp.isParameterSet(false);
                    propertyName = sp.getName();
                }
                if (isSetHere) {
                    style = 0;
                    if (isSelected) {
                        c.setForeground(Color.white);
                    } else {
                        c.setForeground(Color.black);
                    }
                } else if (isSet) {
                    style = 0;
                    if (isSelected) {
                        c.setForeground(Color.green);
                    } else {
                        c.setForeground(Color.blue);
                    }
                } else {
                    style = 2;
                    if (isSelected) {
                        c.setForeground(Color.yellow);
                    } else {
                        c.setForeground(Color.red);
                    }
                }
                Font newFont = new Font(name, style, size);
                c.setFont(newFont);
            }
            return c;
        }
    }
}

