/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import com.l2fprod.common.propertysheet.DefaultProperty;
import hep.aida.IBaseStyle;
import hep.aida.ref.plotter.AbstractStyleParameter;
import hep.aida.ref.plotter.BaseStyle;
import hep.aida.ref.plotter.RevolvingStyleParameter;
import hep.aida.ref.plotter.style.editor.StylePropertyState;
import java.awt.Color;
import java.awt.Font;
import java.util.logging.Logger;
import org.freehep.swing.ColorConverter;

public class StyleProperty
extends DefaultProperty {
    private boolean firstTime = true;
    private BaseStyle style;
    private Logger styleLogger;

    StyleProperty(IBaseStyle style, String parameterName) {
        this.style = (BaseStyle)style;
        this.styleLogger = Logger.getLogger("hep.aida.ref.plotter.style.editor");
        this.init(parameterName);
        this.firstTime = false;
    }

    void init(String parameterName) {
        this.setName(parameterName);
        this.setEditable(true);
        this.readFromObject(this.style);
    }

    public boolean isParameterSet() {
        return this.isParameterSet(true);
    }

    public boolean isParameterSet(boolean recursive) {
        boolean ok = false;
        try {
            ok = this.style.isParameterSet(this.getName(), recursive);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ok;
    }

    public String[] getAvailableValues() {
        return this.style.availableParameterOptions(this.getName());
    }

    public AbstractStyleParameter getParameter() {
        return this.style.parameter(this.getName());
    }

    public void readFromObject(Object object) {
        String parameterName = this.getName();
        this.setDisplayName(parameterName);
        Class t = this.style.parameter(parameterName).type();
        String val = null;
        val = this.style.isParameterSet(parameterName, false) ? this.style.parameter(parameterName).parValue() : this.style.parameterValue(parameterName);
        String def = this.style.parameter(parameterName).defaultValue();
        Object[] options = this.style.availableParameterOptions(parameterName);
        if (options != null && options.length > 0) {
            this.setCategory("preset");
        }
        int ci = -1;
        int di = -1;
        Object objValue = new StylePropertyState(ci, val, options, di, def, t);
        ((StylePropertyState)objValue).setIndex();
        this.styleLogger.fine("StyleProperty.readFromObject: Style=" + this.style.name() + ", parameter=" + parameterName + ", value=" + val + ", type=" + t);
        if (this.getParameter() instanceof RevolvingStyleParameter) {
            this.setCategory("rotating");
        } else if (t == String.class) {
            this.setCategory("string");
        } else if (t == Color.class) {
            this.setCategory("color");
        } else if (t == Font.class) {
            this.setCategory("font");
        } else if (t == Boolean.TYPE) {
            this.setCategory("boolean");
            objValue = Boolean.valueOf(val);
        } else if (t == Double.TYPE) {
            this.setCategory("double");
        } else if (t == Float.TYPE) {
            this.setCategory("float");
        } else if (t == Integer.TYPE) {
            this.setCategory("integer");
        } else {
            throw new RuntimeException("**** Unknown type of parameter: name=" + parameterName + ", type=" + t);
        }
        this.setType(t);
        String tmpVal = objValue == null ? "null" : objValue.toString();
        String tmpClass = objValue == null ? "null" : objValue.getClass().getName();
        this.styleLogger.fine("ReadFromObject: " + tmpVal + ", Object=" + tmpClass);
        this.setValue(objValue);
    }

    public void writeToObject(Object object) {
        this.styleLogger.fine("StyleProperty.writeToObject: Style=" + this.style.name() + ", Object=" + object);
    }

    public void setValue(Object newValue) {
        Object oldValue = null;
        String classString = newValue == null ? "null" : newValue.getClass().getName();
        this.styleLogger.fine("StyleProperty.setValue: Style=" + this.style.name() + ", parameter=" + this.getName() + ", newValue=" + newValue + ", oldValue=" + oldValue + ", Class " + classString);
        if (!this.firstTime) {
            this.fillStyle(newValue);
        }
        super.setValue(newValue);
    }

    void fillStyle(Object newValue) {
        String parameterName = this.getName();
        Class t = this.getType();
        String[] options = null;
        String oldString = newValue == null ? "null" : newValue.getClass().getName();
        String val = null;
        String def = null;
        if (newValue == null) {
            val = null;
        } else if (newValue instanceof StylePropertyState) {
            val = (String)((StylePropertyState)newValue).currentValue;
            def = (String)((StylePropertyState)newValue).defaultValue;
            options = (String[])((StylePropertyState)newValue).values;
        } else if (newValue instanceof Boolean) {
            val = newValue.toString();
        } else if (newValue instanceof Color) {
            val = ColorConverter.get((Color)newValue);
        } else if (newValue instanceof Double) {
            val = newValue.toString();
        } else if (newValue instanceof Integer) {
            val = newValue.toString();
        } else if (newValue instanceof String) {
            val = (String)newValue;
        } else {
            throw new RuntimeException("Unknown return type of parameter: name=" + parameterName + ", type=" + newValue);
        }
        String oldValue = this.style.parameterValue(parameterName);
        this.styleLogger.fine("StyleProperty.fillStyle: Style=" + this.style.name() + ", parameter=" + parameterName + ", newValue=" + val + ", oldValue=" + oldValue);
        this.style.setParameterDefault(parameterName, def);
        if (newValue instanceof StylePropertyState) {
            this.style.setParameter(parameterName, val, options);
        } else {
            this.style.setParameter(parameterName, val);
        }
    }
}

