/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAxis;
import hep.aida.IHistogram3D;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.histogram.HistMath;
import hep.aida.ref.histogram.HistUtils;
import hep.aida.ref.histogram.Histogram;
import hep.aida.ref.histogram.UnfillableHistogramException;
import hep.aida.ref.histogram.binner.BasicBinner3D;
import hep.aida.ref.histogram.binner.Binner3D;
import hep.aida.ref.histogram.binner.EfficiencyBinner3D;
import java.util.Map;

public class Histogram3D
extends Histogram
implements IHistogram3D {
    private double meanX = 0.0;
    private double rmsX = 0.0;
    private double meanY = 0.0;
    private double rmsY = 0.0;
    private double meanZ = 0.0;
    private double rmsZ = 0.0;
    private IAxis xAxis;
    private IAxis yAxis;
    private IAxis zAxis;
    private Binner3D binner3D;

    public Histogram3D() {
        super("", "", 3, "");
    }

    protected Histogram3D(String name, String title, IAxis xAxis, IAxis yAxis, IAxis zAxis) {
        this(name, title, xAxis, yAxis, zAxis, "");
    }

    protected Histogram3D(String name, String title, IAxis xAxis, IAxis yAxis, IAxis zAxis, String options) {
        super(name, title, 3, options);
        this.initHistogram3D(xAxis, yAxis, zAxis, options);
    }

    public void fill(double x, double y, double z) {
        this.fill(x, y, z, 1.0);
    }

    public void fill(double x, double y, double z, double weight) {
        if (!this.isFillable()) {
            throw new UnfillableHistogramException();
        }
        ++this.allEntries;
        if (!(Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z) || Double.isNaN(weight))) {
            int xCoordToIndex = this.xAxis.coordToIndex(x);
            int yCoordToIndex = this.yAxis.coordToIndex(y);
            int zCoordToIndex = this.zAxis.coordToIndex(z);
            int xBin = this.mapBinNumber(xCoordToIndex, this.xAxis());
            int yBin = this.mapBinNumber(yCoordToIndex, this.yAxis());
            int zBin = this.mapBinNumber(zCoordToIndex, this.zAxis());
            this.binner3D.fill(xBin, yBin, zBin, x, y, z, weight);
            if (xCoordToIndex >= 0 && yCoordToIndex >= 0 && zCoordToIndex >= 0 || this.useOutflows()) {
                ++this.validEntries;
                this.meanX += x * weight;
                this.rmsX += x * x * weight;
                this.meanY += y * weight;
                this.rmsY += y * y * weight;
                this.meanZ += z * weight;
                this.rmsZ += z * z * weight;
                this.sumOfWeights += weight;
                this.sumOfWeightsSquared += weight * weight;
            }
        }
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void reset() {
        this.binner3D.clear();
        this.meanX = 0.0;
        this.rmsX = 0.0;
        this.meanY = 0.0;
        this.rmsY = 0.0;
        this.meanZ = 0.0;
        this.rmsZ = 0.0;
        super.reset();
    }

    public int extraEntries() {
        int n = 0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                int k = this.zAxis.bins();
                while (--k >= -2) {
                    if (i >= 0 && j >= 0 && k >= 0) continue;
                    n += this.binEntries(i, j, k);
                }
            }
        }
        return n;
    }

    public double sumAllBinHeights() {
        double sum = 0.0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                int k = this.zAxis.bins();
                while (--k >= -2) {
                    sum += this.binHeight(i, j, k);
                }
            }
        }
        return sum;
    }

    public double sumExtraBinHeights() {
        int sum = 0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                int k = this.zAxis.bins();
                while (--k >= -2) {
                    if (i >= 0 && j >= 0 && k >= 0) continue;
                    sum = (int)((double)sum + this.binHeight(i, j, k));
                }
            }
        }
        return sum;
    }

    public double minBinHeight() {
        double min = Double.NaN;
        for (int i = 1; i <= this.xAxis.bins(); ++i) {
            for (int j = 1; j <= this.yAxis.bins(); ++j) {
                for (int k = 1; k <= this.zAxis.bins(); ++k) {
                    if (!Double.isNaN(min) && !(this.binHeight(i, j, k) <= min)) continue;
                    min = this.binHeight(i, j, k);
                }
            }
        }
        return min;
    }

    public double maxBinHeight() {
        double max = Double.NaN;
        for (int i = 1; i <= this.xAxis.bins(); ++i) {
            for (int j = 1; j <= this.yAxis.bins(); ++j) {
                for (int k = 1; k <= this.zAxis.bins(); ++k) {
                    if (!Double.isNaN(max) && !(this.binHeight(i, j, k) >= max)) continue;
                    max = this.binHeight(i, j, k);
                }
            }
        }
        return max;
    }

    public int binEntries(int indexX, int indexY, int indexZ) {
        return this.binner3D.entries(this.mapBinNumber(indexX, this.xAxis()), this.mapBinNumber(indexY, this.yAxis()), this.mapBinNumber(indexZ, this.zAxis()));
    }

    public int binEntriesX(int indexX) {
        int n = 0;
        for (int j = -2; j < this.yAxis().bins(); ++j) {
            for (int k = -2; k < this.zAxis().bins(); ++k) {
                n += this.binEntries(indexX, j, k);
            }
        }
        return n;
    }

    public int binEntriesY(int indexY) {
        int n = 0;
        for (int i = -2; i < this.xAxis().bins(); ++i) {
            for (int k = -2; k < this.zAxis().bins(); ++k) {
                n += this.binEntries(i, indexY, k);
            }
        }
        return n;
    }

    public int binEntriesZ(int indexZ) {
        int n = 0;
        for (int i = -2; i < this.xAxis().bins(); ++i) {
            for (int j = -2; j < this.yAxis().bins(); ++j) {
                n += this.binEntries(i, j, indexZ);
            }
        }
        return n;
    }

    public double binHeight(int indexX, int indexY, int indexZ) {
        return this.binner3D.height(this.mapBinNumber(indexX, this.xAxis()), this.mapBinNumber(indexY, this.yAxis()), this.mapBinNumber(indexZ, this.zAxis()));
    }

    public double binHeightX(int indexX) {
        double d = 0.0;
        for (int j = -2; j < this.yAxis().bins(); ++j) {
            for (int k = -2; k < this.zAxis().bins(); ++k) {
                d += this.binHeight(indexX, j, k);
            }
        }
        return d;
    }

    public double binHeightY(int indexY) {
        double d = 0.0;
        for (int i = -2; i < this.xAxis().bins(); ++i) {
            for (int k = -2; k < this.zAxis().bins(); ++k) {
                d += this.binHeight(i, indexY, k);
            }
        }
        return d;
    }

    public double binHeightZ(int indexZ) {
        double d = 0.0;
        for (int i = -2; i < this.xAxis().bins(); ++i) {
            for (int j = -2; j < this.yAxis().bins(); ++j) {
                d += this.binHeight(i, j, indexZ);
            }
        }
        return d;
    }

    public double binError(int indexX, int indexY, int indexZ) {
        return this.binner3D.plusError(this.mapBinNumber(indexX, this.xAxis()), this.mapBinNumber(indexY, this.yAxis()), this.mapBinNumber(indexZ, this.zAxis()));
    }

    public double meanX() {
        if (this.validEntries != 0) {
            return this.meanX / this.sumOfWeights;
        }
        return 0.0;
    }

    public double meanY() {
        if (this.validEntries != 0) {
            return this.meanY / this.sumOfWeights;
        }
        return 0.0;
    }

    public double meanZ() {
        if (this.validEntries != 0) {
            return this.meanZ / this.sumOfWeights;
        }
        return 0.0;
    }

    public double rmsX() {
        if (this.validEntries != 0) {
            return Math.sqrt(this.rmsX / this.sumOfWeights - this.meanX * this.meanX / this.sumOfWeights / this.sumOfWeights);
        }
        return 0.0;
    }

    public double rmsY() {
        if (this.validEntries != 0) {
            return Math.sqrt(this.rmsY / this.sumOfWeights - this.meanY * this.meanY / this.sumOfWeights / this.sumOfWeights);
        }
        return 0.0;
    }

    public double rmsZ() {
        if (this.validEntries != 0) {
            return Math.sqrt(this.rmsZ / this.sumOfWeights - this.meanZ * this.meanZ / this.sumOfWeights / this.sumOfWeights);
        }
        return 0.0;
    }

    public IAxis xAxis() {
        return this.xAxis;
    }

    public IAxis yAxis() {
        return this.yAxis;
    }

    public IAxis zAxis() {
        return this.zAxis;
    }

    public int coordToIndexX(double coordX) {
        return this.xAxis().coordToIndex(coordX);
    }

    public int coordToIndexY(double coordY) {
        return this.yAxis().coordToIndex(coordY);
    }

    public int coordToIndexZ(double coordZ) {
        return this.zAxis().coordToIndex(coordZ);
    }

    public void scale(double scaleFactor) throws IllegalArgumentException {
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Illegal scale factor " + scaleFactor + " it has to be positive");
        }
        this.binner3D.scale(scaleFactor);
        this.meanX *= scaleFactor;
        this.rmsX *= scaleFactor;
        this.meanY *= scaleFactor;
        this.rmsY *= scaleFactor;
        this.meanZ *= scaleFactor;
        this.rmsZ *= scaleFactor;
        this.sumOfWeights *= scaleFactor;
        this.sumOfWeightsSquared *= scaleFactor * scaleFactor;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void add(IHistogram3D hist) throws IllegalArgumentException {
        HistMath.checkCompatibility(this.xAxis(), hist.xAxis());
        HistMath.checkCompatibility(this.yAxis(), hist.yAxis());
        HistMath.checkCompatibility(this.zAxis(), hist.zAxis());
        int xbins = this.xAxis().bins() + 2;
        int ybins = this.yAxis().bins() + 2;
        int zbins = this.zAxis().bins() + 2;
        double[][][] newHeights = new double[xbins][ybins][zbins];
        double[][][] newErrors = new double[xbins][ybins][zbins];
        double[][][] newMeanXs = new double[xbins][ybins][zbins];
        double[][][] newRmsXs = new double[xbins][ybins][zbins];
        double[][][] newMeanYs = new double[xbins][ybins][zbins];
        double[][][] newRmsYs = new double[xbins][ybins][zbins];
        double[][][] newMeanZs = new double[xbins][ybins][zbins];
        double[][][] newRmsZs = new double[xbins][ybins][zbins];
        double rmsx2 = 0.0;
        double rmsy2 = 0.0;
        double rmsz2 = 0.0;
        boolean h1Aida = !(hist instanceof Histogram3D);
        int[][][] newEntries = new int[xbins][ybins][zbins];
        for (int i = -2; i < this.xAxis().bins(); ++i) {
            for (int j = -2; j < this.yAxis().bins(); ++j) {
                for (int k = -2; k < this.zAxis().bins(); ++k) {
                    double height1 = this.binHeight(i, j, k);
                    double height2 = hist.binHeight(i, j, k);
                    double h = height1 + height2;
                    double meanx1 = this.binMeanX(i, j, k);
                    double meanx2 = hist.binMeanX(i, j, k);
                    meanx1 = HistUtils.isValidDouble(meanx1) ? meanx1 : 0.0;
                    meanx2 = HistUtils.isValidDouble(meanx2) ? meanx2 : 0.0;
                    double mx = 0.0;
                    double rmsx1 = this.binRmsX(i, j, k);
                    double rx = 0.0;
                    double meany1 = this.binMeanY(i, j, k);
                    double meany2 = hist.binMeanY(i, j, k);
                    meany1 = HistUtils.isValidDouble(meany1) ? meany1 : 0.0;
                    meany2 = HistUtils.isValidDouble(meany2) ? meany2 : 0.0;
                    double my = 0.0;
                    double rmsy1 = this.binRmsY(i, j, k);
                    double ry = 0.0;
                    double meanz1 = this.binMeanZ(i, j, k);
                    double meanz2 = hist.binMeanZ(i, j, k);
                    meanz1 = HistUtils.isValidDouble(meanz1) ? meanz1 : 0.0;
                    meanz2 = HistUtils.isValidDouble(meanz2) ? meanz2 : 0.0;
                    double mz = 0.0;
                    double rmsz1 = this.binRmsZ(i, j, k);
                    if (h1Aida) {
                        rmsx2 = (hist.xAxis().binUpperEdge(i) - hist.xAxis().binLowerEdge(i)) / Math.sqrt(12.0);
                        rmsy2 = (hist.yAxis().binUpperEdge(j) - hist.yAxis().binLowerEdge(j)) / Math.sqrt(12.0);
                        rmsy2 = (hist.zAxis().binUpperEdge(k) - hist.zAxis().binLowerEdge(k)) / Math.sqrt(12.0);
                    } else {
                        rmsx2 = ((Histogram3D)hist).binRmsX(i, j, k);
                        rmsy2 = ((Histogram3D)hist).binRmsY(i, j, k);
                        rmsz2 = ((Histogram3D)hist).binRmsZ(i, j, k);
                    }
                    double rz = 0.0;
                    if (h != 0.0) {
                        mx = (meanx1 * height1 + meanx2 * height2) / (height1 + height2);
                        rx = Math.sqrt((rmsx1 * rmsx1 * height1 + meanx1 * meanx1 * height1 + (rmsx2 * rmsx2 * height2 + meanx2 * meanx2 * height2)) / h - mx * mx);
                        my = (meany1 * height1 + meany2 * height2) / (height1 + height2);
                        ry = Math.sqrt((rmsy1 * rmsy1 * height1 + meany1 * meany1 * height1 + (rmsy2 * rmsy2 * height2 + meany2 * meany2 * height2)) / h - my * my);
                        mz = (meanz1 * height1 + meanz2 * height2) / (height1 + height2);
                        rz = Math.sqrt((rmsz1 * rmsz1 * height1 + meanz1 * meanz1 * height1 + (rmsz2 * rmsz2 * height2 + meanz2 * meanz2 * height2)) / h - mz * mz);
                    }
                    int binx = this.mapBinNumber(i, this.xAxis());
                    int biny = this.mapBinNumber(j, this.yAxis());
                    int binz = this.mapBinNumber(k, this.zAxis());
                    newHeights[binx][biny][binz] = h;
                    newErrors[binx][biny][binz] = Math.sqrt(Math.pow(this.binError(i, j, k), 2.0) + Math.pow(hist.binError(i, j, k), 2.0));
                    newEntries[binx][biny][binz] = this.binEntries(i, j, k) + hist.binEntries(i, j, k);
                    newMeanXs[binx][biny][binz] = mx;
                    newRmsXs[binx][biny][binz] = rx;
                    newMeanYs[binx][biny][binz] = my;
                    newRmsYs[binx][biny][binz] = ry;
                    newMeanZs[binx][biny][binz] = mz;
                    newRmsZs[binx][biny][binz] = rz;
                }
            }
        }
        this.setContents(newHeights, newErrors, newEntries, newMeanXs, newRmsXs, newMeanYs, newRmsYs, newMeanZs, newRmsZs);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void setMeanX(double meanX) {
        this.meanX = meanX * this.sumOfWeights;
    }

    public void setRmsX(double rmsX) {
        this.rmsX = rmsX * rmsX * this.sumOfWeights + this.meanX() * this.meanX() * this.sumOfWeights;
    }

    public void setMeanY(double meanY) {
        this.meanY = meanY * this.sumOfWeights;
    }

    public void setRmsY(double rmsY) {
        this.rmsY = rmsY * rmsY * this.sumOfWeights + this.meanY() * this.meanY() * this.sumOfWeights;
    }

    public void setMeanZ(double meanZ) {
        this.meanZ = meanZ * this.sumOfWeights;
    }

    public void setRmsZ(double rmsZ) {
        this.rmsZ = rmsZ * rmsZ * this.sumOfWeights + this.meanZ() * this.meanZ() * this.sumOfWeights;
    }

    public double binMeanX(int indexX, int indexY, int indexZ) {
        int binz;
        int biny;
        int binx = this.mapBinNumber(indexX, this.xAxis());
        double m = this.binner3D.meanX(binx, biny = this.mapBinNumber(indexY, this.yAxis()), binz = this.mapBinNumber(indexZ, this.zAxis()));
        return Double.isNaN(m) ? this.xAxis().binCenter(indexX) : m;
    }

    public double binMeanY(int indexX, int indexY, int indexZ) {
        int binz;
        int biny;
        int binx = this.mapBinNumber(indexX, this.xAxis());
        double m = this.binner3D.meanY(binx, biny = this.mapBinNumber(indexY, this.yAxis()), binz = this.mapBinNumber(indexZ, this.zAxis()));
        return Double.isNaN(m) ? this.yAxis().binCenter(indexY) : m;
    }

    public double binMeanZ(int indexX, int indexY, int indexZ) {
        int binz;
        int biny;
        int binx = this.mapBinNumber(indexX, this.xAxis());
        double m = this.binner3D.meanZ(binx, biny = this.mapBinNumber(indexY, this.yAxis()), binz = this.mapBinNumber(indexZ, this.zAxis()));
        return Double.isNaN(m) ? this.zAxis().binCenter(indexZ) : m;
    }

    public double binRmsX(int indexX, int indexY, int indexZ) {
        int binz;
        int biny;
        int binx = this.mapBinNumber(indexX, this.xAxis());
        double r = this.binner3D.rmsX(binx, biny = this.mapBinNumber(indexY, this.yAxis()), binz = this.mapBinNumber(indexZ, this.zAxis()));
        return Double.isNaN(r) ? this.xAxis().binWidth(indexX) : r;
    }

    public double binRmsY(int indexX, int indexY, int indexZ) {
        int binz;
        int biny;
        int binx = this.mapBinNumber(indexX, this.xAxis());
        double r = this.binner3D.rmsY(binx, biny = this.mapBinNumber(indexY, this.yAxis()), binz = this.mapBinNumber(indexZ, this.zAxis()));
        return Double.isNaN(r) ? this.yAxis().binWidth(indexY) : r;
    }

    public double binRmsZ(int indexX, int indexY, int indexZ) {
        int binz;
        int biny;
        int binx = this.mapBinNumber(indexX, this.xAxis());
        double r = this.binner3D.rmsZ(binx, biny = this.mapBinNumber(indexY, this.yAxis()), binz = this.mapBinNumber(indexZ, this.zAxis()));
        return Double.isNaN(r) ? this.zAxis().binWidth(indexZ) : r;
    }

    public void setBinError(int indexX, int indexY, int indexZ, double error) {
        int binx = this.mapBinNumber(indexX, this.xAxis());
        int biny = this.mapBinNumber(indexY, this.yAxis());
        int binz = this.mapBinNumber(indexZ, this.zAxis());
        this.binner3D.setBinContent(binx, biny, binz, this.binEntries(indexX, indexY, indexZ), this.binHeight(indexX, indexY, indexZ), error, error, this.binMeanX(indexX, indexY, indexZ), this.binRmsX(indexX, indexY, indexZ), this.binMeanY(indexX, indexY, indexZ), this.binRmsY(indexX, indexY, indexZ), this.binMeanZ(indexX, indexY, indexZ), this.binRmsZ(indexX, indexY, indexZ));
    }

    public void setContents(double[][][] heights, double[][][] errors, int[][][] entries, double[][][] meanXs, double[][][] rmsXs, double[][][] meanYs, double[][][] rmsYs, double[][][] meanZs, double[][][] rmsZs) {
        this.reset();
        for (int i = 0; i < this.xAxis.bins() + 2; ++i) {
            int mi = i == 0 ? -2 : (i == this.xAxis().bins() + 1 ? -1 : i - 1);
            for (int j = 0; j < this.yAxis().bins() + 2; ++j) {
                int mj = j == 0 ? -2 : (j == this.yAxis().bins() + 1 ? -1 : j - 1);
                for (int k = 0; k < this.zAxis.bins() + 2; ++k) {
                    double h = heights[i][j][k];
                    int mk = k == 0 ? -2 : (k == this.zAxis().bins() + 1 ? -1 : k - 1);
                    double mx = meanXs != null ? meanXs[i][j][k] : (this.xAxis().binLowerEdge(mi) + this.xAxis().binUpperEdge(mi)) / 2.0;
                    double my = meanYs != null ? meanYs[i][j][k] : (this.yAxis().binLowerEdge(mj) + this.yAxis().binUpperEdge(mj)) / 2.0;
                    double mz = meanZs != null ? meanZs[i][j][k] : (this.zAxis().binLowerEdge(mk) + this.zAxis().binUpperEdge(mk)) / 2.0;
                    double rx = rmsXs != null ? rmsXs[i][j][k] : (this.xAxis().binUpperEdge(mi) - this.xAxis().binLowerEdge(mi)) / Math.sqrt(12.0);
                    double ry = rmsYs != null ? rmsYs[i][j][k] : (this.yAxis().binUpperEdge(mj) - this.yAxis().binLowerEdge(mj)) / Math.sqrt(12.0);
                    double rz = rmsZs != null ? rmsZs[i][j][k] : (this.zAxis().binUpperEdge(mk) - this.zAxis().binLowerEdge(mk)) / Math.sqrt(12.0);
                    int e = entries != null ? entries[i][j][k] : (int)h;
                    this.binner3D.setBinContent(i, j, k, e, h, errors[i][j][k], errors[i][j][k], mx, rx, my, ry, mz, rz);
                    h = this.binner3D.height(i, j, k);
                    this.allEntries += e;
                    if ((mi < 0 || mj < 0 || mk < 0) && !this.useOutflows()) continue;
                    if (!(Double.isNaN(mx) || Double.isNaN(my) || Double.isNaN(mz) || Double.isInfinite(mx) || Double.isInfinite(my) || Double.isInfinite(mz))) {
                        this.meanX += mx * h;
                        this.rmsX += rx * rx * h + mx * mx * h;
                        this.meanY += my * h;
                        this.rmsY += ry * ry * h + my * my * h;
                        this.meanZ += mz * h;
                        this.rmsZ += rz * rz * h + mz * mz * h;
                    }
                    this.validEntries += e;
                    this.sumOfWeights += h;
                    this.sumOfWeightsSquared = h * h;
                }
            }
        }
    }

    public void initHistogram3D(IAxis xAxis, IAxis yAxis, IAxis zAxis, String options) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        Map optionMap = AidaUtils.parseOptions(options);
        String type = (String)optionMap.get("type");
        if (type == null || type.equals("default")) {
            this.binner3D = new BasicBinner3D(xAxis.bins() + 2, yAxis.bins() + 2, zAxis.bins() + 2);
        } else if (type.equals("efficiency")) {
            this.binner3D = new EfficiencyBinner3D(xAxis.bins() + 2, yAxis.bins() + 2, zAxis.bins() + 2);
        } else {
            throw new IllegalArgumentException("Wrong histogram type " + type);
        }
        String useOutflowsString = (String)optionMap.get("useOutflowsInStatistics");
        if (useOutflowsString != null) {
            this.setUseOutflows(Boolean.valueOf(useOutflowsString));
        }
        this.reset();
    }
}

