/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IManagedObject;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.histogram.Histogram3D;

public abstract class HistUtils {
    private static double defaultLowerEdge = -1.0;
    private static double defaultUpperEdge = 1.0;

    public static IHistogram1D toShowableHistogram(ICloud1D cloud, int nBins, double lowerEdge, double upperEdge) {
        String name = "";
        if (cloud instanceof IManagedObject) {
            name = ((IManagedObject)((Object)cloud)).name();
        }
        if (Double.isNaN(lowerEdge)) {
            lowerEdge = defaultLowerEdge;
        }
        if (Double.isNaN(upperEdge)) {
            upperEdge = defaultUpperEdge;
        }
        if (upperEdge == lowerEdge) {
            upperEdge = lowerEdge + 1.0;
        }
        Histogram1D hist = new Histogram1D(name, cloud.title(), new FixedAxis(nBins, lowerEdge, upperEdge));
        for (int i = 0; i < cloud.entries(); ++i) {
            hist.fill(cloud.value(i), cloud.weight(i));
        }
        return hist;
    }

    public static IHistogram2D toShowableHistogram(ICloud2D cloud, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) {
        String name = "";
        if (cloud instanceof IManagedObject) {
            name = ((IManagedObject)((Object)cloud)).name();
        }
        if (Double.isNaN(lowerEdgeX)) {
            lowerEdgeX = defaultLowerEdge;
        }
        if (Double.isNaN(upperEdgeX)) {
            upperEdgeX = defaultUpperEdge;
        }
        if (Double.isNaN(lowerEdgeY)) {
            lowerEdgeY = defaultLowerEdge;
        }
        if (Double.isNaN(upperEdgeY)) {
            upperEdgeY = defaultUpperEdge;
        }
        if (upperEdgeX == lowerEdgeX) {
            upperEdgeX = lowerEdgeX + 1.0;
        }
        if (upperEdgeY == lowerEdgeY) {
            upperEdgeY = lowerEdgeY + 1.0;
        }
        Histogram2D hist = new Histogram2D(name, cloud.title(), new FixedAxis(nBinsX, lowerEdgeX, upperEdgeX), new FixedAxis(nBinsY, lowerEdgeY, upperEdgeY));
        for (int i = 0; i < cloud.entries(); ++i) {
            hist.fill(cloud.valueX(i), cloud.valueY(i), cloud.weight(i));
        }
        return hist;
    }

    public static IHistogram3D toShowableHistogram(ICloud3D cloud, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ) {
        String name = "";
        if (cloud instanceof IManagedObject) {
            name = ((IManagedObject)((Object)cloud)).name();
        }
        if (Double.isNaN(lowerEdgeX)) {
            lowerEdgeX = defaultLowerEdge;
        }
        if (Double.isNaN(upperEdgeX)) {
            upperEdgeX = defaultUpperEdge;
        }
        if (Double.isNaN(lowerEdgeY)) {
            lowerEdgeY = defaultLowerEdge;
        }
        if (Double.isNaN(upperEdgeY)) {
            upperEdgeY = defaultUpperEdge;
        }
        if (Double.isNaN(lowerEdgeZ)) {
            lowerEdgeZ = defaultLowerEdge;
        }
        if (Double.isNaN(upperEdgeZ)) {
            upperEdgeZ = defaultUpperEdge;
        }
        if (upperEdgeX == lowerEdgeX) {
            upperEdgeX = lowerEdgeX + 1.0;
        }
        if (upperEdgeY == lowerEdgeY) {
            upperEdgeY = lowerEdgeY + 1.0;
        }
        if (upperEdgeZ == lowerEdgeZ) {
            upperEdgeZ = lowerEdgeZ + 1.0;
        }
        Histogram3D hist = new Histogram3D(name, cloud.title(), new FixedAxis(nBinsX, lowerEdgeX, upperEdgeX), new FixedAxis(nBinsY, lowerEdgeY, upperEdgeY), new FixedAxis(nBinsZ, lowerEdgeZ, upperEdgeZ));
        for (int i = 0; i < cloud.entries(); ++i) {
            hist.fill(cloud.valueX(i), cloud.valueY(i), cloud.valueZ(i), cloud.weight(i));
        }
        return hist;
    }

    public static double histogramNormalization(IHistogram1D h1) {
        return h1.sumBinHeights() * (h1.axis().upperEdge() - h1.axis().lowerEdge()) / (double)h1.axis().bins();
    }

    public static boolean isValidDouble(double d) {
        if (Double.isNaN(d)) {
            return false;
        }
        return !Double.isInfinite(d);
    }
}

