/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveEntryStreamClosedException;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveWarningException;
import de.schlichtherle.io.File;
import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.util.SynchronizedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OutputArchiveMetaData {
    private static final String CLASS_NAME;
    private static final Logger logger;
    private final Archive archive;
    private final OutputArchive outArchive;
    private final Map streams;
    private volatile boolean stopped;
    static final /* synthetic */ boolean $assertionsDisabled;

    OutputArchiveMetaData(Archive archive, OutputArchive outArchive) {
        AbstractMap abstractMap = this.streams = File.isLenient() ? new WeakHashMap() : new HashMap();
        if (!$assertionsDisabled && outArchive == null) {
            throw new AssertionError();
        }
        this.archive = archive;
        this.outArchive = outArchive;
    }

    synchronized OutputStream createOutputStream(ArchiveEntry entry, ArchiveEntry srcEntry) throws IOException {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && entry == null) {
            throw new AssertionError();
        }
        OutputStream out = this.outArchive.getOutputStream(entry, srcEntry);
        return out != null ? new EntryOutputStream(out) : null;
    }

    synchronized int waitAllOutputStreamsByOtherThreads(long timeout) {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        long start = System.currentTimeMillis();
        int threadStreams = this.threadStreams();
        try {
            while (this.streams.size() > threadStreams) {
                long toWait;
                if (timeout > 0L) {
                    toWait = timeout - (System.currentTimeMillis() - start);
                    if (toWait <= 0L) {
                        break;
                    }
                } else {
                    toWait = 0L;
                }
                if (File.isLenient()) {
                    System.gc();
                    System.runFinalization();
                }
                this.wait(toWait);
            }
        }
        catch (InterruptedException ignored) {
            logger.warning("interrupted");
        }
        return this.streams.size();
    }

    private int threadStreams() {
        Thread thisThread = Thread.currentThread();
        int n = 0;
        Iterator i = this.streams.values().iterator();
        while (i.hasNext()) {
            Thread thread2 = (Thread)i.next();
            if (thisThread != thread2) continue;
            ++n;
        }
        return n;
    }

    synchronized ArchiveException closeAllOutputStreams(ArchiveException exceptionChain) {
        if (!$assertionsDisabled && this.stopped) {
            throw new AssertionError();
        }
        this.stopped = true;
        Iterator i = this.streams.keySet().iterator();
        while (i.hasNext()) {
            EntryOutputStream out = (EntryOutputStream)i.next();
            try {
                out.doClose();
            }
            catch (IOException failure) {
                exceptionChain = new ArchiveWarningException(exceptionChain, failure);
            }
        }
        this.streams.clear();
        return exceptionChain;
    }

    static {
        $assertionsDisabled = !OutputArchiveMetaData.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/OutputArchiveMetaData".replace('/', '.');
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    }

    private final class EntryOutputStream
    extends SynchronizedOutputStream {
        private boolean closed;
        static final /* synthetic */ boolean $assertionsDisabled;

        private EntryOutputStream(OutputStream out) {
            super(out, OutputArchiveMetaData.this);
            if (!$assertionsDisabled && out == null) {
                throw new AssertionError();
            }
            OutputArchiveMetaData.this.streams.put(this, Thread.currentThread());
            OutputArchiveMetaData.this.notify();
        }

        private final void ensureNotStopped() throws IOException {
            if (OutputArchiveMetaData.this.stopped) {
                throw new ArchiveEntryStreamClosedException();
            }
        }

        public void write(int b) throws IOException {
            this.ensureNotStopped();
            super.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.ensureNotStopped();
            super.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureNotStopped();
            super.write(b, off, len);
        }

        public void flush() throws IOException {
            this.ensureNotStopped();
            super.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void close() throws IOException {
            if (!$assertionsDisabled && OutputArchiveMetaData.this != this.lock) {
                throw new AssertionError();
            }
            OutputArchiveMetaData outputArchiveMetaData = OutputArchiveMetaData.this;
            synchronized (outputArchiveMetaData) {
                if (this.closed) {
                    return;
                }
                try {
                    this.doClose();
                }
                finally {
                    OutputArchiveMetaData.this.streams.remove(this);
                    OutputArchiveMetaData.this.notify();
                }
            }
        }

        protected void doClose() throws IOException {
            if (!$assertionsDisabled && this.closed) {
                throw new AssertionError();
            }
            this.closed = true;
            super.doClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.closed) {
                    return;
                }
                logger.finer("finalize.open");
                try {
                    this.doClose();
                }
                catch (IOException failure) {
                    logger.log(Level.FINE, "finalize.exception", failure);
                }
            }
            finally {
                super.finalize();
            }
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$OutputArchiveMetaData == null ? (class$de$schlichtherle$io$OutputArchiveMetaData = OutputArchiveMetaData.class$("de.schlichtherle.io.OutputArchiveMetaData")) : class$de$schlichtherle$io$OutputArchiveMetaData).desiredAssertionStatus();
        }
    }
}

