/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.ui;

import com.artenum.jyconsole.JyConsole;
import com.artenum.jyconsole.ui.PreferenceDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PopupMenu
extends MouseAdapter
implements ActionListener {
    private JyConsole console;
    private JPopupMenu popupMenu;
    private PreferenceDialog prefDialog;

    public PopupMenu(JyConsole console) {
        this.console = console;
        this.popupMenu = new JPopupMenu();
        JMenuItem loadFile = new JMenuItem("Load a script");
        loadFile.setActionCommand("LOAD_SCRIPT");
        loadFile.addActionListener(this);
        this.popupMenu.add(loadFile);
        this.prefDialog = new PreferenceDialog(console);
        JMenuItem style = new JMenuItem("Change style");
        style.setActionCommand("STYLE");
        style.addActionListener(this);
        this.popupMenu.add(style);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("LOAD_SCRIPT")) {
            JFileChooser chooser = new JFileChooser();
            if (this.console.getPreferences().get("jyconsole.pref.script.dir") != null) {
                chooser.setCurrentDirectory(new File((String)this.console.getPreferences().get("jyconsole.pref.script.dir")));
            }
            if (chooser.showOpenDialog(this.console) == 0) {
                this.console.executePythonFile(chooser.getSelectedFile());
            }
        } else if (command.equals("STYLE")) {
            this.prefDialog.setVisible(true);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

