/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.io;

import com.artenum.jyconsole.ui.Prompt;
import java.awt.FontMetrics;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;

public class InteractiveCommandLine
implements DocumentListener {
    private String styleName;
    private StyledDocument doc;
    private JTextPane uiPart;
    private Prompt prompt;
    private boolean needToUpdateCompletionModel;
    private String completionPart;
    private int completionCmdPos;
    private String filterPart;
    private int filterPos;
    private StringBuffer txtBefore;
    private String txtAfter;

    public InteractiveCommandLine(StyledDocument doc, JTextPane uiPart, Prompt prompt, String defaultStyleName) {
        this.doc = doc;
        this.styleName = defaultStyleName;
        this.uiPart = uiPart;
        this.prompt = prompt;
        doc.addDocumentListener(this);
        this.needToUpdateCompletionModel = true;
    }

    public int getCaretPosition() {
        return this.uiPart.getCaretPosition();
    }

    public String getCmdLine() {
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void append(String txt) {
        try {
            this.doc.insertString(this.getCaretPosition(), txt, this.doc.getStyle(this.styleName));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.prompt.updateLineView();
    }

    public void reset() {
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.uiPart.setCaretPosition(0);
        this.prompt.updateLineView();
    }

    public Point getCaretPositionPoint() {
        FontMetrics fontMetric = this.uiPart.getFontMetrics(this.uiPart.getFont());
        int nbEndLine = 1;
        int startLineCharPos = 0;
        int findPos = -1;
        String txt = "";
        try {
            txt = this.doc.getText(0, this.getCaretPosition());
        }
        catch (Exception exception) {}
        while ((findPos = txt.indexOf("\n")) != -1) {
            startLineCharPos += findPos + 1;
            txt = txt.substring(findPos + 1);
            ++nbEndLine;
        }
        try {
            return new Point(fontMetric.stringWidth(this.doc.getText(startLineCharPos, this.filterPos + 1 - startLineCharPos)) + 4, nbEndLine * fontMetric.getHeight() + 2);
        }
        catch (BadLocationException e) {
            return new Point(0, 0);
        }
    }

    public boolean askForDictionnary() {
        if (this.needToUpdateCompletionModel) {
            this.updateCompletionModel();
        }
        return this.completionPart.length() == 0 || this.completionPart.equals(this.filterPart);
    }

    public String getCompletionCmd() {
        if (this.needToUpdateCompletionModel) {
            this.updateCompletionModel();
        }
        return this.completionPart;
    }

    public String getFilterCmd() {
        if (this.needToUpdateCompletionModel) {
            this.updateCompletionModel();
        }
        return this.filterPart;
    }

    public void setCompletionCmd(String cCmd) {
        try {
            this.doc.remove(this.completionCmdPos, this.completionPart.length());
            this.doc.insertString(this.completionCmdPos, cCmd, this.doc.getStyle("default"));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.uiPart.setCaretPosition(this.completionCmdPos + cCmd.length());
    }

    public void setFilteredCmd(String fCmd) {
        try {
            this.doc.remove(this.filterPos + 1, this.filterPart.length());
            this.doc.insertString(this.filterPos + 1, fCmd, this.doc.getStyle("default"));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.uiPart.setCaretPosition(this.filterPos + 1 + fCmd.length());
    }

    private void updateCompletionModel() {
        StringBuffer cmdLine = new StringBuffer(this.doc.getLength());
        try {
            cmdLine.append(this.doc.getText(0, this.doc.getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.txtBefore = new StringBuffer();
        this.txtAfter = cmdLine.substring(this.uiPart.getCaretPosition());
        cmdLine.delete(this.uiPart.getCaretPosition(), cmdLine.length());
        if (cmdLine.indexOf("\n") != -1) {
            this.txtBefore.append(cmdLine.substring(0, cmdLine.lastIndexOf("\n")));
            cmdLine.delete(0, cmdLine.lastIndexOf("\n"));
        }
        ArrayList<Integer> tree = new ArrayList<Integer>();
        int i = 0;
        while (i < cmdLine.length()) {
            if (cmdLine.charAt(i) == '(') {
                tree.add(new Integer(i));
            }
            if (cmdLine.charAt(i) == ')') {
                tree.remove(tree.size() - 1);
            }
            ++i;
        }
        if (tree.size() > 0) {
            this.txtBefore.append(cmdLine.substring(0, 1 + (Integer)tree.get(tree.size() - 1)));
            cmdLine.delete(0, 1 + (Integer)tree.get(tree.size() - 1));
        }
        if (cmdLine.indexOf(" ") != -1) {
            this.txtBefore.append(cmdLine.substring(0, cmdLine.lastIndexOf(" ") + 1));
            cmdLine.delete(0, cmdLine.lastIndexOf(" ") + 1);
        }
        this.completionPart = cmdLine.toString();
        if (cmdLine.indexOf(".") != -1) {
            this.completionPart = cmdLine.toString().substring(0, cmdLine.lastIndexOf("."));
            cmdLine.delete(0, cmdLine.lastIndexOf(".") + 1);
        }
        this.filterPart = cmdLine.toString();
        this.completionCmdPos = this.txtBefore.length();
        this.filterPos = this.completionCmdPos + this.completionPart.length();
        this.needToUpdateCompletionModel = false;
    }

    public void backSpace() {
        try {
            if (this.getCaretPosition() > 0) {
                this.doc.remove(this.getCaretPosition() - 1, 1);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.needToUpdateCompletionModel = true;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.needToUpdateCompletionModel = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.needToUpdateCompletionModel = true;
    }

    public void getFocus() {
        this.uiPart.grabFocus();
    }
}

