; $Id: test_recip.pro,v 1.2 2012/06/26 15:11:33 kneller Exp $

;Test method for calc_q routines.


;####################################################################
pro test_recip,o1,o2,a,b,c,alpha,beta,gamma,ki=ki,kf=kf,qwid=qwid,ewid=ewid,scanwid=scanwid,harmonics=harmonics

    ;INPUTS:
    ;a,b,c,alpha,beta,gamma
    ;o1,o2
    ;hkl,strf
    ;ki,kf IN TERMS OF hkl VALUES

    if n_elements(qwid) eq 0 then qwid = 0
    if n_elements(ewid) eq 0 then ewid = 1
    if n_elements(scanwid) eq 0 then scanwid = 2
    if n_elements(harmonics) eq 0 then harmonics = 0


    hkl = make_hkl(31)

;STEP 1 GET RECIP LATTICE VECTORS FROM abc,abg
    val = recip_lattice(a,b,c,alpha,beta,gamma)
    b1    = val.b123.b1
    b2    = val.b123.b2
    b3    = val.b123.b3

    ;CALCULATE ki,kf,Q IN 1/ang UNITS
    if n_elements(ki) eq 3 then begin
        ki = ki[0]*b1 + ki[1]*b2 + ki[2]*b3
        Ei = calc_E_from_kvec(ki)
        ;print,Ei
    endif
    if n_elements(kf) eq 3 then begin
        kf = kf[0]*b1 + kf[1]*b2 + kf[2]*b3
        Ef = calc_E_from_kvec(kf)
        ;print,Ef
    endif

    if n_elements(ki) eq 3 and n_elements(kf) eq 3 then begin
        nvec = 5
        qevals = QE(ki,kf,nvec)

        Q       = qevals.Q
;        print,'_________________________________________________________'
;        print,'In test_recip b1=',b1
;        print,'In test_recip b2=',b2
;        print,'In test_recip b3=',b3
;        print,'In test_recip Q= ',Q
;        print,'Ei=',Ei
;        print,'Ef=',Ef
;        print,'E=',Ei-Ef
;        print,'ki_b123=',ki
;        print,'kf_b123=',kf
;        print,'kimag=',sqrt(dotp(ki,ki))
;        print,'kfmag=',sqrt(dotp(kf,kf))


        kiarr   = qevals.kiarr
        kfarr   = qevals.kfarr
        Qarr    = qevals.Qarr
        QMagarr = qevals.QMagarr
        Earr    = qevals.Earr
    endif


;IT SEEMS LIKE IT SHOULD BE SOMTHING LIKE

;THE FOLLOWING SETS THE AXES ALONG o1,o2
    o1vec = (o1[0]*b1 + o1[1]*b2 + o1[2]*b3)
    o2vec = (o2[0]*b1 + o2[1]*b2 + o2[2]*b3)

    mago1vec = sqrt(dotp(o1vec,o1vec))
    mago2vec = sqrt(dotp(o2vec,o2vec))

    ;CREATE UNIT VECTORS ALONG THE o1,o2 DIRECTIONS ---  THIS SHOULD NOT BE USED IN
    xhat_o1 = o1vec/mago1vec                            ;GENERAL SINCE THEY ARE ALONG
    yhat_o2 = o2vec/mago2vec                            ;THE ORIENTATION VECTOR DIRECTIONS
                                                        ;AND MAY NOT BE ORTHOGONAL.


;BUT I REALLY WANT A PAIR OF AXES WHERE
    ;o1 along x
    ;y perp to x regardless of whether o2 perp to o1
    ;z perp to x,y
;SO:
;    xhat = xhat_o1
;    zhat = crossp(xhat_o1,yhat_o2)
;    yhat = crossp(zhat,xhat)
    xhat = xhat_o1
    xhat = xhat/sqrt(dotp(xhat,xhat))
    zhat = crossp(xhat_o1,yhat_o2)
    zhat = zhat/sqrt(dotp(zhat,zhat))
    yhat = crossp(zhat,xhat)
    yhat = yhat/sqrt(dotp(yhat,yhat))

;print,'xhat=',xhat
;print,'yhat=',yhat
;print,'zhat=',zhat
;HERE THE UNITS ARE SAME AS THOSE OF b1,b2,b3 ---- 1/Angstrom
    ;So adding Al rings is easy now

    szhkl = size(hkl)
    nq = szhkl[2]
    strf  = findgen(nq)

    title = '';'Qxy in o1,o2 plane'
    xtitle = 'X ['+angstrom()+'^-1]  || ['+ $
                strtrim(string(o1[0],format='(f4.1)'),2)+','+ $
                strtrim(string(o1[1],format='(f4.1)'),2)+','+ $
                strtrim(string(o1[2],format='(f4.1)'),2)+']';o1[0]*b1+o1[1]*b2+o1[2]*b3'
    ytitle = 'Y ['+angstrom()+'^-1]  || Z x X';perp o1.[b1,b2,b3],coplanar w/o1.[b1,b2,b3]&o2.[b1,b2,b3]'

    overalltitle = 'Plane perp to Z = O1 x O2'

    ;SET THE MOST USEFUL COLORS
    black = 0L
    red   = 255L
    green = 256L*255L
    blue  = 256L^2*255L
    white = red+green+blue

    if qwid eq 0 then begin
        window,0,xsize=500,ysize=500,xpos=600,ypos=200
    endif else begin
        wset,qwid
    endelse

;    xrange = [-10,10]
;    yrange = [-10,10]
;
;    xrange = [-1,1]
;    yrange = [-1,1]

;GET RANGES
    allgx = [0.0]
    allgy = [0.0]
    for i=0,nq-1 do begin
        h = hkl[0,i]
        k = hkl[1,i]
        l = hkl[2,i]
        g    = h*b1 + k*b2 + l*b3
        gx = dotp(g,xhat)
        gy = dotp(g,yhat)


        if dotp(G,crossp(o1vec,o2vec)) eq 0.0 then begin
            if abs(h) lt 5 and abs(k) lt 5 and abs(l) lt 5 then begin
                allgx = [allgx,gx]
                allgy = [allgy,gy]
            endif

        endif;IN SCATTERING PLANE
    endfor;i

    allgx = [allgx,2*dotp(kiarr[*,0],xhat)]
    allgy = [allgy,2*dotp(kiarr[*,0],yhat)]
    allgx = [allgx,2*dotp(kfarr[*,0],xhat)]
    allgy = [allgy,2*dotp(kfarr[*,0],yhat)]

    xrange = [min(allgx),max(allgx)]
    yrange = [min(allgy),max(allgy)]

    plot,xrange,yrange,background = white,color=0L,/nodata,$
         subtitle=title,xtitle=xtitle,ytitle=ytitle,xstyle=4,ystyle=4,$
         xmargin=[8,8],ymargin=[4,4];,/isotropic
xyouts,0.25,0.97,overalltitle,color=black,/normal

    x0 = !x
    y0 = !y
;    print,!x.crange

    ;I CAN SWAP THE AXES WHENEVER I WANT BY SWITCHING xaxis=0 to xaxis=1
    ;AND VICE VERSA.

    ;THESE AXES ARE THE ALTERNATE AXES IN spurion.
    ;THEY ARE IN INVERSE ANGSTROM UNITS
    AXIS, XAXIS=1, XRANGE = (!X.CRANGE), XSTYLE = 1, $
          XTITLE = xtitle,color=0L,xcharsize=0.75
    AXIS, YAXIS=1, YRANGE = (!Y.CRANGE), YSTYLE = 1, $
          YTITLE = ytitle,color=0L,ycharsize=0.65


    xtitle0 = 'X [hkl units]  || ['+ $
                strtrim(string(o1[0],format='(f4.1)'),2)+','+ $
                strtrim(string(o1[1],format='(f4.1)'),2)+','+ $
                strtrim(string(o1[2],format='(f4.1)'),2)+']';o1[0]*b1+o1[1]*b2+o1[2]*b3'
    ytitle0 = 'Y [hkl units]  || Z x X';perp o1.[b1,b2,b3],coplanar w/o1.[b1,b2,b3]&o2.[b1,b2,b3]'

    ;THESE AXES ARE THE PRIMARY AXES IN spurion
    ;THEY ARE IN UNITS OF hkl, i.e. DIMENSIONLESS!!!
    AXIS, XAXIS=0, XRANGE = (!X.CRANGE)/mago1vec, XSTYLE = 1, $
          XTITLE = xtitle0,color=0L

    ;GET ANGLE OF o2 WRT X AXIS
    o2theta = acos(dotp(o2vec,xhat)/mago2vec)
    ;CALCULATE THE COMPONENT OF o2 ALONG Y
    yscale  = mago2vec/sin(o2theta)
    ;CREATE ALTERNATE Y AXIS
    AXIS, YAXIS=0, YRANGE = (!Y.CRANGE)/yscale, YSTYLE = 1, $
          YTITLE = ytitle0,color=0L

    thick = 2

    !x = x0
    !y = y0

    ;DRAW Q WITH Ki,Kf HARMONICS
    if n_elements(Q) eq 3 then begin

        ;ki,kf HARMONICS
        for i=0,nvec-1 do begin

            if i eq 0 then begin
                xio = dotp(kiarr[*,i],xhat)
                yio = dotp(kiarr[*,i],yhat)

                ;USE -kf FOR PLOTTING
                xfo = -dotp(kfarr[*,i],xhat)
                yfo = -dotp(kfarr[*,i],yhat)

;                arrow,[0],[0],[dotp(kiarr[*,i],xhat)],[dotp(kiarr[*,i],yhat)],color=blue+red,/data
;                arrow,[0],[0],[dotp(kfarr[*,i],xhat)],[dotp(kfarr[*,i],yhat)],color=blue+green,/data

                arrow,[0],[0],xio,yio,color=blue+red,/data,thick=thick
                arrow,[xio],[yio],xio+xfo,yio+yfo,color=blue+green,/data,thick=thick
            endif;i eq 0
;            if harmonics eq 1 then begin
;                ;print,'HEY HARMONICS!!!'
;                xio = dotp(kiarr[*,i],xhat)
;                yio = dotp(kiarr[*,i],yhat)
;
;                ;USE -kf FOR PLOTTING
;                xfo = -dotp(kfarr[*,i],xhat)
;                yfo = -dotp(kfarr[*,i],yhat)
;                oplot,[xio+xfo],$
;                      [yio+yfo],$
;                      psym=2,$
;                      color=red,$
;                      symsize=5;green;red+green
;                oplot,[xfo+xio],$
;                      [yfo+yio],$
;                      psym=2,$
;                      color=red,$
;                      symsize=5;green;color=red+green
;
;;                arrow,[0],[0],[dotp(kiarr[*,i],xhat)],[dotp(kiarr[*,i],yhat)],color=blue+red,/data
;;                arrow,[0],[0],[dotp(kfarr[*,i],xhat)],[dotp(kfarr[*,i],yhat)],color=blue+green,/data
;            endif;harmonics
        endfor;i

        if harmonics eq 1 then begin
            ;print,'HARMONICS!!!!!'
            for i=0,nvec-1 do begin
                xio = dotp(kiarr[*,i],xhat)
                yio = dotp(kiarr[*,i],yhat)
                xfo = -dotp(kfarr[*,i],xhat)
                yfo = -dotp(kfarr[*,i],yhat)
                for j=0,nvec-1 do begin
                    xfoj=-dotp(kfarr[*,j],xhat)
                    yfoj=-dotp(kfarr[*,j],yhat)
                    xioj=dotp(kiarr[*,j],xhat)
                    yioj=dotp(kiarr[*,j],yhat)

                    color=long(red*double(i)/double(nvec-1))+long(blue*double(j)/double(nvec-1))

                    oplot,[xio+xfoj],$
                          [yio+yfoj],$
                          psym=2,$
                          color=color;blue;green;red+green
                    oplot,[xfo+xioj],$
                          [yfo+yioj],$
                          psym=2,$
                          color=color;blue;green;red+green
;                    arrow,[xio],[yio],[xio+dotp(kfarr[*,j],xhat)],$
;                          [yio+dotp(kfarr[*,j],yhat)],color=blue+green,/data
;                    arrow,[xfo],[yfo],[xfo+dotp(kiarr[*,j],xhat)],$
;                          [yfo+dotp(kiarr[*,j],yhat)],color=blue+red,/data
                endfor;j
            endfor;i
        endif;harmonics

        ;Q
        arrow,[0],[0],[dotp(Qarr[*,0,0],xhat)],[dotp(Qarr[*,0,0],yhat)],color=blue,/data,thick=thick

    endif

    ;PLOT THE RECIPROCAL LATTICE
    for i=0,nq-1 do begin

        h = hkl[0,i]
        k = hkl[1,i]
        l = hkl[2,i]

        g    = h*b1 + k*b2 + l*b3
;        ghkl = [h,k,l]

        gx = dotp(g,xhat)
        gy = dotp(g,yhat)

        ;THIS CONVERSION IS COVERED BY THE axis CALLS ABOVE!!!
        ;AND THIS IS NOT CORRECT HERE!!!
;        gxhkl = dotp(ghkl,o1hat)
;        gyhkl = dotp(ghkl,o2hat)

        ;PLOT ALL G's IN THE SCATTERING PLANE
        if dotp(G,crossp(o1vec,o2vec)) eq 0.0 then begin

            wset,qwid;0
            !x = x0 & !y = y0
            oplot,[gx],[gy],color=255L+(256L^2)*bytscl(alog(strf[i]+1)),psym=4

        endif;IN SCATTERING PLANE
    endfor;i

    ;IF I GET THIS WORKING RIGHT, THEN I CAN CONVERT
    ;Al POWDER RINGS AND Ki,Kf INTO Q SPACE.

    alewald,al,hklal
    ;help,al

    theta = 2.0*!PI*findgen(361)/360.0
    for i=0,n_elements(al)-1 do begin
        x = al[i]*cos(theta)
        y = al[i]*sin(theta)

        wset,qwid;0
        !x = x0 & !y = y0
        oplot,x,y,psym=0,linestyle=i mod 5,color=256L*255L

    endfor;i


    ;PLOT ENERGY v. Q
    qmag = sqrt(dotp(Q,Q))
    if ewid eq 1 then begin
        window,1
    endif else begin
        wset,ewid
    endelse

    ;plot,[qmag,qmag],[min(earr),max(earr)],color=black,background=white,/nodata
;    plot,[Q,Q],[min(earr),max(earr)],color=black,background=white,/nodata,$
;        xtitle='Q',ytitle='dE'
;    for i=0,nvec-1 do begin
;        for j=0,nvec-1 do begin
;                oplot,[qmag],[earr[i,j]],psym=4,$
;                        color=long(red*double(i)/double(nvec))+long(blue*double(i)/double(nvec))
;        endfor;j
;    endfor;i

;SIMULATE ELEMENTS OF A SCAN
    if n_elements(ki) eq 3 and n_elements(kf) eq 3 then begin
        nvec = 5
        qevalsm1 = QE(ki-[0.1*ki[0],0,0],kf,nvec)

        Qm1       = qevalsm1.Q
        kiarrm1   = qevalsm1.kiarr
        kfarrm1   = qevalsm1.kfarr
        Qarrm1    = qevalsm1.Qarr
        QMagarrm1 = qevalsm1.QMagarr
        Earrm1    = qevalsm1.Earr
        qmagm1 = sqrt(dotp(Qm1,Qm1))
    endif
;    for i=0,nvec-1 do begin
;        for j=0,nvec-1 do begin
;                oplot,[qmag],[earrm1[i,j]],psym=4,$
;                        color=long(red*double(i)/double(nvec))+long(blue*double(i)/double(nvec))
;        endfor;j
;    endfor;i
;SIMULATE ELEMENTS OF A SCAN

;USE THE FOLLOWING FUNCTION TO GET ki,kf FOR EACH POINT WHEN GIVEN THE Q
;
;getkikf_from_efixed_etran,Efixed,Etran,Qxy,kf_fixed=kf_fixed,ki_fixed=ki_fixed
;
;
    if n_elements(ki) eq 3 and n_elements(kf) eq 3 then begin
        nvec = 5
        qevalsp1 = QE(ki+[0.1*ki[0],0,0],kf,nvec)

        Qp1       = qevalsp1.Q
        kiarrp1   = qevalsp1.kiarr
        kfarrp1   = qevalsp1.kfarr
        Qarrp1    = qevalsp1.Qarr
        QMagarrp1 = qevalsp1.QMagarr
        Earrp1    = qevalsp1.Earr
        qmagp1 = sqrt(dotp(Qp1,Qp1))
    endif
;    for i=0,nvec-1 do begin
;        for j=0,nvec-1 do begin
;                oplot,[qmag],[earrp1[i,j]],psym=4,$
;                        color=long(red*double(i)/double(nvec))+long(blue*double(i)/double(nvec))
;        endfor;j
;    endfor;i
;    print,[qmagm1,qmag,qmagp1]

    edata = [earrm1,earr,earrp1]
    qdata = [qmagm1,qmag,qmagp1]
    erange = [min(edata),max(edata)]
    qrange = [min(qdata),max(qdata)]
    plot,qrange,erange,color=black,background=white,/nodata,$
        xtitle='Q',ytitle='dE',title='Hypothetical 3pt scan'

    for i=0,nvec-1 do begin
        for j=0,nvec-1 do begin
;                print,[earrm1[i,j],earr[i,j],earrp1[i,j]]
                oplot,[qmagm1,qmag,qmagp1],[earrm1[i,j],earr[i,j],earrp1[i,j]],psym=-3,$
                        color=long(red*double(i)/double(nvec-1))+long(blue*double(j)/double(nvec-1))
        endfor;j
    endfor;i


end;test_recip

