;===============================================================================
pro wd_setDataAxesLabels_event, event
  compile_opt idl2
  
  uname = widget_info(event.id,/uname)
  widget_control, event.top, get_uvalue=sPtr

  list = ['XN','YN','DN','XT','YT','DT','XU','YU','DU']

  case uname of
     'OK': begin
        for i=0,n_elements(list)-1 do begin
           id = widget_info(event.top,find_by_uname=list[i])
           widget_control, id, get_value=lab
           (*sPtr).label[i] = lab
        endfor
        
        (*sPtr).ok = 1
        
        widget_control, event.top, /destroy
     end

     'CANCEL': begin
        (*sPtr).ok = 0
        widget_control, event.top, /destroy
     end

     else: begin
        (*sPtr).ok = 0
        widget_control, event.top, /destroy
     end
  endcase 
end

function wd_setDataAxesLabels, label, group_leader=gpl
  compile_opt idl2

  title = 'Specify axes labels for data'
  if (n_elements(gpl) gt 0) then begin
     modal = 1
     wTLB = widget_base(/col,title=title,/base_align_center,group_leader=gpl,modal=modal)
  endif else begin
     modal = 0
     wTLB = widget_base(/col,title=title ,/base_align_center,modal=modal)
  endelse
  cb0 = widget_base(wTLB,/frame,/col)
  labs = ['X axis: ','Y axis: ','Z axis: ']
  uN = ['XN','YN','DN']
  uT = ['XT','YT','DT']
  uU = ['XU','YU','DU']
  label = (n_elements(label) eq 0)? strarr(9) : label
  
  xs = 600
  cb = widget_base(cb0,/grid,col=4,scr_xsize=xs)
  void = widget_label(cb,value='')  
  void = widget_label(cb,value='Name (eg T)')  
  void = widget_label(cb,value='Text label (eg Temperature)')
  void = widget_label(cb,value='Units (eg K)')
  for i=0,2 do begin
     cb = widget_base(cb0,/grid,col=4,scr_xsize=xs)
     void = widget_label(cb,value=labs[i],/align_right)
     void = widget_text(cb,uname=uN[i],value=label[i],/editable)
     void = widget_text(cb,uname=uT[i],value=label[i+3],/editable)
     void = widget_text(cb,uname=uU[i],value=label[i+6],/editable)
  endfor

  cb1 = widget_base(wTLB,/row) 
  void = widget_button(cb1,value='OK',uname='OK')
  void = widget_button(cb1,value='CANCEL',uname='CANCEL')

  sPtr = ptr_new({label:label,ok:0B})
  widget_control, wTLB, /realize, set_uvalue=sPtr

  xmanager,'wd_setDataAxesLabels',wTLB,no_block=modal
  
  label = (*sPtr).label
  retVal = (*sPtr).ok
  ptr_free, sPtr

  return, retVal

end
