; $Id$
;###############################################################################
;+
; NAME:
;   wd_dataSlice
;
; PURPOSE:
;   The widget creation routine of the UI service for the 
;   Data Slice operation.
;
; CATEGORY:
;   DAVE Widgets
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; Jan 2009
;-
;###############################################################################


;===============================================================================
; wd_dataSlice_event
;
; PURPOSE:
;   Main event handler
;
; PARAMETERS
;   event (in) - event structure
;
; KEYWORDS:
;
pro wd_dataSlice_event, event
compile_opt idl2

widget_control, event.top, get_uvalue=pCancel

; manually destroy widget
if (tag_names(event,/struct) eq 'WIDGET_KILL_REQUEST') then begin
   *pCancel = 0   ; cancelled set
   widget_control, event.top, /destroy
   return
endif

case widget_info(event.id, /uname) of
   'OK': widget_control, event.top, /destroy

   'CANCEL': begin
      *pCancel = 0   ; 
      widget_control, event.top, /destroy
   end

   else:
endcase

end



;===============================================================================
; wd_dataSlice
;
; PURPOSE:
;   The widget creation routine
;
; PARAMETERS
;   oUI (in) - Object reference of the UI tool.
;
;
; KEYWORDS:
;   title (in) - The widget title
;
;   group_leader - widget id to be used as group_leader
;
;   value (in) - The object(s) whose properties are to be displayed
;
; RETURN
;   1 => Okay button pressed to exit
;   0 => Okay button not used to exit
;
function wd_dataSlice, oUI, title=title, value=oComponent, group_leader=gl $
                   ,xsize1=xs1, ysize1=ys1 $   ; passed to cw_itpropertysheet
                   ,xsize2=xs2, ysize2=ys2 $   ; passed to cw_dataSlice
                   ,_REF_EXTRA=etc
compile_opt idl2

title = (n_elements(title) gt 0)? title : 'Data Slice'

gl = (n_elements(gl) gt 0)? gl : 0L
hasGL = widget_info(gl,/valid)

; floating base
wTLB = widget_base(uname='TLB', /col $
                      ,floating=hasGL $
                      ,modal=hasGL $
                      ,group_leader=gl $
                      ,title=title $
                      ,/tlb_kill_request_events $
                      ,space=10 $
                      ,_EXTRA=etc)

; Add the property sheet
wProp = cw_itpropertysheet(wTLB, oUI, value=oComponent->GetFullIdentifier() $
                               ,scr_xsize=xs1,ysize=ys1 $
                               ,commit_changes=0 $ ;
                               ,_EXTRA=etc)
                               
; Add the data slicer graphics section
wPreview = cw_dataSlice(wTLB, oUI, xsize=xs2, ysize=ys2, value=oComponent, _EXTRA=etc)


wCB = widget_base(wTLB, /row, /grid, space=5)
void = widget_label(wCB,value='')
void = widget_label(wCB,value='')
; Okay button
wOK = widget_button(wCB,value='OK',uname='OK')

; Cancel button
wCancel = widget_button(wCB, value='Cancel', uname='CANCEL')


; realize
cancelPtr = ptr_new(1)   ; assume cancel(=0) by default
widget_control, wTLB, /realize, set_uvalue=cancelPtr

; start event processing
xmanager, 'WD_DATASLICE', wTLB, no_block=0   ; NB - wTLB is modal!

; after user is done, do final cleanup and return user selection (ok,cancel)
status = (*cancelPtr)
ptr_free, cancelPtr

; rollback changes to operation object if cancel button was used
if (status eq 0) then begin
   oTool = oUI->GetTool()
   oCmdBuf = oTool->_GetCommandBuffer()
   if (obj_valid(oCmdBuf)) then oCmdBuf->Rollback
endif

return, status

end