; $Id$
;
; Copyright (c) 2000-2004, Research Systems, Inc.  All rights reserved.
;   Unauthorized reproduction prohibited.
;----------------------------------------------------------------------------
;+
; CLASS_NAME:
;   IDLitToolbase
;
; PURPOSE:
;   This file implements the IDL Tool base object, from which all other
;   Tools are subclassed.
;
; CATEGORY:
;   IDL Tools
;
; SUPERCLASSES:
;   IDLitTool
;
; SUBCLASSES:
;
; CREATION:
;   See IDLitToolbase::Init
;
; METHODS:
;   This class has the following methods:
;
;   IDLitToolbase::Init
;
; INTERFACES:
; IIDLProperty
;-


;===============================================================================
; DAVEtool::GetSystem
; 
; PURPOSE:
;   Return the IDLitSystem object
;
; PARAMETERS:
;
; KEYWORDS:
;
function DAVEvisToolbase::GetSystem
compile_opt idl2

return, self->_GetSystem()

end


;===============================================================================
; DAVEvisToolbase::GetUI
; 
; PURPOSE:
;   Return the IDLitUI object for this tool
;
; PARAMETERS:
;
; KEYWORDS:
;
function DAVEvisToolbase::GetUI
compile_opt idl2

return, self._oUIConnection

end


;-------------------------------------------------------------------------------
pro DAVEvisToolbase::Cleanup
compile_opt idl2

; Locate the widget id (wNode) representing this vistool in the visualization
; tree widget and destroy it.
; wNode is stored as the uvalue of the tlb of this vistool
(self._oUIConnection)->getproperty, group_leader = wTLB
if (widget_info(wTLB,/valid_id)) then begin
    widget_control, wTLB, get_uvalue=wNode
    if (n_elements(wNode) && widget_info(wNode,/valid_id)) then begin
        widget_control, wNode, get_uvalue=sPtr_wNode ; get state structure
        widget_control, widget_info((*sPtr_wNode).wTLB_DAVETool,/child), get_uvalue=sPtr ; get DAVE Tool sPtr
        if ((*sPtr).currentTab eq 1) then begin ; clear the property sheet
;            widget_control, (*sPtr).wPS, get_uvalue=state, /no_copy
;            state.oUI = (*sPtr).oUI
;            widget_control, (*sPtr).wPS, set_uvalue=state, /no_copy
            widget_control, (*sPtr).wPS, get_uvalue=statePtr
            (*statePtr).oUI = (*sPtr).oUI

            widget_control, (*sPtr).wPS, set_value=''
        endif
        ;widget_control, wNode, /destroy ; remove entry for vis from tree widget
    endif
endif


; Call base class cleanup
self->IDLitTool::Cleanup

end


;===============================================================================
; DAVEvisToolbase::GetMainVisualizations
; 
; PURPOSE:
;   Return the major visualization objects from the dataspace container
;
; PARAMETERS:
;
; KEYWORDS:
;
function DAVEvisToolbase::GetMainVisualizations, count=count
compile_opt idl2

count = 0
oWin = Self->GetCurrentWindow()
if (~obj_valid(oWin)) then return, obj_new()

oView = oWin->GetCurrentView()
if (~obj_valid(oView)) then return, obj_new()
oLayer = oView->GetCurrentLayer()
if (~obj_valid(oLayer)) then return, obj_new()
oWorld = oLayer->GetWorld()
if (~obj_valid(oWorld)) then return, obj_new()
oDataSpace = oWorld->GetDataSpaces()
if (~obj_valid(oDataSpace)) then return, obj_new()

nDS = N_ELEMENTS(oDataSpace)
for i=0,nDS-1 do begin
   oDS = oDataSpace[i]
   if (obj_valid(oDS)) then begin
      oItems = oDS[i]->GetVisualizations(COUNT=count)
         if (count gt 0) then begin
            oVis = (n_elements(oVis) gt 0)? [oVis,oItems] : oItems
            nVis = (n_elements(nVis) gt 0)? nVis+count : count 
         endif
   endif
endfor

count = nVis
return, oVis

end


;-------------------------------------------------------------------------------
pro DAVEvisToolbase::GetProperty, nameTag=nameTag, prompt=prompt, prmptTitle=prmptTitle, prmptDesc=prmptDesc, $
                                  knownVis=knownVis, _REF_EXTRA=etc
compile_opt idl2

; known major visualizations
if (arg_present(knownVis)) then begin
   knownVis = ['Plot','Plot3D','Surface','Image','Contour','Volume' $
               ,'Isosurface','Internal Volume','Image Plane','Plot Profile' $
               ,'IDL Graphics Object','Vector','Map Grid','Shape Polygon' $
               ,'Shape Polyline','Shape Point','Streamline']
endif

; nameTag
if (arg_present(nameTag)) then $
  nameTag = self.nameTag

; prompt
if (arg_present(prompt)) then $
  prompt = self.prompt

; prompt Title
if (arg_present(prmptTitle)) then $
  prmptTitle = self.promptTitle

; prompt Desc
if (arg_present(prmptDesc)) then $
  prmptDesc = self.promptDesc

; Call base class method
if (n_elements(etc) gt 0) then $
  self->IDLitTool::GetProperty, _EXTRA=etc

end


;-------------------------------------------------------------------------------
pro DAVEvisToolbase::SetProperty, nameTag=nameTag, prompt=prompt, _EXTRA=etc
compile_opt idl2

; nameTag
if (n_elements(nameTag)) then $
  self.nameTag = strtrim(nameTag,2)

; prompt
if (n_elements(prompt)) then $
  self.prompt = strtrim(prompt,2)

; Call base class method
if (n_elements(etc) gt 0) then $
  self->IDLitTool::SetProperty, _EXTRA=etc

end



;---------------------------------------------------------------------------
; Lifecycle Routines
;---------------------------------------------------------------------------
; DAVEvisToolbase::Init
;
; Purpose:
; The constructor of the DAVEvisToolbase object.
;
; Parameters:
; None.
;
function DAVEvisToolbase::Init, _REF_EXTRA=_EXTRA
compile_opt idl2

;; Call our super class
if (~self->IDLitTool::Init(_EXTRA=_extra)) then $
  return, 0

oSystem = self->_GetSystem()

;;---------------------------------------------------------------------
;;*** File Menu

;; create folders
self->createfolders,'Operations/File',NAME=IDLitLangCatQuery('Menu:File')
;   self->createfolders,'Operations/File/New', $
;                       NAME=IDLitLangCatQuery('Menu:File:New')

;     self->RegisterOperation, 'iPlot', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Plot'

;     self->RegisterOperation, 'iSurface', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Surface'

;     self->RegisterOperation, 'iContour', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Contour'

;     self->RegisterOperation, 'iImage', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Image'

;     self->RegisterOperation, 'iVolume', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Volume'

;     self->RegisterOperation, 'iMap', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Map'

;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Open'), $
;  'IDLitopFileOpen', $
;  ACCELERATOR='Ctrl+O', $
;  DESCRIPTION='Open an existing data or image file', $
;  IDENTIFIER='File/Open', ICON='open'

                                ;-----------------
;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Import'), $
;  'IDLitopImportData', $
;  IDENTIFIER='File/Import', $
;  /SEPARATOR
;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Export'), $
;  'IDLitopExportData',icon='camera', $
;  IDENTIFIER='File/Export'
Self->RegisterOperation,'Export Graphics...' $
  ,'DAVEopExportGraphics', identifier='File/Export' $
  ,ACCELERATOR='Ctrl+E' $
  ,writertypes=['IDLDEST','IDLIMAGE'] $
  ,icon='export'

                                ;-----------------
;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Save'), $
;  'IDLitopFileSave', $
;  ACCELERATOR='Ctrl+S', $
;  IDENTIFIER='File/Save', ICON='save', /SEPARATOR

;self->RegisterOperation, IDLitLangCatQuery('Menu:File:SaveAs'), $
;  'IDLitopFileSaveAs', $
;  IDENTIFIER='File/SaveAs', ICON='save'

                                ;-----------------
self->RegisterOperation, IDLitLangCatQuery('Menu:File:PrintPreview'), $
  'IDLitopPrintPreview', $
  DESCRIPTION='Print the contents of the active window', $
  IDENTIFIER='File/PrintPreview', ICON='print'

self->RegisterOperation, IDLitLangCatQuery('Menu:File:Print'), $
  'IDLitopFilePrint', $
  ACCELERATOR='Ctrl+P', $
  DESCRIPTION='Print the contents of the active window', $
  IDENTIFIER='File/Print', ICON='print_24'


;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Preferences'), $
;  'IDLitopBrowserPrefs', $
;  IDENTIFIER='File/Preferences', /SEPARATOR

                                ;-----------------
self->RegisterOperation, 'Delete Visualization', $
  'DAVEopFileExit', $ ;'IDLitopFileExit', $
  description='Visualization', $
  ACCELERATOR='Ctrl+Q', $
  IDENTIFIER='File/Exit', /SEPARATOR


;;---------------------------------------------------------------------
;; Create our File toolbar container.
;;
;self->Register, IDLitLangCatQuery('Menu:File:New'), 'IDLitOpNewTool', $
;                IDENTIFIER='Toolbar/File/NewTool', ICON='new'
;self->Register, IDLitLangCatQuery('Menu:File:Open'), $
;                PROXY='Operations/File/Open', $
;                IDENTIFIER='Toolbar/File/Open'
;self->Register, IDLitLangCatQuery('Menu:File:Save'), $
;                PROXY='Operations/File/Save', $
;                IDENTIFIER='Toolbar/File/Save'
self->Register, IDLitLangCatQuery('Menu:File:Print'), $
                PROXY='Operations/File/Print', $
                IDENTIFIER='Toolbar/File/Print'
self->Register, IDLitLangCatQuery('Menu:File:PrintPreview'), $
                PROXY='Operations/File/PrintPreview', $
                IDENTIFIER='Toolbar/File/PrintPreview'
self->Register, IDLitLangCatQuery('Menu:File:Export'), $
                PROXY='Operations/File/Export', $
                IDENTIFIER='Toolbar/File/Export'


;;---------------------------------------------------------------------
;;*** Edit Menu

self->createfolders,'Operations/Edit',NAME=IDLitLangCatQuery('Menu:Edit')

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Undo'), $
  'IDLitopUndo', $
  ACCELERATOR='Ctrl+Z', $
  IDENTIFIER='Edit/Undo', ICON='undo', /disable, $
  /IGNORE_AVAILABILITY

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Redo'), $
  'IDLitopRedo', $
  ACCELERATOR='Ctrl+Y', $
  IDENTIFIER='Edit/Redo', ICON='redo',/disable, $
  /IGNORE_AVAILABILITY

;; Clipboard...note these are proxied from the system registry!

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Cut'), $
  PROXY="/REGISTRY/OPERATIONS/CUT",$
  IDENTIFIER='Edit/Cut'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Copy') , $
  PROXY='/REGISTRY/OPERATIONS/COPY', $
  IDENTIFIER='Edit/Copy'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Paste') , $
  PROXY='/REGISTRY/OPERATIONS/Paste', $
  IDENTIFIER='Edit/Paste'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:PasteSpecial') , $
  PROXY='/REGISTRY/OPERATIONS/PASTESPECIAL', $
  IDENTIFIER='Edit/PasteSpecial'

                                ;-----------------
self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Delete') , $
  PROXY='/REGISTRY/OPERATIONS/Delete', $
  IDENTIFIER='Edit/Delete'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SelectAll') , $
  'IDLitopSelectAll', $
  DESCRIPTION="Select all visualizations in the current view.", $
  IDENTIFIER='Edit/SelectAll', $
  ICON='select'


                                ;-----------------
self->createfolders,'Operations/Edit/Grouping', $
                    NAME=IDLitLangCatQuery('Menu:Edit:Grouping')

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Group'), $
  'IDLitopGroup', $
  IDENTIFIER='Edit/Grouping/Group', $
  ICON='group', $
  /SEPARATOR

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Ungroup'), $
  'IDLitopUngroup', $
  IDENTIFIER='Edit/Grouping/Ungroup', $
  ICON='ungroup'

self->createfolders,'Operations/Edit/Order', $
                    NAME=IDLitLangCatQuery('Menu:Edit:Order')

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:BringToFront'), $
  'IDLitopBringToFront', $
  IDENTIFIER='Edit/Order/BringToFront', $
  ICON='front'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SendToBack'), $
  'IDLitopSendToBack', $
  IDENTIFIER='Edit/Order/SendToBack', $
  ICON='back'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:BringForward'), $
  'IDLitopBringForward', $
  IDENTIFIER='Edit/Order/BringForward', $
  ICON='front'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SendBackward'), $
  'IDLitopSendBackward', $
  IDENTIFIER='Edit/Order/SendBackward', $
  ICON='back'


;;---------------------------------------------------------------------
;;*** Format Menu

self->createfolders,'Operations/Edit/Style', $
                    NAME=IDLitLangCatQuery('Menu:Style')

self->RegisterOperation, IDLitLangCatQuery('Menu:Style:ApplyStyle') , $
  PROXY='/REGISTRY/OPERATIONS/Apply Style', $
  IDENTIFIER='Edit/Style/Apply Style'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Style:CreateStylefromSelection'), $
  'IDLitopStyleCreate', $
  IDENTIFIER='Edit/Style/Create Style', $
  ICON='style'

self->RegisterOperation, IDLitLangCatQuery('Menu:Style:StyleEditor'), $
  'IDLitopStyleEditor', $
  IDENTIFIER='Edit/Style/StyleEditor', $
  ICON='style'


;;-----------------
;; Register here but make private. We only expose this operation
;; in the context menu, but we want it to be (de)sensitized along with
;; the rest of the Edit menu.
self->RegisterOperation, 'Export to IDL...', 'IDLitopclExport', $
  /PRIVATE, $
  DESCRIPTION='Export Visualization Parameters to IDL Variables. ', $
  IDENTIFIER='Edit/CLExport', $
  /separator


;;-----------------
;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Parameters'), $
;  'IDLitopEditParameters', $
;  IDENTIFIER='Edit/EditParameters', $
;  ICON='binary', $
;  /separator
self->RegisterOperation, 'EditParameters', 'IDLitopEditParameters'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Properties'), $
  'IDLitopPropertySheet', $
  DESCRIPTION='Display the Property Sheet for the item', $
  IDENTIFIER='Edit/Properties', $
  ICON='propsheet'


;;---------------------------------------------------------------------
;; Create our Edit toolbar container.
;;
self->Register, IDLitLangCatQuery('Menu:Edit:Undo'), $
                PROXY='Operations/Edit/Undo', $
                IDENTIFIER='Toolbar/Edit/Undo'
self->Register, IDLitLangCatQuery('Menu:Edit:Redo'), $
                PROXY='Operations/Edit/Redo', $
                IDENTIFIER='Toolbar/Edit/Redo'
self->Register, IDLitLangCatQuery('Menu:Edit:Cut'), $
                PROXY="/REGISTRY/OPERATIONS/CUT",$
                IDENTIFIER='Toolbar/Edit/Cut'
self->Register, IDLitLangCatQuery('Menu:Edit:Copy'), $
                PROXY='/REGISTRY/OPERATIONS/COPY', $
                IDENTIFIER='Toolbar/Edit/Copy'
self->Register, IDLitLangCatQuery('Menu:Edit:Paste'), $
                PROXY='/REGISTRY/OPERATIONS/Paste', $
                IDENTIFIER='Toolbar/Edit/Paste'


;;---------------------------------------------------------------------
;;*** Insert menu

self->createfolders,'Operations/Insert', $
                    NAME=IDLitLangCatQuery('Menu:Insert')

;self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:Visualization'), $
;  'IDLitopInsertVis', $
;  IDENTIFIER='Insert/Visualization', ICON='view'
self->RegisterOperation, 'Insert Visualization','IDLitopInsertVis';, $
;  IDENTIFIER='Insert/Visualization', ICON='view'

self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:View'), $
  'IDLitopInsertView', $
  IDENTIFIER='Insert/View', ICON='view'

self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:DataSpace'), $
  'IDLitopInsertDataSpace', $
  IDENTIFIER='Insert/Data Space', ICON='mcr'

self->createfolders,'Operations/Insert/Axis', $
                    NAME=IDLitLangCatQuery('Menu:Insert:Axis')

self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:XAxis'), $
  'IDLitOpInsertAxisX', $
  IDENTIFIER='Insert/Axis/X Axis', ICON='mcr'
self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:YAxis'), $
  'IDLitOpInsertAxisY', $
  IDENTIFIER='Insert/Axis/Y Axis', ICON='mcr'
self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:ZAxis'), $
  'IDLitOpInsertAxisZ', $
  IDENTIFIER='Insert/Axis/Z Axis', ICON='mcr'


;;---------------------------------------------------------------------
;;*** Operations Menu
self->createfolders,'Operations/Operations', $
                    NAME=IDLitLangCatQuery('Menu:Operations')

;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:OperationsBrowser'), $
;  'IDLitopBrowserOperation', $
;  IDENTIFIER='Operations/Operations Browser' ; ,ICON='mcr'

self->createfolders,'Operations/Operations/Macros', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Macros')

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RunMacro'), $
  PROXY='/Registry/MacroTools/Run Macro', $
  IDENTIFIER='Operations/Macros/Run Macro'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:StartRecording'), $
  PROXY='/Registry/MacroTools/Start Recording', $
  IDENTIFIER='Operations/Macros/Start Recording'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:StopRecording'), $
  PROXY='/Registry/MacroTools/Stop Recording', $
  IDENTIFIER='Operations/Macros/Stop Recording'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:MacroEditor'), $
  PROXY='/Registry/MacroTools/Macro Editor', $
  IDENTIFIER='Operations/Macros/Macro Editor'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:Statistics'), $
  'IDLitopStatistics', $
  DESCRIPTION='Display statistics for the selected item', $
  IDENTIFIER='Operations/Statistics', ICON='sum', /SEPARATOR

;self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Histogram'), $
;  'IDLitopHistogram', $
;  DESCRIPTION='Perform the histogram operation on the selected item', $
;  IDENTIFIER='Operations/Histogram', ICON='hist'

self->createfolders,'Operations/Operations/Filter', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Filter')

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:Convolution'), $
  'IDLitopConvolution', $
  DESCRIPTION='Perform the convolution operation on the selected item', $
  IDENTIFIER='Operations/Filter/Convolution', ICON='sum'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:Median'), $
  'IDLitopMedianFilter', $
  DESCRIPTION='Perform the median filter operation on the selected item', $
  IDENTIFIER='Operations/Filter/Median', ICON='sum'

self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Smooth'), $
  'IDLitopSmooth', $
  DESCRIPTION='Perform the smooth operation on the selected item', $
  IDENTIFIER='Operations/Filter/Smooth', ICON='sum'

self->createfolders,'Operations/Operations/Rotate', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Rotate')

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateLeft'), $
  'IDLitopRotateLeft', $
  DESCRIPTION='Rotate left by 90 degrees', $
  IDENTIFIER='Operations/Rotate/RotateLeft', $
  ICON='rotate'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateRight'), $
  'IDLitopRotateRight', $
  DESCRIPTION='Rotate right by 90 degrees', $
  IDENTIFIER='Operations/Rotate/RotateRight', $
  ICON='rotate'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateByAngle'), $
  'IDLitopRotateByAngle', $
  DESCRIPTION='Rotate by a specified angle', $
  IDENTIFIER='Operations/Rotate/RotateByAngle', $
  ICON='rotate'

self->createfolders,'Operations/Operations/Transform', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Transform')

self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Resample'), $
  'IDLitopResample', $
  IDENTIFIER='Operations/Transform/Resample', ICON='sum'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateData'), $
  'IDLitopRotateData', $
  DESCRIPTION='Rotate the data by a specified angle', $
  IDENTIFIER='Operations/Transform/RotateData', $
  ICON='sum'

self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:ScaleData'), $
  'IDLitopScaleFactor', $
  DESCRIPTION='Scale the data by a given factor', $
  IDENTIFIER='Operations/Transform/ScaleFactor', ICON='sum'


;self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:MapProjection'), $
;  'IDLitopMapProjection', $
;  IDENTIFIER='Operations/Map Projection', ICON='surface'


;;---------------------------------------------------------------------
;;*** Window Menu

self->createfolders,'Operations/Window', $
                    NAME=IDLitLangCatQuery('Menu:Window')

;;  Note: temporarily disabling ICON settings for browsers.
;self->RegisterOperation, IDLitLangCatQuery('Menu:Window:DataManager'), $
;  'IDLitopDataManager', $
;  IDENTIFIER='Window/Data Manager', $
;  ICON='prop'                   ; , ICON='mcr'

;     self->RegisterOperation,'Manipulator Browser','IDLitopBrowserManip', $
;         IDENTIFIER='Window/Manipulator Browser'; , ICON='mcr'

;     self->RegisterOperation, 'Tool Browser', 'IDLitopBrowserTool', $
;         IDENTIFIER='Window/Tool Browser'; , ICON='mcr'

;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Window:VisualizationBrowser'), $
;  'IDLitopBrowserVis', $
;  IDENTIFIER='Window/Visualization Browser' ; , ICON='mcr'


;;-----------------
Self->RegisterOperation, 'Reset to Default Data Range', 'IDLitopRangeReset' $
   ,description='Reset to default data range', identifier='Void/Resetrange' $
   ,icon='range_reset'

;;--
self->createfolders,'Operations/Toolbar/Dataspace',name='Dataspace'
self->Register, 'Reset to Default Data Range', $
                PROXY='Operations/Void/Resetrange', $
                IDENTIFIER='Toolbar/Dataspace/Resetrange'

;;-----------------
self->createfolders,'Operations/Window/Canvas Zoom', $
                    NAME=IDLitLangCatQuery('Menu:Window:CanvasZoom')

self->RegisterOperation, '800%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/800%', $
  ICON='zoom', /CHECKED;, /SEPARATOR
self->RegisterOperation, '400%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/400%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '200%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/200%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '100%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/100%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '75%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/75%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '50%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/50%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '25%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/25%', $
  ICON='zoom', /CHECKED

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:ZoomonResize'), $
  'IDLitopZoomResize', $
  ICON='zoom', $
  IDENTIFIER='Window/ZoomResize', /CHECKED

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:Layout'), $
  'IDLitopWindowLayout', $
  IDENTIFIER='Window/Layout'

                                ;-----------------

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:FittoView'), $
  'IDLitopFitToView', $
  IDENTIFIER='Window/FitToView', $
  ICON='fitwindow', /SEPARATOR

;;---------------------------------------------------------------------
;;*** Help Menu
self->createfolders,'Operations/Help', $
                    NAME=IDLitLangCatQuery('Menu:Help')


self->RegisterOperation, "User's Manual", 'DAVEopHelp', $
  IDENTIFIER='Help/DaveManual',helptopic='HELP_HOMEPAGE'
;-----------------

self->RegisterOperation, 'Help on Selected Item', 'DAVEopHelp', $
  IDENTIFIER='Help/HelpSelection'
self->RegisterOperation, "iTools User's Manual", 'DAVEopHelp', $
  IDENTIFIER='Help/iToolsManual',helptopic='ITOOLSUSERMANUAL',/separator
if (~lmgr(/vm) && ~lmgr(/runtime) && ~lmgr(/embedded)) then begin
    ;; include link to full IDL manual if running from the DE
    self->RegisterOperation, 'Help on iTools', 'IDLitopHelpiTools' $
      ,IDENTIFIER='Help/HelpiTools'
endif

self->RegisterOperation, 'About DAVE', 'DAVEopHelpAbout', $
  IDENTIFIER='Help/About DAVE',/separator




; self->RegisterOperation, IDLitLangCatQuery('Menu:Help:HelponiTools'), $
;   'IDLitopHelpiTools', $
;   ACCELERATOR='F1', $
;   IDENTIFIER='Help/HelpiTools'
;
; self->RegisterOperation, $
;   IDLitLangCatQuery('Menu:Help:HelpontheiToolsDataManager'), $
;   'IDLitopHelpDataManager', IDENTIFIER='Help/HelpDataManager'
;
; self->RegisterOperation, $
;   IDLitLangCatQuery('Menu:Help:HelpontheiToolsParameterEditor'), $
;   'IDLitopHelpParamEditor', IDENTIFIER='Help/HelpParamEditor'
;
; self->RegisterOperation, $
;   IDLitLangCatQuery('Menu:Help:HelponSelectedItem'), $
;   'IDLitopHelpSelection', $
;   IDENTIFIER='Help/HelpSelection', /SEPARATOR
;
; self->RegisterOperation, IDLitLangCatQuery('Menu:Help:HelponthisiTool'), $
;   'IDLitopHelpTool', $
;   IDENTIFIER='Help/HelpTool'
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Help:AboutiTools'), $
;  'IDLitopHelpAbout', $
;  IDENTIFIER='Help/About iTools'


;;---------------------------------------------------------------------
;;*** Manipulators
self->RegisterManipulator, 'Arrow', 'IDLitManipArrow', $
  ICON='arrow', /DEFAULT, IDENTIFIER="ARROW", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Select')

self->RegisterManipulator, 'Rotate', 'IDLitManipRotate', $
  ICON='rotate', IDENTIFIER="ROTATE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Rotate')

self->RegisterManipulator, 'View Pan', 'IDLitManipViewPan', $
  ICON='hand', IDENTIFIER="VIEWPAN", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Pan')

;;---------------------------------------------------------------------
;;*** View Zoom Manipulator
self->RegisterManipulator, 'View Zoom', 'IDLitManipViewZoom', $
  IDENTIFIER='View/ViewZoom', ICON='zoom', $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:ViewZoom')

;;---------------------------------------------------------------------
;; *** View Zoom Combobox

                                ; Combobox is not available on True64 (OSF Alpha)
useCombobox = ~(!VERSION.os eq 'OSF')
self->Register, 'View Zoom', 'IDLitopViewZoom', $
                IDENTIFIER='Toolbar/View/ViewZoom', $
                DROPLIST_EDIT=useCombobox, $
                DROPLIST_ITEMS=['800%', $
                                '400%', $
                                '200%', $
                                '150%', $
                                '130%', $
                                '100%', $
                                '75%',  $
                                '50%',  $
                                '25%'], $
                DROPLIST_INDEX=4, $
                /SINGLETON

;;---------------------------------------------------------------------
;;*** Annotation Manipulators
self->RegisterManipulator, 'Text', 'IDLitAnnotateText', $
  ICON='text', IDENTIFIER="ANNOTATION/TEXT", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateText')

self->RegisterManipulator, 'Line', 'IDLitAnnotateLine', $
  ICON='line', IDENTIFIER="ANNOTATION/LINE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateLine')

self->RegisterManipulator, 'Rectangle', 'IDLitAnnotateRectangle', $
  ICON='rectangl', IDENTIFIER="ANNOTATION/RECTANGLE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateRectangle')

self->RegisterManipulator, 'Oval', 'IDLitAnnotateOval', $
  ICON='ellipse', IDENTIFIER="ANNOTATION/OVAL", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateOval')

self->RegisterManipulator, 'Polygon', 'IDLitAnnotatePolygon', $
  ICON='segpoly', IDENTIFIER="ANNOTATION/POLYGON", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotatePolygon')

self->RegisterManipulator, 'Freehand', 'IDLitAnnotateFreehand', $
  ICON='freehand', IDENTIFIER="ANNOTATION/FREEHAND", $
  DESCRIPTION='Click & drag to draw'



;;---------------------------------------------------------------------
;;*** DrawContext
self->Register, 'Cut', $
                PROXY="/REGISTRY/OPERATIONS/CUT",$
                IDENTIFIER='ContextMenu/DrawContext/Cut'

self->Register, 'Copy', $
                PROXY='/REGISTRY/OPERATIONS/COPY', $
                IDENTIFIER='ContextMenu/DrawContext/Copy'

self->Register, 'Paste', $
                PROXY='/REGISTRY/OPERATIONS/Paste', $
                IDENTIFIER='ContextMenu/DrawContext/Paste'

                                ;-----------------
self->Register, 'Delete', $
                PROXY='/REGISTRY/OPERATIONS/Delete', $
                IDENTIFIER='ContextMenu/DrawContext/Delete'

                                ;-----------------
self->Register, 'Group', $
                PROXY='Operations/Edit/Grouping/Group', $
                IDENTIFIER='ContextMenu/DrawContext/Grouping/Group'

self->Register, 'Ungroup', $
                PROXY='Operations/Edit/Grouping/Ungroup', $
                IDENTIFIER='ContextMenu/DrawContext/Grouping/Ungroup'

self->Register, 'Bring To Front', $
                PROXY='Operations/Edit/Order/BringToFront', $
                IDENTIFIER='ContextMenu/DrawContext/Order/BringToFront'

self->Register, 'Send To Back', $
                PROXY='Operations/Edit/Order/SendToBack', $
                IDENTIFIER='ContextMenu/DrawContext/Order/SendToBack'

self->Register, 'Bring Forward', $
                PROXY='Operations/Edit/Order/BringForward', $
                IDENTIFIER='ContextMenu/DrawContext/Order/BringForward'

self->Register, 'Send Backward', $
                PROXY='Operations/Edit/Order/SendBackward', $
                IDENTIFIER='ContextMenu/DrawContext/Order/SendBackward'

                                ;-----------------
self->Register, 'Export to IDL...', $
                PROXY='Operations/Edit/CLExport', $
                IDENTIFIER='ContextMenu/DrawContext/CLExport'

                                ;-----------------
;self->Register, 'Parameters...', $
;                PROXY='Operations/Edit/EditParameters', $
;                IDENTIFIER='ContextMenu/DrawContext/EditParameters'

self->Register, 'Properties...', $
                PROXY='Operations/Edit/Properties', $
                IDENTIFIER='ContextMenu/DrawContext/Properties'

;;---------------------------------------------------------------------
;;*** CropContext
self->Register, 'Crop...', 'IDLitopCropImage', $
                DESCRIPTION='Crop the selected image', $
                IDENTIFIER='ContextMenu/CropDrawContext/Crop', $
                ICON='crop', $
                /SINGLETON


;; Finally, set the prompt property to 1 meaning display a warning dialog 
;; before deleting this tool
self.prompt = 1
Self.promptDesc = "Visualization"
Self.promptTitle = "Delete Visualization?"

return, 1

end


;---------------------------------------------------------------------------
; DAVEvisToolbase__Define
;
; Purpose:
;   This method defines the DAVEvisToolbase class.
;
pro DAVEvisToolbase__Define
compile_opt idl2

void = { DAVEvisToolbase,                     $
         inherits IDLitTool $   ; Provides iTool interface
         ,nameTag:'' $          ; Tag to be used for identification purposes
         ,prompt:1 $
         ,promptDesc:'' $
         ,promptTitle:'' $
       }
end
