; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DAVEopNewTool
;
; PURPOSE:
;   This file implements an operation that can launch a new tool from
;   the DAVE Main Tool. It is based on IDLitOpNewtool.
;
; CATEGORY:
;   DAVE Main Tool
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; June 2004
;-
;###############################################################################


;===============================================================================
; DAVEopNewTool::init
; 
; PURPOSE:
;   Class initialization method
;
; PARAMETERS
;
; KEYWORDS:
;
function DAVEopNewTool::Init, _REF_EXTRA=extra
compile_opt idl2

if (self->IDLitOperation::Init(_EXTRA=extra) eq 0) then $
  return, 0

return, 1

end


;===============================================================================
; DAVEopNewTool::doAction
; 
; PURPOSE:
;   Intantiate a new tool
;
; PARAMETER:
;   oTool   - The object ref of the tool from which this request originated
;
; KEYWORDS:
;
function DAVEopNewtool::DoAction, oTool
compile_opt idl2

oSystem = oTool->_GetSystem()
self->GetProperty, IDENTIFIER=id
name = STRMID(id, STRPOS(id, '/', /REVERSE_SEARCH) + 1)

if (name eq '' || STRCMP(name, 'New', 3, /FOLD_CASE)) then begin
    ;; We are creating the same tool as ourself.
    oTool->GetProperty, _TOOL_NAME=toolName, name=name
endif else begin
    ;; We are creating a different tool.
    toolName = name
endelse

;; The tool name should now be known. Get its description and use that
;; as the title for the tool. Registered tools are located under '/Registry/Tools'.
oDescPtr = oSystem->GetByIdentifier('/Registry/Tools/'+toolName)
oDescPtr->GetProperty, description=title
if (strtrim(title,2) eq '') then title=name
 
; Capitalize the first letter.
;name = STRMID(name, 0, 1) + STRLOWCASE(STRMID(name,1))

;; At this point, the next location for the tool is needed.
;; so a cascade can take place
;oNewTool = oSystem->CreateTool(toolname, NAME=name, title="IDL "+NAME)
oNewTool = oSystem->CreateTool(toolName, name=name, title=title)

return, obj_new()

end


;===============================================================================
pro DAVEopNewTool__define
compile_opt idl2

struc = {DAVEopNewTool,            $
         inherits IDLitOperation    $
        }

end
