; $Id$
;===============================================================================
; Richard Tumanjong Azuah
; NCNR, NIST
;
; Extend base class (IDLitopBrowserPrefs). Overide the DoAction method
;
;



;===============================================================================
; DAVEopHelp::doAction
; 
; PURPOSE:
;   Locate the general preferences object, update it and call the UI service.
;
; PARAMETER:
;   oTool   - The object ref of the tool from which this request originated
;
; KEYWORDS:
;
function DAVEopBrowserPrefs::DoAction, oTool

    compile_opt idl2, hidden

    oGeneral = oTool->GetByIdentifier('/REGISTRY/SETTINGS/GENERAL_SETTINGS')
    if (OBJ_VALID(oGeneral)) then oGeneral->VerifySettings

    success = oTool->DoUIService('DAVEPreferences', self)
    return, obj_new()
end


;-------------------------------------------------------------------------
pro DAVEopBrowserPrefs__define

    compile_opt idl2, hidden

    struc = {DAVEopBrowserPrefs,     $
             inherits IDLitopBrowserPrefs}
end

