; $Id$

function Gen_jqy, y, aValues=aValues, bValues=bValues, T=T, kc=kc, n0=n0, Q=Q, mass=mass
compile_opt idl2

if (n_elements(y) eq 0) then return, 0.0

; Setup default values for various parameters
if (n_elements(T) eq 0) then T = 1.0
if (n_elements(kc) eq 0) then kc=0.5
if (n_elements(Q) eq 0) then Q=25.0
if (n_elements(aValues) ne 3) then begin
  aValues = [0.897,0.46,0.38]
endif
if (n_elements(bValues) ne 3) then begin
  bValues = [0.0,0.0,0.0] ; [2.43,2558.0,215.0]
endif

muPtr = ptr_new({a2:aValues[0],     $         ; [(1/A)**2]
                 b3:bValues[0]/Q,   $         ; [(1/A)**3]
                 a4:aValues[1],     $         ; [(1/A)**4]
                 b4:0.0,            $         ; [(1/A)**4]
                 b5:bValues[1]/Q^3, $         ; [(1/A)**5]
                 a6:aValues[2],     $         ; [(1/A)**6]
                 b6:bValues[2]/Q^2})          ; [(1/A)**6]
if (n_elements(n0) eq 0) then n0=0.07
if (n_elements(B) eq 0 || n_elements(D) eq 0 || n_elements(F) eq 0) then begin
  if (~isa(mass)) then mass = 4.0026           ; rel a. mass of He4
  hbar = 1.0545919        ; *10**(-34) Js
  ec   = 1.6021917        ; *10**(-19) C
  amu  = 1.660531         ; *10**(-27) Kg
  kB   = 1.380622         ; *10**(-23) J/K
  rho  = 0.6022169/27.0   ; 1/A**3         He4 at SVP
  Vs   = 240              ; m/s            He4 at SVP
  B = mass*amu*Vs/(2.0*hbar*(2.0*!pi)^3*rho)/1000.0  ; A**2
  D = hbar*Vs/(2.0*kb*T)/10.0                    ; A
  F = 2.0*kc^2                                     ; (1/A)**2
endif

; Evaluate F(s) at several s, and use is as a table for cubic spline interpolation
; in subsequent evaluations of F(s) during the Fourier Transform of Jia(s)
s = [findgen(21)*0.25, findgen(10)*0.5+5.5, findgen(10)+11, findgen(12)*2.5+21, $
     findgen(10)*5+50, findgen(30)*10+100];, findgen(10)*20+600, findgen(6)*50+800];, $
     ;findgen(3)*500+1200, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0]
fs = fofs(s, nOrder = 1, kc=kc, T=T, B=B, D=D, F=F)
splinePtr = ptr_new({x:s,y:fs,y2:spl_init(s,fs,/double)})

SQ = 1.0

;I0 = Fofs(0.0, nOrder = 1, kc=kc, T=T, B=B, D=D, F=F)  ; 1st moment of fofs i.e. when nOrder=1
I0 = Fofs(0.0,/splineFlag,splinePtr=splinePtr)
A = 1.0 - n0*(1 + I0)

etc = create_struct('y',y[0],'muPtr',muPtr,'n0',n0,'A',A,'kc',kc,'T',T,'B',B,'D',D,'F',F, $
                    'splineFlag',1,'splinePtr',splinePtr)
n = n_elements(y)
amp = SQ/!pi
if (n eq 1) then begin
  jiay = amp * qpint1d('Jqys',0.0D,!values.d_infinity,functargs=etc,status=status,nfev=nfev)
endif else begin
  jiay = dblarr(n)
  for i=0,n-1 do begin
    etc.y = y[i]
    jiay[i] = amp * qpint1d('Jqys',0.0D,!values.d_infinity,functargs=etc,status=status,nfev=nfev)
  endfor
endelse

;if ((*muPtr).b6 eq 0.0) then begin
;  ;; In this case, evaluating the FT above is problematic because R(Q,s) does not converge
;  ;; hence the n0*R(Q,s) component of J(Q,s) is left out. This now taken into account by 
;  ;; adding n0 to the final FT at the peak location of jiay
;  void = jiay.max(index)
;  jiay[index] = jiay[index] + n0
;endif

return, jiay
  
end


;##############################################################################
pro Test_gen_jqy, y=y, aValues=aValues, bValues=bValues, T=T, kc=kc, n0=n0, Q=Q, $
                  calc=calc, plot=plot, ofile=outfile
compile_opt idl2

if (n_elements(T) eq 0) then T = 1.0
if (n_elements(kc) eq 0) then kc=0.5
if (n_elements(n0) eq 0) then n0=0.07
if (n_elements(Q) eq 0) then Q=25.0
if (n_elements(aValues) ne 3) then begin
  aValues = [0.897,0.46,0.38]
endif
if (n_elements(bValues) ne 3) then begin
  bValues = [0.0,0.0,0.0] ; [2.43,2558.0,215.0]
endif
if (n_elements(y) eq 0) then y = indgen(101)*0.1 - 5.0

calc = Gen_jqy(y, aValues=aValues, bValues=bValues, T=T, kc=kc, n0=n0, Q=Q)
str = 'n$_0$ = '+string(n0,format='(F4.2)')
str += ', $\alpha_2$ = '+string(aValues[0],format='(F5.3)')
  str += ', $\alpha_4$ = '+string(aValues[1],format='(F5.3)')
  str += ', $\alpha_6$ = '+string(aValues[2],format='(F5.3)')
str1 = 'Q = '+string(Q,format='(F4.1)') 
  str1 += ', $\beta_3$ = '+string(bValues[0]/Q,format='(F5.3)')
  str1 += ', $\beta_5$ = '+string(bValues[1]/Q^3,format='(F5.3)')
  str1 += ', $\beta_6$ = '+string(bValues[2]/Q^2,format='(F5.3)')
  
if keyword_set(plot) then begin
  p = plot(y, calc, title=['Liquid $^4$He, Longitudinal Momentum Distribution',str,str1])
  ;  prompt='Press enter to exit: '
  ;  answer=''
  ;  read,answer,prompt=prompt
  ;  p.Close
endif

;
if (n_elements(outFile) gt 0) then begin
  openw, lun, outfile, /get_lun
  for i=0,n_elements(y)-1 do printf, lun, y[i], calc[i], 0.05*calc[i], format='(3(G11.4,1X))'
  fHandle = fstat(lun)
  print,'Output stored in: ',fHandle.name
  close, lun, /force
endif


    
end