; $Id$
;###############################################################################
;
; NAME:
;  RMDPAPLOTPARMWIDGET
;
; PURPOSE:
;  Interface for plotting parameters as a function of group.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro RMDPAPlotParms,event
widget_control, event.top, get_uvalue = pState, /no_copy
data = *(*pState).dataPtr
datSize = size(data)
nchan = datSize[2]
x = fltarr(nchan) & y = fltarr(nchan) & yerr = fltarr(nchan)
x = data[0,*] & y = data[1,*] & yerr = data[2,*]
deltax = x[1]-x[0]
xlo = min(x)-deltax & xhi = max(x)+deltax
delta = max(y)-min(y)

if (*pState).autoscale eq 1 then begin
  if max(y) gt 0.0 then begin
    ylo = min(y)-0.2*delta & yhi = 1.2*max(y)
    if ylo gt 0.0 then ylo = 0.0
  endif else begin
    ylo = 1.2*min(y) & yhi = 0.0
  endelse
endif else begin
  xlo = (*pState).xlo & xhi = (*pState).xhi
  ylo = (*pState).ylo & yhi = (*pState).yhi
endelse

wset,(*pState).winPixId
thiscolor = (*pState).colors.yellow & errcolors1 = {thiscolor:thiscolor}
plot,x,y,psym = hfbs_selsym(0),color = thiscolor,xrange=[xlo,xhi],$
     xstyle=1,yrange = [ylo,yhi],ystyle = 1,xtitle = (*pState).xlabel,$
     ytitle = (*pState).ylabel
hfbs_cerrplot,x,y-yerr,y+yerr,errcolors = errcolors1,width = 0

wset,(*pState).winVis
device,copy = [0,0,(*pState).winxsize,(*pState).winysize,0,0,(*pState).winPixId]

widget_control, event.top, set_uvalue = pState, /no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro RMDPAPlotParmsWriteFile,event
widget_control, event.top, get_uvalue = pState, /no_copy
data = *(*pState).dataPtr
datSize = size(data)
nchan = datSize[2]
x = fltarr(nchan) & y = fltarr(nchan) & yerr = fltarr(nchan)
x = data[0,*] & y = data[1,*] & yerr = data[2,*]

filename = DIALOG_PICKFILE(FILTER = '*.txt',/write,title = 'Enter file name')
filename = filename+'.txt'
openw,lun,filename,/get_lun
thisFormat = '(3f15.5)'

for i = 0,nchan-1 do begin
  printf,lun,x[i],y[i],yerr[i],format = thisFormat
endfor
free_lun,lun

widget_control, event.top, set_uvalue = pState, /no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro RMDPAPlotParmsToPrinter,event
widget_control, event.top, get_uvalue = pState, /no_copy

thisDevice = !d.name
deviceKeywords = ps_form(Cancel = canceled,parent = event.top)
if canceled ne 1 then begin
  SET_PLOT, 'PS'
  DEVICE, _Extra = deviceKeywords
  data = *(*pState).dataPtr
  datSize = size(data)
  nchan = datSize[2]
  x = fltarr(nchan) & y = fltarr(nchan) & yerr = fltarr(nchan)
  x = data[0,*] & y = data[1,*] & yerr = data[2,*]
  deltax = x[1]-x[0]
  xlo = min(x)-deltax & xhi = max(x)+deltax
  delta = max(y)-min(y)

  if (*pState).autoscale eq 1 then begin
    ylo = min(y)-0.2*delta & yhi = 1.2*max(y)
    if ylo gt 0.0 then ylo = 0.0
  endif else begin
    xlo = (*pState).xlo & xhi = (*pState).xhi
    ylo = (*pState).ylo & yhi = (*pState).yhi
  endelse

  thiscolor = (*pState).colors.black & errcolors1 = {thiscolor:thiscolor}
  plot,x,y,psym = hfbs_selsym(0),color = thiscolor,xrange=[xlo,xhi],$
       xstyle=1,yrange = [ylo,yhi],ystyle = 1,xtitle = (*pState).xlabel,$
       ytitle = (*pState).ylabel
  hfbs_cerrplot,x,y-yerr,y+yerr,errcolors = errcolors1,width = 0

  DEVICE, /CLOSE_FILE
  set_plot,thisDevice
endif

widget_control, event.top, set_uvalue = pState, /no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro RMDPAPlotParmWidgetWinDraw,event
widget_control, event.top, get_uvalue = pState, /no_copy

case event.type of
0: begin  ; button press
	(*pState).mouse = event.press
	if (*pState).mouse eq 4 then begin
	  (*pState).autoscale = 1
	  widget_control,event.top,set_uvalue = pState,/no_copy
	   RMDPAPlotParms,event
	  widget_control,event.top,get_uvalue = pState,/no_copy
   	  (*pState).mouse = 0
   	  widget_control,event.top,set_uvalue = pState,/no_copy
	  return
	endif
	(*pState).xp1 = event.x
	(*pState).yp1 = event.y
	wset, (*pState).winVis
	device, copy = [0,0,(*pState).winxsize,(*pState).winysize,0,0,(*pState).winPixId]
   end
1: begin	; button release
	if ((*pState).mouse eq 1) then begin
		x = (*pState).xp1 < (*pState).xp2
		y = (*pState).yp1 < (*pState).yp2
		w = abs((*pState).xp1 - (*pState).xp2)
		h = abs((*pState).yp1 - (*pState).yp2)
		x2 = x+w
		y2 = y+h
		lc = convert_coord(x, y, /device, /to_data)
		uc = convert_coord(x2, y2, /device, /to_data)
		wset,(*pState).winVis
		(*pState).xlo = lc[0] & (*pState).xhi = uc[0]
		(*pState).ylo = lc[1] & (*pState).yhi = uc[1]
		(*pState).autoscale = 0
		widget_control,event.top,set_uvalue = pState,/no_copy
		RMDPAPlotParms,event
		widget_control,event.top,get_uvalue = pState,/no_copy
	endif
	(*pState).mouse = 0
   end
2: begin	; mouse motion
    if ((*pState).mouse eq 1) then begin
    	(*pState).xp2 = event.x
    	(*pState).yp2 = event.y
    	xc = [(*pState).xp1, event.x, event.x, (*pState).xp1, (*pState).xp1]
    	yc = [(*pState).yp1, (*pState).yp1, event.y, event.y, (*pState).yp1]
    	wset, (*pState).winVis
    	device, copy = [0,0,(*pState).winxsize,(*pState).winysize,0,0,(*pState).winPixId]
    	plots, xc, yc, /device,color = (*pState).colors.white
    endif
   end
else:
endcase

widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro doneRMDPAPlotParmWidget,event
widget_control,event.top,get_uvalue = pState,/no_copy
wdelete,(*pState).winPixId
;if ptr_valid((*pState).dataPtr) then begin
;  ptr_free,(*pState).dataPtr
;endif
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function RMDPAPlotParmWidget,group_leader = group_leader,plotParmDataPtr,$
                             XLABEL = xlabel,$
                             YLABEL = ylabel,$
                             PLATFORM = platform

tlb = widget_base(group_leader = group_leader,/modal,/col,$
                    title = 'Fit Parameter Group Dependence',$
                    /base_align_bottom,/base_align_center)

if n_elements(xlabel) eq 0 then xlabel = ''
if n_elements(ylabel) eq 0 then ylabel = ''

data = *plotParmDataPtr
datSize = size(data)
nchan = datSize[2]
x = fltarr(nchan) & y = fltarr(nchan) & yerr = fltarr(nchan)
x = data[0,*] & y = data[1,*] & yerr = data[2,*]

dataPtr = ptr_new(data,/no_copy)
deltax = abs(abs(x[1])-abs(x[0]))
xlo = min(x)-deltax & xhi = max(x)+deltax
delta = max(y)-min(y)
  if max(y) gt 0.0 then begin
    ylo = min(y)-0.2*delta & yhi = 1.2*max(y)
    if ylo gt 0.0 then ylo = 0.0
  endif else begin
    ylo = min(y)-0.2*delta & yhi = 0.2*delta+max(y)
    if yhi lt 0.0 then yhi = 0.0
  endelse
winxsize = 400 & winysize = 300
win1 = widget_draw(tlb,xsize = winxsize,ysize = winysize,/motion_events,$
         /button_events,event_pro = 'RMDPAPlotParmWidgetWinDraw')
buttonBase = widget_base(tlb,/row,/base_align_center)

void = widget_button(buttonBase,value = 'Print',$
                     event_pro = 'RMDPAPlotParmsToPrinter')
void = widget_button(buttonBase,value = 'Save parms',$
                     event_pro = 'RMDPAPlotParmsWriteFile')
void = widget_button(buttonBase,value = 'Dismiss',$
                     event_pro = 'doneRMDPAPlotParmWidget')
widget_control,tlb,/realize
centertlb,tlb
widget_control,win1,get_value = winVis

window,/free,/pixmap,xsize = winxsize,ysize = winysize
winPixId = !d.window

colors = hfbs_getcolor(/Load, Start=1)
wset,winPixId
thiscolor = colors.yellow & errcolors1 = {thiscolor:thiscolor}
plot,x,y,psym = hfbs_selsym(0),color = thiscolor,xrange=[xlo,xhi],$
     xstyle=1,yrange = [ylo,yhi],ystyle = 1,xtitle = xlabel,$
     ytitle = ylabel
hfbs_cerrplot,x,y-yerr,y+yerr,errcolors = errcolors1,width = 0

wset,winVis
device,copy = [0,0,winxsize,winysize,0,0,winPixId]

state = {winxsize:winxsize,$
         winysize:winysize,$
         dataPtr:dataPtr,$
         winVis:winVis,$
         winPixId:winPixId,$
         xlabel:xlabel,$
         colors:colors,$
         xlo:xlo,$
         ylo:ylo,$
         xhi:xhi,$
         yhi:yhi,$
         xp1:0.0,$
         xp2:0.0,$
         yp1:0.0,$
         yp2:0.0,$
         mouse:0,$
         autoscale:1,$
         platform:platform,$
         ylabel:ylabel}
pState = ptr_new(state)
widget_control,tlb,set_uvalue = pState
xmanager,'RMDPAPlotParmWidget',tlb
return,0
end