; $Id$
;###############################################################################
;
; NAME:
;  PAN_READKTABLE
;
; PURPOSE:
;  Reads in a set of tabulated data of the kohlrausch stretched
;  exponential function (actually the Fourier transform of it)
;  where the three dimensional grid is energy, beta, and tau.
;
;  The table, called kohlrauschtable.txt is generated with
;  createKTableFile.pro and John Nolan's program STABLE.EXE.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro pan_readKTable,kPtr
file = !DAVE_AUXILIARY+DIR+'kohlrauschtable.txt'
;if file_which('kohlrauschtable.txt') eq '' then begin
;  file = 'kohlrauschtable.txt'
;endif else begin
;  file = file_which('kohlrauschtable.txt')
;endelse
openr, lun, file, /get_lun
   readf,lun,npts,nb,nt
   yout = dblarr(npts+1,nb+1,nt+1)
   readf, lun, yout
free_lun, lun
kPtr = ptr_new(yout)

return
end
;;;;;;;;;;;;;;;;;;