; $Id$

;This is a routine to read "neat" files from, I believe, ILL, but I am not 
;sure.  This was  a one-off item for Vicky.

pro neatReader,fn,daveptr

if n_elements(fn) eq 0 then fn = dialog_pickfile(filter='*.grp')
;fn = 'C:\Users\kneller\Downloads\29291neat135.grp'
nlines = file_lines(fn)
openr,lun,fn,/get_lun
line=''

count = 0
groupcount = 0

;READ TOP HEADER
readf,lun,line & count++
print,line
segs = strsplit(line,'.',/extract)
npts = fix(segs[0])
print,'npts=',npts
segs = strsplit(segs[2],'0',/extract)
ngrps = fix(segs[0])
print,'ngrps = ',ngrps

angle = fltarr(ngrps)
E = fltarr(npts*ngrps)
dat = fltarr(npts*ngrps,ngrps)
err = fltarr(npts*ngrps,ngrps);+0.01
mask = intarr(npts*ngrps,ngrps);+1

;    ;READ THE FIRST GROUP HEADER
;    readf,lun,line & count++
;    segs = strsplit(line,/extract)
;    dsegs = double(segs)
;    print,dsegs

while count lt nlines-1 do begin

    ;READ THE FIRST GROUP HEADER
    readf,lun,line & count++
    segs = strsplit(line,/extract)
    dsegs = double(segs)
    ;print,dsegs


    angle[groupcount] = dsegs[0]

    firstline = count
    
    
    ;NOW READ THE GROUP
    for ii = 0,npts-1 do begin
      x1 = dsegs[0]
      readf,lun,line & count++
      segs = strsplit(line,/extract)
      dsegs = double(segs)
      E[ii+groupcount*npts] = dsegs[0]
      dat[ii+groupcount*npts,groupcount] = dsegs[1]
      err[ii+groupcount*npts,groupcount] = dsegs[2]
      mask[ii+groupcount*npts,groupcount] = 1
      ;print,dsegs
    endfor;ii
    lastline = count-1
    if count lt nlines-1 then begin 
      print,'group#=',groupcount
      ;print,line
      print,dsegs
      ;print,'lastline-firstline=',lastline-firstline
    endif
    print,count,nlines
    groupcount++

endwhile


free_lun,lun
print,fn
s = sort(E)
E = E[s]
for i=0,ngrps-1 do begin
  dat[*,i] = dat[s,i]
  err[*,i] = err[s,i]
  mask[*,i] = mask[s,i]
endfor;i

pan_mask = ptr_new(bits2bytes(mask))
specificstr = {pan_mask:pan_mask}

duh = create_dave_pointer(daveptr,$
              instrument = 'NEAT',  $
              qty = dat,          $
              err=err,$
              qtlabel = qtlabel,      $
              xvals = E,        $
              xunits = '',      $
              xlabel = 'Energy',      $
              yvals = angle,        $
              yunits = 'degrees',      $
              ylabel = 'Angle',$
              specificstr = specificstr,  $
              ermsg = errmsg)


save,daveptr,filename=fn+'.dave'
ptr_free,daveptr

end;neatReader


