; $Id$
;###############################################################################
;
; NAME:
;  PAN_ROUSEAPPROX
;
; PURPOSE:
;  Delta function for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_rouseapprox,x,parms,$
                     parmnames = parmnames, twoDimFlag=twoDimFlag, initParms=initParms, $
                     resPtr = resPtr,$
                     rlimit = rlimit, $
                     canDraw = canDraw, $
                     drawMessage = drawMessage, $
                     _Extra = extra

canDraw = 0
if n_elements(extra) eq 0 then extra = {dummy:0L}
if n_params() eq 0 then begin
  parmnames = ['l2sqrtW']
  twodimflag = 0
  initParms = [1.0]
  return, -1
endif

l2sqrtW = parms[0]
omegaR =          [0.0010000000,  0.0010230000,  0.0010470001,  0.0010720000,  0.0010960000,  0.0011220000,  0.0011480000,  0.0011750000,  0.0012020000,  0.0012300001]
omegaR = [omegaR,  0.0012590000,  0.0012880000,  0.0013180000,  0.0013490000,  0.0013800000,  0.0014130000,  0.0014449999,  0.0014790000,  0.0015140000,  0.0015490000]
omegaR = [omegaR,  0.0015850000,  0.0016220000,  0.0016600000,  0.0016980000,  0.0017380000,  0.0017780000,  0.0018200000,  0.0018620000,  0.0019050000,  0.0019499999]
omegaR = [omegaR,  0.0019950001,  0.0020419999,  0.0020890001,  0.0021380000,  0.0021879999,  0.0022390001,  0.0022910000,  0.0023439999,  0.0023990001,  0.0024550001]
omegaR = [omegaR,  0.0025120000,  0.0025700000,  0.0026300000,  0.0026920000,  0.0027540000,  0.0028180000,  0.0028840001,  0.0029509999,  0.0030199999,  0.0030900000]
omegaR = [omegaR,  0.0031620001,  0.0032360000,  0.0033110001,  0.0033880000,  0.0034670001,  0.0035480000,  0.0036309999,  0.0037150001,  0.0038020001,  0.0038900001]
omegaR = [omegaR,  0.0039809998,  0.0040739998,  0.0041689998,  0.0042659999,  0.0043649999,  0.0044669998,  0.0045710001,  0.0046770000,  0.0047860001,  0.0048980000]
omegaR = [omegaR,  0.0050120000,  0.0051290002,  0.0052479999,  0.0053699999,  0.0054950002,  0.0056230002,  0.0057540000,  0.0058880001,  0.0060259998,  0.0061659999]
omegaR = [omegaR,  0.0063100001,  0.0064570000,  0.0066069998,  0.0067610000,  0.0069180001,  0.0070790001,  0.0072440002,  0.0074129999,  0.0075860000,  0.0077620000]
omegaR = [omegaR,  0.0079429997,  0.0081280004,  0.0083179995,  0.0085110003,  0.0087099997,  0.0089130001,  0.0091199996,  0.0093329996,  0.0095499996,  0.0097719999]
omegaR = [omegaR,  0.0099999998,  0.0102329999,  0.0104710003,  0.0107150003,  0.0109649999,  0.0112199998,  0.0114820004,  0.0117490003,  0.0120230000,  0.0123030003]
omegaR = [omegaR,  0.0125890002,  0.0128830001,  0.0131829996,  0.0134899998,  0.0138039999,  0.0141249998,  0.0144539997,  0.0147909997,  0.0151359998,  0.0154879997]
omegaR = [omegaR,  0.0158489998,  0.0162179992,  0.0165960006,  0.0169820003,  0.0173780005,  0.0177829992,  0.0181970000,  0.0186209995,  0.0190549996,  0.0194979999]
omegaR = [omegaR,  0.0199529994,  0.0204169992,  0.0208930001,  0.0213799998,  0.0218780003,  0.0223869998,  0.0229090005,  0.0234420002,  0.0239879992,  0.0245469995]
omegaR = [omegaR,  0.0251189992,  0.0257040001,  0.0263030007,  0.0269150008,  0.0275420006,  0.0281840004,  0.0288399998,  0.0295119993,  0.0302000009,  0.0309030004]
omegaR = [omegaR,  0.0316229984,  0.0323590003,  0.0331129991,  0.0338840000,  0.0346740000,  0.0354809985,  0.0363080017,  0.0371540003,  0.0380190015,  0.0389049985]
omegaR = [omegaR,  0.0398110002,  0.0407380015,  0.0416870005,  0.0426580012,  0.0436520018,  0.0446680002,  0.0457089990,  0.0467739999,  0.0478629991,  0.0489780009]
omegaR = [omegaR,  0.0501190014,  0.0512860008,  0.0524809994,  0.0537029989,  0.0549539998,  0.0562339984,  0.0575440004,  0.0588839985,  0.0602560006,  0.0616599992]
omegaR = [omegaR,  0.0630960017,  0.0645650029,  0.0660689995,  0.0676079988,  0.0691829994,  0.0707949996,  0.0724439994,  0.0741309971,  0.0758579969,  0.0776249990]
omegaR = [omegaR,  0.0794330016,  0.0812830031,  0.0831760019,  0.0851140022,  0.0870959982,  0.0891249999,  0.0912009999,  0.0933249965,  0.0954990014,  0.0977239981]
omegaR = [omegaR,  0.1000000015,  0.1023290008,  0.1047130004,  0.1071520001,  0.1096479967,  0.1122020036,  0.1148149967,  0.1174900010,  0.1202260032,  0.1230269969]
omegaR = [omegaR,  0.1258929968,  0.1288249940,  0.1318259984,  0.1348959953,  0.1380379945,  0.1412539929,  0.1445440054,  0.1479109973,  0.1513559967,  0.1548819989]
omegaR = [omegaR,  0.1584890038,  0.1621810049,  0.1659590006,  0.1698240042,  0.1737799942,  0.1778279990,  0.1819700003,  0.1862089932,  0.1905460060,  0.1949840039]
omegaR = [omegaR,  0.1995259970,  0.2041739970,  0.2089300007,  0.2137960047,  0.2187760025,  0.2238720059,  0.2290869951,  0.2344229966,  0.2398830056,  0.2454710007]
omegaR = [omegaR,  0.2511889935,  0.2570399940,  0.2630270123,  0.2691529989,  0.2754229903,  0.2818379998,  0.2884030044,  0.2951210141,  0.3019950092,  0.3090299964]
omegaR = [omegaR,  0.3162280023,  0.3235940039,  0.3311310112,  0.3388440013,  0.3467369974,  0.3548130095,  0.3630779982,  0.3715350032,  0.3801890016,  0.3890450001]
omegaR = [omegaR,  0.3981069922,  0.4073800147,  0.4168690145,  0.4265800118,  0.4365159869,  0.4466840029,  0.4570879936,  0.4677349925,  0.4786300063,  0.4897789955]
omegaR = [omegaR,  0.5011870265,  0.5128610134,  0.5248069763,  0.5370320082,  0.5495409966,  0.5623409748,  0.5754399896,  0.5888440013,  0.6025599837,  0.6165949702]
omegaR = [omegaR,  0.6309570074,  0.6456540227,  0.6606929898,  0.6760830283,  0.6918309927,  0.7079460025,  0.7244359851,  0.7413100004,  0.7585780025,  0.7762470245]
omegaR = [omegaR,  0.7943279743,  0.8128309846,  0.8317639828,  0.8511379957,  0.8709639907,  0.8912510276,  0.9120110273,  0.9332540035,  0.9549930096,  0.9772369862]
omegaR = [omegaR,  1.0000000000,  1.0232900381,  1.0471299887,  1.0715199709,  1.0964800119,  1.1220200062,  1.1481499672,  1.1749000549,  1.2022600174,  1.2302700281]
omegaR = [omegaR,  1.2589299679,  1.2882499695,  1.3182599545,  1.3489600420,  1.3803800344,  1.4125399590,  1.4454400539,  1.4791100025,  1.5135600567,  1.5488200188]
omegaR = [omegaR,  1.5848900080,  1.6218099594,  1.6595900059,  1.6982400417,  1.7378000021,  1.7782800198,  1.8197000027,  1.8620899916,  1.9054600000,  1.9498399496]
omegaR = [omegaR,  1.9952600002,  2.0417399406,  2.0892999172,  2.1379599571,  2.1877601147,  2.2387199402,  2.2908699512,  2.3442299366,  2.3988299370,  2.4547100067]
omegaR = [omegaR,  2.5118899345,  2.5703999996,  2.6302700043,  2.6915299892,  2.7542300224,  2.8183801174,  2.8840301037,  2.9512100220,  3.0199499130,  3.0903000832]
omegaR = [omegaR,  3.1622800827,  3.2359399796,  3.3113100529,  3.3884398937,  3.4673700333,  3.5481300354,  3.6307799816,  3.7153499126,  3.8018898964,  3.8904500008]
omegaR = [omegaR,  3.9810700417,  4.0738000870,  4.1686902046,  4.2657999992,  4.3651599884,  4.4668397903,  4.5708799362,  4.6773500443,  4.7863001823,  4.8977899551]
omegaR = [omegaR,  5.0118699074,  5.1286101341,  5.2480697632,  5.3703198433,  5.4954099655,  5.6234102249,  5.7543997765,  5.8884401321,  6.0255999565,  6.1659498215]
omegaR = [omegaR,  6.3095698357,  6.4565401077,  6.6069297791,  6.7608299255,  6.9183101654,  7.0794601440,  7.2443599701,  7.4130997658,  7.5857801437,  7.7624697685]
omegaR = [omegaR,  7.9432802200,  8.1283102036,  8.3176403046,  8.5113801956,  8.7096395493,  8.9125099182,  9.1201095581,  9.3325395584,  9.5499296188,  9.7723703384]
omegaR = [omegaR, 10.0000000000, 10.2328996658, 10.4713001251, 10.7152004242, 10.9647998810, 11.2201995850, 11.4814996719, 11.7489995956, 12.0226001740, 12.3027000427]
omegaR = [omegaR, 12.5893001556, 12.8824996948, 13.1826000214, 13.4896001816, 13.8037996292, 14.1253995895, 14.4544000626, 14.7910995483, 15.1356000900, 15.4882001877]
omegaR = [omegaR, 15.8488998413, 16.2180995941, 16.5958995819, 16.9824008942, 17.3780002594, 17.7828006744, 18.1970005035, 18.6208992004, 19.0545997620, 19.4983997345]
omegaR = [omegaR, 19.9526004791, 20.4174003601, 20.8929996490, 21.3796005249, 21.8775997162, 22.3871994019, 22.9087009430, 23.4423007965, 23.9883003235, 24.5471000671]
omegaR = [omegaR, 25.1189002991, 25.7040004730, 26.3027000427, 26.9153003693, 27.5422992706, 28.1837997437, 28.8402996063, 29.5121002197, 30.1994991302, 30.9029998779]
omegaR = [omegaR, 31.6228008270, 32.3594017029, 33.1130981445, 33.8843994141, 34.6736984253, 35.4813003540, 36.3078002930, 37.1534996033, 38.0189018250, 38.9044990540]
omegaR = [omegaR, 39.8106994629, 40.7379989624, 41.6869010925, 42.6580009460, 43.6515998840, 44.6683998108, 45.7088012695, 46.7734985352, 47.8629989624, 48.9779014587]
omegaR = [omegaR, 50.1186981201, 51.2860984802, 52.4807014465, 53.7032012939, 54.9541015625, 56.2341003418, 57.5439987183, 58.8843994141, 60.2560005188, 61.6595001221]
omegaR = [omegaR, 63.0956993103, 64.5653991699, 66.0692977905, 67.6082992554, 69.1830978394, 70.7946014404, 72.4436035156, 74.1309967041, 75.8578033447, 77.6247024536]
omegaR = [omegaR, 79.4328002930, 81.2830963135, 83.1763992310, 85.1138000488, 87.0963973999, 89.1250991821, 91.2011032104, 93.3254013062, 95.4992980957, 97.7237014771]
omegaR = [omegaR,100.0000000000]

f =   [1.00000000,1.00000000,1.00000000,1.00000000,1.00000000,1.00000000,1.00000000,1.00000000,1.00000000,1.00000000,1.00000000,1.00000000]
f = [f,1.00000000,1.00000000,1.00000000,1.00000000,1.00000000,1.00000000,0.99999899,0.99999899,0.99999899,0.99999702,0.99999702,0.99999702]
f = [f,0.99999702,0.99999702,0.99999702,0.99999702,0.99999601,0.99999601,0.99999601,0.99999601,0.99999601,0.99999499,0.99999499,0.99999499]
f = [f,0.99999499,0.99999499,0.99999398,0.99999398,0.99999398,0.99999303,0.99999303,0.99999303,0.99999201,0.99999201,0.99999201,0.99999100]
f = [f,0.99999100,0.99998999,0.99998999,0.99998999,0.99998897,0.99998897,0.99998802,0.99998701,0.99998701,0.99998599,0.99998599,0.99998498]
f = [f,0.99998403,0.99998301,0.99998301,0.99998200,0.99998099,0.99997997,0.99997902,0.99997801,0.99997699,0.99997598,0.99997503,0.99997401]
f = [f,0.99997300,0.99997097,0.99997002,0.99996901,0.99996698,0.99996603,0.99996400,0.99996197,0.99996001,0.99995899,0.99995703,0.99995500]
f = [f,0.99995202,0.99994999,0.99994802,0.99994498,0.99994302,0.99993998,0.99993700,0.99993402,0.99993098,0.99992800,0.99992502,0.99992102]
f = [f,0.99991798,0.99991399,0.99991000,0.99990499,0.99990100,0.99989599,0.99989200,0.99988598,0.99988103,0.99987602,0.99987000,0.99986398]
f = [f,0.99985701,0.99985099,0.99984401,0.99983603,0.99982899,0.99982101,0.99981201,0.99980301,0.99979401,0.99978501,0.99977499,0.99976403]
f = [f,0.99975300,0.99974102,0.99972898,0.99971700,0.99970400,0.99969000,0.99967498,0.99966002,0.99964398,0.99962801,0.99961001,0.99959201]
f = [f,0.99957299,0.99955302,0.99953198,0.99951100,0.99948800,0.99946398,0.99943900,0.99941301,0.99938601,0.99935699,0.99932700,0.99929601]
f = [f,0.99926299,0.99922901,0.99919301,0.99915600,0.99911702,0.99907601,0.99903297,0.99898797,0.99894100,0.99889201,0.99884099,0.99878699]
f = [f,0.99873102,0.99867302,0.99861199,0.99854702,0.99848002,0.99840999,0.99833697,0.99826097,0.99817997,0.99809700,0.99800903,0.99791801]
f = [f,0.99782199,0.99772203,0.99761802,0.99750799,0.99739403,0.99727499,0.99715000,0.99702001,0.99688399,0.99674100,0.99659300,0.99643701]
f = [f,0.99627501,0.99610603,0.99592799,0.99574298,0.99554998,0.99534798,0.99513698,0.99491698,0.99468702,0.99444699,0.99419600,0.99393398]
f = [f,0.99366099,0.99337602,0.99307799,0.99276698,0.99244201,0.99210298,0.99175000,0.99138099,0.99099600,0.99059403,0.99017501,0.98973799]
f = [f,0.98928201,0.98880601,0.98830998,0.98779303,0.98725402,0.98669100,0.98610502,0.98549402,0.98485702,0.98419303,0.98350197,0.98278099]
f = [f,0.98202997,0.98124802,0.98043299,0.97958398,0.97869998,0.97777998,0.97682202,0.97582501,0.97478700,0.97370702,0.97258300,0.97141302]
f = [f,0.97019702,0.96893197,0.96761602,0.96624798,0.96482599,0.96334797,0.96181202,0.96021599,0.95855701,0.95683497,0.95504600,0.95318800]
f = [f,0.95125997,0.94925898,0.94718200,0.94502699,0.94279200,0.94047302,0.93807000,0.93557799,0.93299502,0.93032002,0.92754698,0.92467600]
f = [f,0.92170399,0.91862601,0.91544199,0.91214597,0.90873802,0.90521300,0.90157002,0.89780402,0.89391297,0.88989401,0.88574302,0.88145900]
f = [f,0.87703800,0.87247699,0.86777300,0.86292303,0.85792500,0.85277599,0.84747303,0.84201300,0.83639401,0.83061397,0.82466900,0.81855899]
f = [f,0.81228000,0.80583102,0.79920900,0.79241401,0.78544301,0.77829498,0.77096999,0.76346499,0.75578099,0.74791700,0.73987198,0.73164600]
f = [f,0.72324097,0.71465498,0.70589101,0.69694799,0.68782997,0.67853701,0.66907102,0.65943497,0.64963299,0.63966602,0.62953901,0.61925602]
f = [f,0.60882097,0.59823799,0.58751398,0.57665402,0.56566298,0.55454803,0.54331702,0.53197598,0.52053303,0.50899702,0.49737501,0.48567799]
f = [f,0.47391301,0.46209100,0.45022199,0.43831700,0.42638499,0.41443801,0.40248701,0.39054400,0.37862101,0.36672899,0.35488099,0.34308800]
f = [f,0.33136299,0.31971899,0.30816799,0.29672101,0.28539199,0.27419201,0.26313400,0.25222901,0.24148899,0.23092499,0.22054800,0.21036801]
f = [f,0.20039500,0.19063900,0.18110999,0.17181399,0.16276100,0.15395799,0.14541100,0.13712600,0.12910800,0.12136200,0.11389100,0.10669800]
f = [f,0.09978500,0.09315400,0.08680500,0.08073700,0.07495000,0.06944100,0.06420900,0.05924800,0.05455600,0.05012700,0.04595700,0.04203800]
f = [f,0.03836500,0.03493000,0.03172600,0.02874400,0.02597700,0.02341500,0.02105000,0.01887200,0.01687200,0.01504200,0.01337100,0.01185000]
f = [f,0.01047000,0.00922200,0.00809700,0.00708600,0.00618000,0.00537100,0.00465200,0.00401500,0.00345300,0.00295800,0.00252400,0.00214500]
f = [f,0.00181600,0.00153100,0.00128500,0.00107400,0.00089400,0.00074100,0.00061100,0.00050100,0.00040900,0.00033300,0.00026900,0.00021600]
f = [f,0.00017300,0.00013800,0.00010900,0.00008600,0.00006700,0.00005200,0.00004000,0.00003100,0.00002400,0.00001800,0.00001300,0.00001000]
f = [f,0.00000700,0.00000600,0.00000400,0.00000300,0.00000200,0.00000200,0.00000100,0.00000100,0.00000100,0.00000000,0.00000000,0.00000000]
f = [f,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000]
f = [f,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000]
f = [f,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000]
f = [f,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000]
f = [f,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000]
f = [f,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000]
f = [f,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000]

return,interpol(f,OmegaR,l2sqrtW*x)

end
