; $Id$
;###############################################################################
;
; NAME:
;  PAN_ORDERPARAMETER
;
; PURPOSE:
;  Fitting critical exponent beta 
;   I=		I0*(1-T/Tc)^beta 	for T<=Tc; 
;			0 	     		for T>Tc;
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_orderparameter,x,parms,$
                        parmnames = parmnames, $
                        canDraw = canDraw, $
                        drawMessage = drawMessage, $
                        func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, $
                        changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
                        _Extra = extra
canDraw = 1
twoDimFlag = 0

if n_params() eq 0 then begin
  parmnames = ['I0','Tc','BETA']
  return,-1
endif
drawMessage = strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag function to set I0 and Tc']
drawMessage[2:3] = ['Hold left mouse button down','and drag to change beta']

if (Keyword_set(changefirst)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is first release at the location for the function centroid
  ; translate the position into suitable parameters.
  ;Print,'###Changefirst called within function...'
  func_dataHash['ymax'] = yMouseClick
  parms[0] = yMouseClick
  parms[1] = xMouseClick
  parms[2] = 0.5
endif

if (Keyword_set(changesecond)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is move to define the function width
  ; translate the position into suitable parameters.
  ;Print,'###Changesecond called within function...'
  parms[2] = 0.95 - xMouseClick/(xrange[1] - xrange[0])*0.9    ; Anywhere between 0.25 and 0.75
endif


i0 = parms[0]
tc = parms[1]
beta = parms[2]
;print,i0,tc,beta

; this is lower limit for tc in case fit goes wrong
epsilon=0.0001

if tc le 0 then begin
  tc=epsilon
endif

; allow negative i0 but not 0 since it will give no fit
if i0 eq 0 then begin
  i0=epsilon;
endif

yout = x*0.0
index = where(x le tc, nindex, complement=index1, ncomplement=nindex1)
if (nindex gt 0) then yout[index] =  i0*(1-x[index]/tc)^beta
if (nindex1 gt 0) then yout[index1] = 0.0
;if x le tc then begin
;  yout = i0*(1-x/tc)^beta
;endif else begin 
;  yout = 0
;endelse


return,yout
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;