; $Id$
;###############################################################################
;
; NAME:
;  PAN_KOHLRAUSCH
;
; PURPOSE:
;  Kohlrausch function for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;
function pan_kohlrausch,x,parms, $
						parmnames = parmnames, $
						canDraw = canDraw, $
						drawMessage = drawMessage, $
						_Extra = extra

if n_params() eq 0 then begin
  parmnames = ['area','beta','tau']
  return,-1
endif
canDraw = 1

drawMessage = strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag to change amplitude']
drawMessage[2:3] = ['Hold left mouse button down','and drag to change width']

npts = n_elements(x)
amp = parms[0]
beta = abs(parms[1])
; The following line used to be tau = abs(parms[2]) and the next line is new (08/22/02)
tauave = abs(parms[2])
tau = beta*tauave/gamma(1.0/beta)

xtab = *extra.extra.xtabPtr
ytab = *extra.extra.ytabPtr
btab = *extra.extra.btabPtr
ttab = *extra.extra.ttabPtr

xTabLo = min(xtab)
xTabHi = max(xtab)
dxTab = xtab[1]-xtab[0]
xIndex = dblarr(npts)
xIndex = (x-xTabLo)/dxTab

bTabLo = min(btab)
bTabHi = max(btab)
dbTab = btab[1]-btab[0]
bIndex = (beta-bTabLo)/dbTab

tTabLo = min(ttab)
tTabHi = max(ttab)
dtTab = ttab[1]-ttab[0]
tIndex = (tau-tTabLo)/dtTab

hbar = 0.6528
if beta eq 1.0 then begin
  gam = 1.0*hbar/tau
  yout = (amp*gam/!dpi)/(x^2+gam^2)
endif else begin
  yout = amp*interpolate(ytab,xIndex,bIndex,tIndex,/grid)
endelse
return,yout
end