; $Id$
;###############################################################################
;
; NAME:
;  PAN_DHO
;
; PURPOSE:
;  Damped harmonic oscillator for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_dho, 		x,parms,$
                    	parmnames = parmnames, $
                    	canDraw = canDraw, $
                    	drawMessage = drawMessage, $
                    	func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, $
                    	changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
                    	_Extra = extra

canDraw = 1
twoDimFlag = 0

if n_params() eq 0 then begin
  parmnames = ['amp','center','fwhm','temperature']
  return,-1
endif

drawMessage = strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag function centroid']
drawMessage[2:3] = ['Hold left mouse button down','and drag to change width']

if (Keyword_set(changefirst)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is first release at the location for the function centroid
  ; translate the position into suitable parameters.
  ;Print,'###Changefirst called within function...'
  func_dataHash['ymax'] = yMouseClick
  fwhm = 0.05*(xrange[1]-xrange[0])
  gam = 0.5*fwhm
  parms[0] = yMouseClick*gam*!dpi
  parms[1] = xMouseClick
  parms[2] = fwhm
  parms[3] = 25.0
endif

if (Keyword_set(changesecond)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is move to define the function width
  ; translate the position into suitable parameters.
  ;Print,'###Changesecond called within function...'
  fwhm = 2.0*Abs(xMouseClick-parms[1])
  gamma = 0.5*fwhm
  parms[0] = func_dataHash['ymax']*gamma*!dpi
  parms[2] = fwhm
endif


amp = parms[0]
cen = abs(parms[1])
width = abs(parms[2])
gam = 0.5*width
temperature = parms[3]

npts = n_elements(x)
bose = dblarr(npts)
;whereValid = where(x ne 0.0,count,complement=whereNotValid,ncomplement=nNotValid)
;if count eq npts then begin
;  bose = 1./(1.-exp(-11.6*x/temperature))
;endif else begin
;  ;wherenotvalid = where(x eq 0.0,newcount)
;  bose[whereValid] = 1./(1.-exp(-11.6*x[wherevalid]/temperature))
;  bose[whereNotValid] = 0.0;1./(1.-exp(-11.6*x[wherenotvalid]/temperature))
;endelse
bose = 1./(1.-exp(-11.6*x/temperature))
index = where(~finite(bose),cnt)        ; if x == 0 ==> bose == Inf. So find any such values and set to 0.0
if (cnt gt 0) then bose[index] = 0.0
y = dblarr(npts)
y = bose*amp*(gam/!pi)*((1.0/((x-cen)^2+gam^2))-(1.0/((x+cen)^2+gam^2)))

canDraw = 1
return,y
end