; $Id$
;###############################################################################
;
; NAME:
;  PAN_DELTA
;
; PURPOSE:
;  Delta function for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_delta,x,parms,$
   parmnames = parmnames, initParms=initParms, $
   canDraw = canDraw, $
   drawMessage = drawMessage, $
   func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, $
   changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
   resPtr = resPtr, resolutionRequiredFlag=resolutionRequiredFlag, extConvolFlag=extConvolFlag, resLimit=rLimit, $
  _Extra = extra

canDraw = 1
twodimflag = 0
resolutionRequiredFlag = 1   ; ==> implies this function requires a resolution function to be defined
extConvolFlag = 0            ; does function require external convolution? 0=>No, 1=>Yes
                             ; if set to No, it implies a convolution is performed within this function when a resolution function is present
                             ; Also set to No, if you DO NOT wish anq external convolution to be performed at all

;if n_elements(extra) eq 0 then extra = {dummy:0L}
if n_params() eq 0 then begin
  parmnames = ['area','center']
  initParms = [1.0,0.0]
  return, -1
endif

drawMessage = strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag function centroid']
drawMessage[2:3] = ['Click the left mouse button to finish','']

if n_elements(resPtr) eq 0 then return,0.0

if (Keyword_set(changefirst)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is first release at the location for the function centroid
  ; translate the position into suitable parameters.
  ;Print,'###Changefirst called within function...'
  parms[0] = yMouseClick
  parms[1] = xMouseClick
endif

area = parms[0]
cen = parms[1]
pd = [area,cen]

if n_elements(resPtr) ne 0 then begin
  yout = pan_convolute(x,resPtr,pseudo_delta = [[pd]], reslimit = rlimit)
;  yout = rmd_convol(x,resPtr,pseudo_delta = [[pd]], reslimit = rlimit)
;  yout = rmd_convolution(x,resPtr,ytest,pseudo_delta = pd, reslimit = rlimit)
endif else begin
  yout = pan_gaussian(x,[area,cen,1d-1])
endelse

return,yout
end
