; $Id$
;###############################################################################
;
; NAME:
;  PAN_AUTOGAUSSIAN
;
; PURPOSE:
;  Automatic gaussian fit function
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_autogaussian,x,parms,$
                     parmnames = parmnames, $
                     canDraw = canDraw, $
                     drawMessage = drawMessage, $
                     _Extra = extra

if n_params() eq 0 then begin
  parmnames = ['area','center','FWHM','bg']
  return,-1
endif
fwhm = parms[2]
sig = fwhm/2.354
area = parms[0]
cen = parms[1]
bg = parms[3]
yout = (area/sqrt(2.0*!dpi*sig^2))*exp(-0.5*((x-cen)/sig)^2) + bg
canDraw = 0
return,yout
end