; $Id$
;###############################################################################
;
; NAME:
;  modifyParms2D
;
; PURPOSE:
;   Interface used to modify fit parameters for any 2D fit function
;   based on rafins_pinfo.pro
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, surface fitting
;
; AUTHOR:
;  Richard Tumanjong Azuah
;  NIST Center for Neutron Research
;  azuah@nist.gov; (301) 9755604
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;+
;
;-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro modifyParms2D_cleanup,tlb
  compile_opt idl2,hidden
  Widget_control,tlb,get_uvalue = pstate
  Ptr_free,pstate
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro modifyParms2D_send,Event
  compile_opt idl2,hidden
  Widget_control,Event.top,get_uvalue = pstate
  p_info =  { modifyParms2D_event,       $
    id:(*pstate).notifyIDs[0],   $
    top:(*pstate).notifyIDs[1],  $
    handler:0L,           $
    cancel:(*pstate).cancel     $
  }

  if Widget_info((*pstate).notifyIDs[0],/valid_id) then $
    Widget_control,(*pstate).notifyIDs[0],send_event = p_info
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro modifyParms2D_quit,Event
  compile_opt idl2,hidden
  Widget_control,Event.top,/destroy
  Return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro modifyParms2D_get_info,Event
  compile_opt idl2,hidden
  Widget_control,Event.top,get_uvalue = pState
  if (*pstate).n_single gt 0 then begin
    for i = 0,(*pstate).n_single-1 do begin
      Widget_control,(*pstate).single_fields[i],get_value = val
      val = Float(val[0])
      if i eq 0 then parameters = val else parameters = [parameters,val]
    endfor
    (*pstate).ofunction->GetProperty,parms = parms
    parms[0:(*pstate).n_single-1] = parameters
    (*pstate).ofunction->SetProperty,parms = parms
  endif
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro modifyParms2D_apply,Event
  compile_opt idl2,hidden
  ; The user has pressed the 'APPLY' button
  Widget_control,Event.top,get_uvalue = pState
  (*pstate).cancel = 0
  modifyParms2D_get_info,Event
  modifyParms2D_send,Event
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro modifyParms2D_dismiss,Event
  compile_opt idl2,hidden
  ; The user has pressed the 'ACCEPT' button
  Widget_control,Event.top,get_uvalue = pState
  (*pstate).cancel = 1
  modifyParms2D_send,Event
  modifyParms2D_quit,Event
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro modifyParms2D_event,Event
  Widget_control,Event.top,get_uvalue = pstate
  uname = Widget_info(Event.id,/uname)
  case uname of
    'APPLY':  $
      begin
      modifyParms2D_apply,Event
    end
    'DISMISS':  $
      begin
      modifyParms2D_dismiss,Event
    end
    'MULTI_FIELD':  $
      begin
      Catch,the_error
      if the_error ne 0 then begin
        Catch,/cancel
        Return
      endif
      ; Get the current slider value out
      Widget_control,Event.id,get_uvalue = uval
      slider_id = uval.slider_id
      set = Widget_info(uval.fix_id,/button_set)
      index = uval.index
      if Widget_info(slider_id,/uname) ne 'RAFINS_SLIDER' then Return
      Widget_control,slider_id,get_value = val & val = Fix(val[0]-1)
      (*pstate).ofunction->GetProperty,parms = parms,  $
        multi_parmnames = m_parmnames, $
        single_parmnames = s_parmnames
      n_single = (*pstate).n_single
      ny = (*pstate).ny
      init = n_single
      i_start = init+index*ny
      i_finish = init+(index+1)*ny-1
      relevant_parms = parms[i_start:i_finish]

      Widget_control,Event.id,get_value = new_value
      a = Dm_to_number(new_value[0])
      if not Finite(a) then Return else new_value = Float(new_value[0])
      relevant_parms[val] = new_value
      parms[i_start:i_finish] = relevant_parms
      (*pstate).ofunction->SetProperty,parms = parms

    end
    'RAFINS_SLIDER':  $
      begin
      Widget_control,Event.id,get_uvalue = uval
      index = uval.index
      field_id = uval.field_id
      (*pstate).ofunction->GetProperty,parms = parms,  $
        multi_parmnames = m_parmnames, $
        single_parmnames = s_parmnames, $
        low = low,            $
        lovalues = lovalues,      $
        fixed = fixed,          $
        high = high,          $
        hivalues = hivalues
      n_single = (*pstate).n_single
      ny = (*pstate).ny
      init = n_single
      i_start = init+index*ny
      i_finish = init+(index+1)*ny-1
      relevant_parms = parms[i_start:i_finish]

      Widget_control,Event.id,get_value = val & val = Fix(val[0]-1)
      this_param = relevant_parms[val]
      Widget_control,field_id,set_value = Strtrim(String(this_param),2)
      ; Update the lower limit checkbox
      relevant_low_checks = low[i_start:i_finish]
      this_lo_check = relevant_low_checks[val]
      Widget_control,uval.lo_checks,set_button = this_lo_check
      ; Update the lower limit value
      relevant_low_values = lovalues[i_start:i_finish]
      this_low_value = relevant_low_values[val]
      Widget_control,uval.low_value,set_value = this_low_value
      ; Update the upper limit checkbox
      relevant_high_checks = high[i_start:i_finish]
      this_hi_check = relevant_high_checks[val]
      Widget_control,uval.hi_checks,set_button = this_hi_check
      ; Update the upper limit value
      relevant_high_values = hivalues[i_start:i_finish]
      this_high_value = relevant_high_values[val]
      Widget_control,uval.high_value,set_value = this_high_value
      ; Update the fixed checkbox
      relevant_fix_checks = fixed[i_start:i_finish]
      this_fix_check = relevant_fix_checks[val]
      Widget_control,uval.fix_checks,set_button = this_fix_check
    end
    'LOW_CHECK':  $
      begin
      (*pstate).ofunction->GetProperty,parms = parms,  $
        multi_parmnames = m_parmnames, $
        single_parmnames = s_parmnames, $
        low = low,            $
        lovalues = lovalues,      $
        high = high,          $
        hivalues = hivalues
      Widget_control,Event.id,get_uvalue = uval
      n_single = (*pstate).n_single
      tags = Tag_names(uval)
      wh = Where(Strupcase(tags) eq 'SLIDER_ID',count)
      if count gt 0 then begin
        (*pstate).ofunction->GetProperty,low = low
        slider_id = uval.slider_id
        slider_index = uval.slider_index
        ny = (*pstate).ny
        init = n_single
        i_start = init+slider_index*ny
        i_finish = init+(slider_index+1)*ny-1
        relevant_low_checks = low[i_start:i_finish]
        Widget_control,slider_id,get_value = val & val = Fix(val[0]-1)
        relevant_low_checks[val] = Event.select
        low[i_start:i_finish] = relevant_low_checks
        (*pstate).ofunction->SetProperty,low = low
      endif else begin
        (*pstate).ofunction->GetProperty,low = low
        low[uval.index] = Event.select
        (*pstate).ofunction->SetProperty, low = low
      endelse
    end
    'LOW_VALUE':  $
      begin
      (*pstate).ofunction->GetProperty,parms = parms,  $
        multi_parmnames = m_parmnames, $
        single_parmnames = s_parmnames, $
        low = low,            $
        lovalues = lovalues,      $
        high = high,          $
        hivalues = hivalues
      Widget_control,Event.id,get_value = new_value
      a = Dm_to_number(new_value[0])
      if not Finite(a) then Return else new_value = Float(new_value[0])

      Widget_control,Event.id,get_uvalue = uval
      n_single = (*pstate).n_single
      tags = Tag_names(uval)
      wh = Where(Strupcase(tags) eq 'SLIDER_ID',count)
      if count gt 0 then begin
        (*pstate).ofunction->GetProperty,lovalues = lovalues
        slider_id = uval.slider_id
        slider_index = uval.slider_index
        ny = (*pstate).ny
        init = n_single
        i_start = init+slider_index*ny
        i_finish = init+(slider_index+1)*ny-1
        relevant_low_values = lovalues[i_start:i_finish]
        Widget_control,slider_id,get_value = val & val = Fix(val[0]-1)
        relevant_low_values[val] = new_value
        lovalues[i_start:i_finish] = relevant_low_values
        (*pstate).ofunction->SetProperty,lovalues = lovalues
      endif else begin
        (*pstate).ofunction->GetProperty,lovalues = lovalues
        lovalues[uval.index] = new_value
        (*pstate).ofunction->SetProperty,lovalues = lovalues
      endelse

    end
    'HIGH_CHECK': $
      begin
      (*pstate).ofunction->GetProperty,parms = parms,  $
        multi_parmnames = m_parmnames, $
        single_parmnames = s_parmnames, $
        low = low,            $
        lovalues = lovalues,      $
        high = high,          $
        hivalues = hivalues
      Widget_control,Event.id,get_uvalue = uval
      n_single = (*pstate).n_single
      tags = Tag_names(uval)
      wh = Where(Strupcase(tags) eq 'SLIDER_ID',count)
      if count gt 0 then begin
        (*pstate).ofunction->GetProperty,high = high
        slider_id = uval.slider_id
        slider_index = uval.slider_index
        ny = (*pstate).ny
        init = n_single
        i_start = init+slider_index*ny
        i_finish = init+(slider_index+1)*ny-1
        relevant_high_checks = high[i_start:i_finish]
        Widget_control,slider_id,get_value = val & val = Fix(val[0]-1)
        relevant_high_checks[val] = Event.select
        high[i_start:i_finish] = relevant_high_checks
        (*pstate).ofunction->SetProperty,high = high
      endif else begin
        (*pstate).ofunction->GetProperty,high = high
        high[uval.index] = Event.select
        (*pstate).ofunction->SetProperty,high = high
      endelse
    end
    'HIGH_VALUE': $
      begin
      (*pstate).ofunction->GetProperty,parms = parms,  $
        multi_parmnames = m_parmnames, $
        single_parmnames = s_parmnames, $
        low = low,            $
        lovalues = lovalues,      $
        high = high,          $
        hivalues = hivalues
      Widget_control,Event.id,get_value = new_value
      a = Dm_to_number(new_value[0])
      if not Finite(a) then Return else new_value = Float(new_value[0])

      Widget_control,Event.id,get_uvalue = uval
      n_single = (*pstate).n_single
      tags = Tag_names(uval)
      wh = Where(Strupcase(tags) eq 'SLIDER_ID',count)
      if count gt 0 then begin
        (*pstate).ofunction->GetProperty,hivalues = hivalues
        slider_id = uval.slider_id
        slider_index = uval.slider_index
        ny = (*pstate).ny
        init = n_single
        i_start = init+slider_index*ny
        i_finish = init+(slider_index+1)*ny-1
        relevant_high_values = hivalues[i_start:i_finish]
        Widget_control,slider_id,get_value = val & val = Fix(val[0]-1)
        relevant_high_values[val] = new_value
        hivalues[i_start:i_finish] = relevant_high_values
        (*pstate).ofunction->SetProperty,hivalues = hivalues
      endif else begin
        (*pstate).ofunction->GetProperty,hivalues = hivalues
        hivalues[uval.index] = new_value
        (*pstate).ofunction->SetProperty,hivalues = hivalues
      endelse
    end
    'FIX_CHECK':  $
      begin
      (*pstate).ofunction->GetProperty,parms = parms,  $
        multi_parmnames = m_parmnames, $
        single_parmnames = s_parmnames, $
        low = low,            $
        lovalues = lovalues,      $
        high = high,          $
        fixed = fixed,          $
        hivalues = hivalues
      Widget_control,Event.id,get_uvalue = uval
      n_single = (*pstate).n_single
      tags = Tag_names(uval)
      wh = Where(Strupcase(tags) eq 'SLIDER_ID',count)
      if count gt 0 then begin
        (*pstate).ofunction->GetProperty,high = high
        slider_id = uval.slider_id
        slider_index = uval.slider_index
        ny = (*pstate).ny
        init = n_single
        i_start = init+slider_index*ny
        i_finish = init+(slider_index+1)*ny-1
        relevant_fix_checks = fixed[i_start:i_finish]
        Widget_control,slider_id,get_value = val & val = Fix(val[0]-1)
        relevant_fix_checks[val] = Event.select
        fixed[i_start:i_finish] = relevant_fix_checks
        (*pstate).ofunction->SetProperty,fixed = fixed
      endif else begin
        (*pstate).ofunction->GetProperty,fixed = fixed
        fixed[uval.index] = Event.select
        (*pstate).ofunction->SetProperty,fixed = fixed
      endelse
    end
    'FIX_ALL':  $
      begin
      ; Get the current slider position
      Widget_control,Event.id,get_uvalue = uval
      Widget_control,uval.slider_id,get_value = val & val = Fix(val[0]-1)
      (*pstate).ofunction->GetProperty,parms = parms,  $
        multi_parmnames = m_parmnames, $
        single_parmnames = s_parmnames, $
        low = low,            $
        lovalues = lovalues,      $
        high = high,          $
        fixed = fixed,          $
        hivalues = hivalues

      n_single = (*pstate).n_single
      slider_id = uval.slider_id
      slider_index = uval.slider_index
      ny = (*pstate).ny
      init = n_single
      i_start = init+slider_index*ny
      i_finish = init+(slider_index+1)*ny-1
      relevant_parms = parms[i_start:i_finish]
      relevant_checks = fixed[i_start:i_finish]
      if Event.select eq 1 then begin
        parms[i_start:i_finish] = relevant_parms[val]
        fixed[i_start:i_finish] = 1
        (*pstate).ofunction->SetProperty,parms = parms,fixed = fixed
      endif
      if Event.select eq 0 then begin
        parms[i_start:i_finish] = relevant_parms[val]
        fixed[i_start:i_finish] = 0
        (*pstate).ofunction->SetProperty,parms = parms,fixed = fixed
      endif
      ; Update the current fixed check box
      Widget_control,uval.fix_checks,set_button = Event.select
    end
    else:
  endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro modifyParms2D, ofunction,                $
  group_leader = group_leader,      $
  notifyids = notifyIDs
  compile_opt idl2,hidden
  if (n_params() eq 0) then Return
  if (n_elements(notifyIDs) eq 0) then notifyIDs = [0L,0L]
  ; Now pull out all of the information from the function object
  ofunction->GetProperty,parmnames = parmnames,        $
    single_parmnames = s_parmnames,   $
    multi_parmnames = m_parmnames,    $
    qvals = qvals,          $
    low = low,              $
    lovalues = lovalues,        $
    high = high,            $
    hivalues = hivalues,        $
    fixed = fixed,            $
    parms = parms
  if s_parmnames[0] ne '' then n_single = N_elements(s_parmnames) else n_single = 0
  if m_parmnames[0] ne '' then n_multi = N_elements(parms) - n_single else n_multi = 0
  ny = N_elements(qvals)
  tlb = Widget_base(group_leader = group_leader,/tlb_frame_attr,/col, $
    title = 'Parameter Modification Entry')
  nrows = n_single+n_multi
  single_fields = 0L
  multi_fields = 0L
  count_widgets = 0L
  field_size = 10
  if m_parmnames[0] eq '' then n_this_multi = 0 else n_this_multi = N_elements(m_parmnames)
  lo_checks = Lonarr(n_single+n_this_multi)
  hi_checks = Lonarr(n_single+n_this_multi)
  fix_checks = Lonarr(n_single+n_this_multi)
  lo_value = Lonarr(n_single+n_this_multi)
  hi_value = Lonarr(n_single+n_this_multi)
  if n_single gt 0 then begin
    single_fields = Lonarr(n_single)
    single_row_base = Lonarr(n_single)
    for i = 0,n_single-1 do begin
      single_row_base[i] = Widget_base(tlb,/row,/align_right)
      this_title = Strtrim(s_parmnames[i],2)
      single_fields[i] = Cw_field(single_row_base[i], $
        value = parms[i],title = this_title,xsize = field_size)
      fix_base = Widget_base(single_row_base[i],/row,/nonexclusive)
      fix_checks[count_widgets] = Widget_button(fix_base,value = 'Fixed', $
        uname = 'FIX_CHECK',uvalue = {index:count_widgets})
      lo_base = Widget_base(single_row_base[i],/row,/frame)
      lo_value[count_widgets] = Cw_field(lo_base,title = 'Low', $
        uname = 'LOW_VALUE',value = Strtrim(String(lovalues[i]),2), $
        uvalue = {index:count_widgets},/all_events,xsize = field_size)
      non_ex_base_a = Widget_base(lo_base,/row,/nonexclusive)
      lo_checks[count_widgets] = Widget_button(non_ex_base_a,value = 'Set lower bound', $
        uname = 'LOW_CHECK',uvalue = {index:count_widgets})
      hi_base = Widget_base(single_row_base[i],/row,/frame)
      hi_value[count_widgets] = Cw_field(hi_base,title = 'High', $
        uname = 'HIGH_VALUE',value = Strtrim(String(hivalues[i]),2), $
        uvalue = {index:count_widgets},/all_events,xsize = field_size)
      non_ex_base_b = Widget_base(hi_base,/row,/nonexclusive)
      hi_checks[count_widgets] = Widget_button(non_ex_base_b,value = 'Set upper bound', $
        uname = 'HIGH_CHECK',uvalue = {index:count_widgets})
      Widget_control,hi_checks[count_widgets],set_button = high[count_widgets]
      Widget_control,fix_checks[count_widgets],set_button = fixed[count_widgets]
      Widget_control,lo_checks[count_widgets],set_button = low[count_widgets]
      count_widgets = count_widgets + 1L
    endfor
  endif
  if n_multi gt 0 then begin
    n_multi_diff_parms = N_elements(m_parmnames)
    multi_fields = Lonarr(n_multi_diff_parms)
    multi_row_base = Lonarr(n_multi_diff_parms)
    slider_id = Lonarr(n_multi_diff_parms)
    fix_id = Lonarr(n_multi_diff_parms)
    for i = 0,n_multi_diff_parms-1 do begin
      multi_row_base[i] = Widget_base(tlb,/row,/align_right)
      fix_ex_base = Widget_base(multi_row_base[i],/row,/nonexclusive)
      fix_id[i] = Widget_button(fix_ex_base,value = 'Fix all values', $
        uname = 'FIX_ALL',uvalue =    { index:count_widgets,  $
        slider_id:0L, $
        slider_index:i, $
        fix_checks:0L})
      this_title = Strtrim(m_parmnames[i],2)
      this_title = 'Group'
      slider_id[i] = Widget_slider(multi_row_base[i],value = 1,min = 1,max = ny, $
        uname = 'RAFINS_SLIDER',title = this_title)
      Widget_control,fix_id[i],get_uvalue = uval
      uval.slider_id = slider_id[i]
      Widget_control,fix_id[i],set_uvalue = uval
      multi_fields[i] = Cw_field(multi_row_base[i],value = parms[n_single+i*ny], $
        title = m_parmnames[i], uname = 'MULTI_FIELD',/all_events,xsize = field_size)
      fix_base = Widget_base(multi_row_base[i],/row,/nonexclusive)
      fix_checks[count_widgets] = Widget_button(fix_base,value = 'Fixed', $
        uname = 'FIX_CHECK',uvalue =  { index:count_widgets,  $
        slider_id:slider_id[i], $
        slider_index:i})
      Widget_control,fix_id[i],get_uvalue = uval
      uval.fix_checks = fix_checks[count_widgets]
      Widget_control,fix_id[i],set_uvalue = uval
      this_base = Widget_base(multi_row_base[i],/row,/frame)
      lo_value[count_widgets] = Cw_field(this_base,title = 'Low', $
        uname = 'LOW_VALUE',value = Strtrim(String(lovalues[n_single+i*ny]),2), /all_events,$
        uvalue =  { index:count_widgets,  $
        slider_id:slider_id[i], $
        slider_index:i},xsize = field_size)
      non_ex_base_a = Widget_base(this_base,/row,/nonexclusive)
      lo_checks[count_widgets] = Widget_button(non_ex_base_a,value = 'Set lower bound', $
        uname = 'LOW_CHECK',uvalue =  { index:count_widgets,  $
        slider_id:slider_id[i], $
        slider_index:i})
      hi_base = Widget_base(multi_row_base[i],/row,/frame)
      hi_value[count_widgets] = Cw_field(hi_base,title = 'High', $
        uname = 'HIGH_VALUE',value = Strtrim(String(hivalues[n_single+i*ny]),2), /all_events,$
        uvalue =  { index:count_widgets,  $
        slider_id:slider_id[i], $
        slider_index:i},xsize = field_size)
      non_ex_base_b = Widget_base(hi_base,/row,/nonexclusive)
      hi_checks[count_widgets] = Widget_button(non_ex_base_b,value = 'Set upper bound', $
        uname = 'HIGH_CHECK',uvalue = { index:count_widgets,  $
        slider_id:slider_id[i], $
        slider_index:i})
      Widget_control,lo_checks[count_widgets],set_button = low[n_single+i*ny]
      Widget_control,fix_checks[count_widgets],set_button = fixed[n_single+i*ny]
      Widget_control,hi_checks[count_widgets],set_button = high[n_single+i*ny]

      ; Exchange widget ids in the user-values so that we can associate one
      ; with the other when we handle the events
      Widget_control,slider_id[i],set_uvalue = {field_id:multi_fields[i],index:i, $
        lo_checks:lo_checks[count_widgets],low_value:lo_value[count_widgets], $
        hi_checks:hi_checks[count_widgets],high_value:hi_value[count_widgets], $
        fix_checks:fix_checks[count_widgets]}
      Widget_control,multi_fields[i],set_uvalue = {slider_id:slider_id[i],index:i,$
        lo_checks:lo_checks[count_widgets],fix_id:fix_id[i]}
      count_widgets = count_widgets + 1L
    endfor
  endif

  ctrl_row_base = Widget_base(tlb,/row)
  void = Widget_button(ctrl_row_base,value = 'Apply',uname = 'APPLY')
  void = Widget_button(ctrl_row_base,value = 'Dismiss',uname = 'DISMISS')
  Centertlb,tlb
  Widget_control,tlb,/realize

  state = { ofunction:ofunction,                $
    notifyIDs:notifyIDs,                $
    ny:ny,                        $
    fix_id:fix_id,                    $
    n_single:n_single,                  $
    n_multi:n_multi,                  $
    lo_checks:lo_checks,                $
    hi_checks:hi_checks,                $
    single_fields:single_fields,            $
    multi_fields:multi_fields,              $
    cancel:1                      }

  pState = Ptr_new(state,/no_copy)
  Widget_control,tlb,set_uvalue = pState


  Xmanager,'modifyParms2D',tlb,/no_block,cleanup = 'modifyParms2D_cleanup', $
    event_handler = 'modifyParms2D_event'
end