; $Id$
;###############################################################################
;
; NAME:
;  ENTERPARMINFO_NEW
;
; PURPOSE:
;  This widget dialog allows the user to type in parameter info for the fit.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Larry R. Kneller, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8839
;   E-mail: larry.kneller@nist.gov
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function getparminfo_new,pState
; Ok, now pull all of the information out

ncurves = n_elements((*(*pState).parmInfoPtr).names)
nparms = total((*(*pState).parmInfoPtr).nparms)




;LRK 071207
;
;HERE ROB PULLS OUT VALUES FROM TEXT FIELDS BASED ON THE PARAMATER NUMBER.
;THE WHOLE DIALOG SHOULD BE SET UP TO RETRIEVE SETTINGS THIS WAY.
;
;US THE "start[i]" AND "finish[i]" VARIABLES THROUGHOUT TO INITIATE THE
;WIDGETS AND TO RETRIEVE THE VALUES.

; First pull out values from text fields

for i = 0,nparms-1 do begin
  widget_control,(*pState).valIds[i],get_value = valIds
  if i eq 0 then outValid = valIds[0] else outValid = [outValid,valIds[0]]
endfor
(*(*pState).parmInfoPtr).parms = outValid

for i = 0,nparms-1 do begin
  widget_control,(*pState).lowvalIds[i],get_value = lovalIds
  if i eq 0 then outlowvals = lovalIds[0] else outlowvals = [outlowvals,lovalids[0]]
endfor
(*(*pState).parmInfoPtr).lovalues = outlowvals

for i = 0,nparms-1 do begin
  widget_control,(*pState).hivalIds[i],get_value = hivalIds
  if i eq 0 then outhighvals = hivalIds[0] else outhighvals = [outhighvals,hivalids[0]]
endfor
(*(*pState).parmInfoPtr).hivalues = outhighvals

; Now pull out the checkbox settings
for i = 0,nparms-1 do begin
  widget_control,(*pState).fixIds[i],get_value = fixed
  if i eq 0 then outfixed = fixed else outfixed = [outfixed,fixed]
endfor
(*(*pState).parmInfoPtr).fixed = outfixed

for i = 0,nparms-1 do begin
  ;widget_control,(*pState).lowIds[i],get_value = low
  widget_control,(*pState).setlowChk[i],get_value = low

  if i eq 0 then outlow = low else outlow = [outlow,low]
endfor
(*(*pState).parmInfoPtr).low = outlow

for i = 0,nparms-1 do begin
  ;widget_control,(*pState).highIds[i],get_value = high
  widget_control,(*pState).sethiChk[i],get_value = high

  if i eq 0 then outhigh = high else outhigh = [outhigh,high]
endfor
(*(*pState).parmInfoPtr).high = outhigh

;INDIVIDUAL tied VALUES GO FROM 0 TO THE NUMBER OF PARMS IN THE CURVE.
;
;THIS MAY POSE A PROBLEM FOR THE TRANSLATION OF THESE INTO tied STRINGS
;IN func_cont.
;
;
;








;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;WHY NOT CREATE TIED STRINGS HERE TO RETURN WITH THE STRUCTURE??????
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
;
for i = 0,nparms-1 do begin
  ;widget_control,(*pState).tieComboIds[i],get_value = tied
  tied = nse_comboindex((*pState).tieComboIds[i])
  if i eq 0 then outtied = tied else outtied = [outtied,tied]
endfor
(*(*pState).parmInfoPtr).tied = outtied

;;;;;for i = 0,nparms-1 do begin
;;;;;  widget_control,(*pState).tieIds[i],get_value = tied
;;;;;  if i eq 0 then outtied = tied else outtied = [outtied,tied]
;;;;;endfor
(*(*pState).parmInfoPtr).tied = outtied

return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro parminfo_newCleanup,tlb
widget_control,tlb,get_uvalue = pState
if ((*pState).notifyIds)[0] ne (-1L) then begin
  s = size((*pState).notifyIDs)
  if s[0] eq 1 then count = 0 else count = s[2]-1
  for j = 0,count do begin
    parmsInfo = {parmsQuitEvent,$
                        ID:(*pState).notifyIDs[0,j],$
                        Top:(*pState).notifyIDs[1,j],$
                        Handler:0l}
    if widget_info((*pState).notifyIDs[0,j],/valid_id) then begin $
      widget_control,(*pState).notifyIDs[0,j],send_event = parmsInfo
    endif
  endfor
endif
ptr_free,(*pState).parmInfoPtr
ptr_free,pState
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro parminfo_newQuit,event
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro parminfo_newQuitModal,event
widget_control,event.top,get_uvalue = pState
dummy = getparminfo_new(pState)
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro parminfo_newAccept,event
widget_control,event.top,get_uvalue = pState
dummy = getparminfo_new(pState)
if ((*pState).notifyIds)[0] ne (-1L) then begin
  s = size((*pState).notifyIDs)
  if s[0] eq 1 then count = 0 else count = s[2]-1
  for j = 0,count do begin
    parmsInfo = {parmsEvent,$
                        ID:(*pState).notifyIDs[0,j],$
                        Top:(*pState).notifyIDs[1,j],$
                        Handler:0l,$
                        parmInfo:(*pState).parmInfoPtr}
    if widget_info((*pState).notifyIDs[0,j],/valid_id) then begin $
      widget_control,(*pState).notifyIDs[0,j],send_event = parmsInfo
    endif
  endfor
endif
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro enterparminfo_new_event,event
print,'enterparminfo_new     enterparminfo_new_event test'
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro enterparminfo_new,inInfo, $
                  group_leader = group_leader, $
                  notifyIds = notifyIds, $
                  modal = modal, $
                  parmInfoOut = parmInfoOut

;help,/traceback
;help,inInfo

if n_elements(modal) eq 0 then modal = 0
if n_elements(notifyIds) eq 0 then notifyIds = (-1L)
; Widget definition module
if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,title = 'PAN Parameter Information', $
        /tlb_frame_attr,/base_align_center)
endif else begin
  tlb = widget_base(group_leader = group_leader, /col, $
        title = 'PAN Parameter Information',/tlb_frame_attr, $
        /base_align_center,modal = modal)
endelse

xsize = 10

if n_params() eq 0 then begin
  ncurves = 2
  nparms = [3,2]
  totparms = total(nparms)
  names = ['pan_gaussian','pan_background']
  expr = replicate('',totparms)
  tied = replicate(0d,totparms)
  step = replicate(0d,totparms)
  fixed = replicate(0,totparms)
  lovalues = replicate(0d,totparms)
  low = replicate(0,totparms)
  high = replicate(0,totparms)
  hivalues = replicate(1d,totparms)
  parms = [1.0,0.0,1.0,0.0,0.0]
  parmnames = ['area','center','width','offset','slope']
  inInfo =   {names:names, nparms:nparms,step:step, fixed:fixed, $
              lovalues:lovalues, hivalues:hivalues, high:high, $
              low:low, parms:parms, parmnames:parmnames, $
              tied:tied,expr:expr}
endif

;LRK
;DOES parminfo HAVE THE INFORMATION ON THE PARAMETERS FOR ALL OF THE CURVES?
parminfo = {       names:inInfo.names, $
                   nparms:inInfo.nparms,$
                   step:inInfo.step, $
                   fixed:inInfo.fixed, $
                   lovalues:inInfo.lovalues, $
                   hivalues:inInfo.hivalues, $
                   high:inInfo.high, $
                   low:inInfo.low, $
                   parms:inInfo.parms, $
                   parmnames:inInfo.parmnames, $
                   tied:inInfo.tied, $
                   expr:inInfo.expr}

;print,'enterparminfo_new'
;print,inInfo.expr	;WAS expr INTENDED TO BE THE EXPRESSION USED IN THE tied STRING???????

nparms = parminfo.nparms
ncurves = n_elements(parminfo.names)
totparms = total(nparms)

dispNames = strarr(ncurves)
for i = 0,ncurves-1 do begin
  pos = strpos((parminfo.names)[i],'_')
  dispNames[i] = strmid(strupcase((parminfo.names)[i]),pos+1)
endfor

button_labels = dispNames
base = cw_tabbase(tlb,button_labels,/droplist,bases = coltab,/frame,/col)
tab = lonarr(ncurves)
for i = 0,ncurves-1 do begin
  tab[i] = widget_base(coltab[i],/row)
endfor

bases = lonarr(ncurves)
subBases = lonarr(ncurves)
for i = 0,ncurves-1 do begin
  bases[i] = widget_base(tab[i],/row)
endfor

ctrlBase = widget_base(tlb,/row)
if modal eq 0 then begin
  void = widget_button(ctrlBase,value = 'Apply',event_pro = 'parminfo_newAccept')
  void = widget_button(ctrlBase,value = 'Dismiss',event_pro = 'parminfo_newQuit')
endif else begin
  void = widget_button(ctrlBase,value = 'Apply and Dismiss', $
         event_pro = 'parminfo_newQuitModal')
endelse

;
;NEED CHECKBOXES AND TIED DROPLISTS.
;
;

count = 0



;LRK
;THIS LOOP SHOULD BE EXPANDED TO INCLUDE ALL OF THE FITTING
;OPTION WIDGETS.
;
;IF I WANT TO USE GRID LAYOUTS AND SET UP PARM TIES WITHIN
;INDIVIDUAL CURVES, THEN I NEED TO SET UP THE start AND finish ARRAYS
;HERE.
start = 0
finish = parminfo.nparms[0] - 1
for k = 1,ncurves-1 do begin
  start = [start,total(parminfo.nparms[0:k-1])]
  finish = [finish,total(parminfo.nparms[0:k])-1]
endfor



valbase   = lonarr(ncurves)
valIds    = lonarr(totparms)
fixids    = lonarr(totparms)
lowvalIds = lonarr(totparms)
hivalIds  = lonarr(totparms)

setlowChk   = lonarr(totparms)
sethiChk    = lonarr(totparms)

tieComboIds = lonarr(totparms)
tieScaleIds = lonarr(totparms)


for k = 0,ncurves-1 do begin

;print,'k=',k
  kparms   = finish[k]-start[k]+1
  kcolumns = 9

  ;INITIALLY USE col AND row BASES.  ONCE THIS IS WORKING MOVE TO gridlayout
  valbase[k] = widget_base(bases[k],$
  							/grid_layout,$
  							column=kcolumns,$
  							;row=kparms+1,$		;HAVE ONE EXTRA ROW FOR COLUMN LABELS
  							/base_align_right)

;   void = widget_label(tiedbase[i],value = 'Tie')


  if (parminfo.expr)[k] ne '' then begin
    void = widget_label(coltab[k],value = (parmInfo.expr)[k])
  endif

  ;PLACE ALL LABELS FIRST
;  void = widget_label(valbase[k],value = 'Values')
;  void = widget_label(valbase[k],value = 'fixed')
;  void = widget_label(valbase[k],value = 'Set Low')
;  void = widget_label(valbase[k],value = 'Lower Limit')
;  void = widget_label(valbase[k],value = 'Set Hi')
;  void = widget_label(valbase[k],value = 'Upper Limit')
;  void = widget_label(valbase[k],value = 'Tied')
;  void = widget_label(valbase[k],value = 'Tie scale')

  collabels = ['Parameter Name','Values','fixed','SetLow','Lower Limit','Set Hi','Upper Limit','Tied','Tied Scale']


;BECAUSE OF THE WAY THE GRID_LAYOUT FILLS THE GRID, THIS HAS TO BE DONE ONE COLUMN AT A TIME.
  void = widget_label(valbase[k],value = 'Parameter')
  count = start[k]
  for j = 0,nparms[k]-1 do begin
      valIds[count] = widget_label(valbase[k],value = 'p['+strtrim(string(fix(count)),2)+'] = '+parminfo.parmnames[count])
      count = count + 1	;COUNT GOES THROUGH ALL OF THE PARAMTERS IN ALL OF THE CURVES
  endfor;j

  void = widget_label(valbase[k],value = 'Values')
  count = start[k]
  for j = 0,nparms[k]-1 do begin
      valIds[count] = cw_field(valbase[k],value = parminfo.parms[count],$
                        title = 'p['+strtrim(string(fix(count)),2)+']',$
                        xsize = xsize)
      count = count + 1	;COUNT GOES THROUGH ALL OF THE PARAMTERS IN ALL OF THE CURVES
  endfor;j

  void = widget_label(valbase[k],value = 'fixed')
  count = start[k]
  for j = 0,nparms[k]-1 do begin
  	  fixids[count]    =  cw_bgroup(valbase[k],['p['+strtrim(string(fix(count)),2)+']'],$
	  											/nonexclusive);,label_left=parminfo.parmnames[count])
      count = count + 1	;COUNT GOES THROUGH ALL OF THE PARAMTERS IN ALL OF THE CURVES
  endfor;j


  void = widget_label(valbase[k],value = 'Set Low')
  count = start[k]
  for j = 0,nparms[k]-1 do begin
	  setlowChk[count] =  cw_bgroup(valbase[k],['p['+strtrim(string(fix(count)),2)+']'],$
	  											/nonexclusive);,label_left=parminfo.parmnames[count])
      count = count + 1	;COUNT GOES THROUGH ALL OF THE PARAMTERS IN ALL OF THE CURVES
  endfor;j

  void = widget_label(valbase[k],value = 'Lower Limit')
  count = start[k]
  for j = 0,nparms[k]-1 do begin
	  lowvalIds[count] =  cw_field(valbase[k],value = parminfo.parms[count],$
                        				title = 'p['+strtrim(string(fix(count)),2)+']',$;parminfo.parmnames[count],
                        				xsize = xsize)
      count = count + 1	;COUNT GOES THROUGH ALL OF THE PARAMTERS IN ALL OF THE CURVES
  endfor;j


  void = widget_label(valbase[k],value = 'Set Hi')
  count = start[k]
  for j = 0,nparms[k]-1 do begin
	  setHiChk[count] =  cw_bgroup(valbase[k],['p['+strtrim(string(fix(count)),2)+']'],$
	  											/nonexclusive);,label_left=parminfo.parmnames[count])
      count = count + 1	;COUNT GOES THROUGH ALL OF THE PARAMTERS IN ALL OF THE CURVES
  endfor;j

  void = widget_label(valbase[k],value = 'Upper Limit')
  count = start[k]
  for j = 0,nparms[k]-1 do begin
	  hivalIds[count] =  cw_field(valbase[k],value = parminfo.parms[count],$
                        				title = 'p['+strtrim(string(fix(count)),2)+']',$;parminfo.parmnames[count],
                        				xsize = xsize)
      count = count + 1	;COUNT GOES THROUGH ALL OF THE PARAMTERS IN ALL OF THE CURVES
  endfor;j

  void = widget_label(valbase[k],value = 'Tied')
  count = start[k]
  for j = 0,nparms[k]-1 do begin


     ;tieNames SHOULD PROBABLY INCLUDE ALL OF THE PARMS FROM EVERY CURVE
     ;SINCE A USER MAY WANT TO TIE THE PARMS IN SAY ONE GAUSSIAN WITH ANOTHER.

  	  tieNames = parminfo.parmnames;[start[k]:finish[k]]
  	  ;tieNames[j] = 'SELF'
	  tieNames[count] = 'SELF'

	  for ii = 0,n_elements(tieNames)-1 do begin
			tieNames[ii] = 'p['+strtrim(string(fix(ii)),2)+'] = '+tieNames[ii]
	  endfor;ii

  	  tieComboIds[count] = widget_combobox(valbase[k],value=tieNames)
  	  widget_control,tieComboIds[count],set_combobox_select=count;j

      count = count + 1	;COUNT GOES THROUGH ALL OF THE PARAMTERS IN ALL OF THE CURVES
  endfor;j

  void = widget_label(valbase[k],value = 'Tie Scale')
  count = start[k]
  for j = 0,nparms[k]-1 do begin
  	  tieScaleIds[count] = cw_field(valbase[k],title='',$
  	  								value=1.0d,xsize=xsize)
  	  ;print,j,nse_comboindex(tieComboIds[count])
      count = count + 1	;COUNT GOES THROUGH ALL OF THE PARAMTERS IN ALL OF THE CURVES
  endfor;j	;j GOES THROUGH ALL THE PARMS IN ONE CURVE

endfor;k	;k GOES THROUGH ALL THE CURVES


;;;;;;;;;;
;;;;;;;;;;for k = 0,ncurves-1 do begin
;;;;;;;;;;  valbase[k] = widget_base(bases[k],/col,/base_align_right)
;;;;;;;;;;  if (parminfo.expr)[k] ne '' then begin
;;;;;;;;;;    void = widget_label(coltab[k],value = (parmInfo.expr)[k])
;;;;;;;;;;  endif
;;;;;;;;;;  void = widget_label(valbase[k],value = 'Values')
;;;;;;;;;;  for j = 0,nparms[k]-1 do begin
;;;;;;;;;;      valIds[count] = cw_field(valbase[k],value = parminfo.parms[count],$
;;;;;;;;;;                        title = parminfo.parmnames[count],xsize = xsize)
;;;;;;;;;;      count = count + 1
;;;;;;;;;;  endfor;j
;;;;;;;;;;endfor;k
;;;;;;;;;;
;;;;;;;;;;
;;;;;;;;;;fixbase = lonarr(ncurves)
;;;;;;;;;;
;;;;;;;;;;count = 0
;;;;;;;;;;fixIds = lonarr(ncurves)
;;;;;;;;;;for k = 0,ncurves-1 do begin
;;;;;;;;;;  ;;;;;;;;;
;;;;;;;;;;  fixbase[k] = widget_base(bases[k],/col)
;;;;;;;;;;  ;;;;;;;;;
;;;;;;;;;;  void = widget_label(fixbase[k],value = 'Fixed')
;;;;;;;;;;  fixIds[k] = cw_bgroup(fixbase[k],parminfo.parmnames[start[k]:finish[k]],$
;;;;;;;;;;              /col,/nonexclusive, $
;;;;;;;;;;              set_value = byte(parminfo.fixed[start[k]:finish[k]]))
;;;;;;;;;;endfor
;;;;;;;;;;
;;;;;;;;;;lowbase = lonarr(ncurves)
;;;;;;;;;;lowIds = lonarr(ncurves)
;;;;;;;;;;for k = 0,ncurves-1 do begin
;;;;;;;;;;  lowbase[k] = widget_base(bases[k],/col)
;;;;;;;;;;
;;;;;;;;;;  void = widget_label(lowbase[k],value = 'Set Low')
;;;;;;;;;;  lowIds[k] = cw_bgroup(lowbase[k],parminfo.parmnames[start[k]:finish[k]], $
;;;;;;;;;;              /col,/nonexclusive, $
;;;;;;;;;;              set_value = byte(parminfo.low[start[k]:finish[k]]))
;;;;;;;;;;endfor
;;;;;;;;;;
;;;;;;;;;;lovalbase = lonarr(ncurves)
;;;;;;;;;;count = 0
;;;;;;;;;;for i = 0,ncurves-1 do begin
;;;;;;;;;;
;;;;;;;;;;  lovalbase[i] = widget_base(bases[i],/col,/base_align_right)
;;;;;;;;;;  void = widget_label(lovalbase[i],value = 'Lower Limit')
;;;;;;;;;;  for j = 0,nparms[i]-1 do begin
;;;;;;;;;;    lowvalIds[count] = cw_field(lovalbase[i],value = parminfo.lovalues[count],$
;;;;;;;;;;                       title = parminfo.parmnames[count],xsize = xsize)
;;;;;;;;;;    count = count + 1
;;;;;;;;;;  endfor
;;;;;;;;;;endfor
;;;;;;;;;;
;;;;;;;;;;highbase = lonarr(ncurves)
;;;;;;;;;;highIds = lonarr(ncurves)
;;;;;;;;;;
;;;;;;;;;;for i = 0,ncurves-1 do begin
;;;;;;;;;;  highbase[i] = widget_base(bases[i],/col)
;;;;;;;;;;  void = widget_label(highbase[i],value = 'Set High')
;;;;;;;;;;  highIds[i] = cw_bgroup(highbase[i],parminfo.parmnames[start[i]:finish[i]], $
;;;;;;;;;;               /col,/nonexclusive, $
;;;;;;;;;;               set_value = byte(parminfo.high[start[i]:finish[i]]))
;;;;;;;;;;endfor
;;;;;;;;;;
;;;;;;;;;;hivalbase = lonarr(ncurves)
;;;;;;;;;;count = 0
;;;;;;;;;;for i = 0,ncurves-1 do begin
;;;;;;;;;;  hivalbase[i] = widget_base(bases[i],/col,/base_align_right)
;;;;;;;;;;  void = widget_label(hivalbase[i],value = 'Upper Limit')
;;;;;;;;;;  for j = 0,nparms[i]-1 do begin
;;;;;;;;;;    hivalIds[count] = cw_field(hivalbase[i],value = parminfo.hivalues[count],$
;;;;;;;;;;                      title = parminfo.parmnames[count],xsize = xsize)
;;;;;;;;;;    count = count + 1
;;;;;;;;;;  endfor
;;;;;;;;;;endfor
;;;;;;;;;;
;;;;;;;;;;tiedbase = lonarr(ncurves)
;;;;;;;;;;tieIds = lonarr(ncurves)
;;;;;;;;;;scaleTieIds = lonarr(ncurves)
;;;;;;;;;;
;;;;;;;;;;TieComboPtr = ptrarr(ncurves)
;;;;;;;;;;
;;;;;;;;;;
;;;;;;;;;;;LRK 071107
;;;;;;;;;;;SET UP DROPLISTS OR COMBOBOXES HERE.
;;;;;;;;;;;THEN ADD SCALE FACTOR FIELD BESIDE IT.
;;;;;;;;;;for i = 0,ncurves-1 do begin
;;;;;;;;;;  tiedbase[i] = widget_base(bases[i],/col)
;;;;;;;;;;  void = widget_label(tiedbase[i],value = 'Tie')
;;;;;;;;;;
;;;;;;;;;;
;;;;;;;;;;;THE PROBLEM HERE IS THAT THERE ARE DIFFERENT NUMBERS OF parmnames FOR
;;;;;;;;;;;EACH curve.  THIS MEANS THAT I NEED A ncurves ELEMENT ARRAY OF POINTERS
;;;;;;;;;;;TO lonarr(finish[i]-start[i])
;;;;;;;;;;;THESE MUST BE CLEANED UP AT THE END.
;;;;;;;;;;
;;;;;;;;;;	TieCombos = lonarr(finish[i]-start[i]+1)
;;;;;;;;;;	TieComboPtr = ptr_new()
;;;;;;;;;;
;;;;;;;;;;
;;;;;;;;;;;  for j=start[i],finish[i] do begin
;;;;;;;;;;;  	tieCombos[j] = widget_combobox(tiedbase[i],value=parminfo.parmnames[start[i]:finish[i]])
;;;;;;;;;;;  	widget_control,tieCombos[j],set_combobox_select=j
;;;;;;;;;;;  	;scaleTieIds[i] = cw_field(tiedbase[i],title='Tie Scale',value=1.0,/float)
;;;;;;;;;;;  	print,j,nse_comboindex(tieCombos[j])
;;;;;;;;;;;  endfor;j
;;;;;;;;;;;
;;;;;;;;;;;
;;;;;;;;;;;  TieComboPtr[i] = ptr_new(TieCombos)
;;;;;;;;;;
;;;;;;;;;;
;;;;;;;;;;;SET UP DUMMY BASE FOR NOW TO KEEP THE CHECK BOXES AVAILABLE WHEN THEIR VALUES ARE CHECKED
;;;;;;;;;;;ELSEWHERE --- WHERE???
;;;;;;;;;;dumbase = widget_base()
;;;;;;;;;;  tieIds[i] = cw_bgroup(tiedbase[i],parminfo.parmnames[start[i]:finish[i]], $
;;;;;;;;;;;  tieIds[i] = cw_bgroup(dumbase,parminfo.parmnames[start[i]:finish[i]], $
;;;;;;;;;;               /col,/nonexclusive, $
;;;;;;;;;;               set_value = byte(parminfo.tied[start[i]:finish[i]]))
;;;;;;;;;;endfor;i

parmInfoOut = (-1L)

widget_control,tlb,/realize
state = {parminfoPtr:ptr_new(parmInfo,/no_copy),$
         lowvalIds:lowvalIds, $
         hivalIds:hivalIds, $
         fixIds:fixIds, $			;NOW totparms OF THESE
         valIds:valIds, $
         ;tieIds:tieIds, $
		 tieComboIds:tieComboIds,$	;NOW totparms OF THESE
	     setlowChk:setLowChk,$ 		;NOW totparms OF THESE
      	 setHiChk:setHiChk,$
  	     tieScaleIds:tieScaleIds,$
         notifyIds:notifyIds}
pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState

if modal eq 0 then begin
  xmanager,'enterparminfo_new',tlb,/no_block,cleanup = 'parminfo_newCleanup'
endif else begin
  xmanager,'enterparminfo_new',tlb

  parmInfoOut = *(*pState).parmInfoPtr

  ptr_free,(*pState).parmInfoPtr
  ptr_free,pState
endelse

return
end;enterparminfo_new