; $Id$
;###############################################################################
;
; NAME:
;  ENTERMACRO
;
; PURPOSE:
;  This widget dialog allows the user to type in a fit macro, save it,
;  and/or restore it.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro entermacro_event,event
widget_control,event.top,get_uvalue = pState
widget_control,event.id,get_value = val
case strupcase(val[0]) of
'ACCEPT':	begin
			  ;(*pState).out.accept = 1
			  (*pState).out.cancel = 0
			  widget_control,(*pState).expression,get_value = expr
			  *(*pState).out.pexpr = expr
			  widget_control,event.top,/destroy
			end
'CANCEL':	begin
			  ;(*pState).out.accept = 0
			  (*pState).out.cancel = 1
			  *(*pState).out.pexpr = ''
			  widget_control,event.top,/destroy
			end
'SAVE MACRO':	$
			begin
			widget_control,(*pState).expression,get_value = expr
			thisExpr = expr
			filename = DIALOG_PICKFILE(dialog_parent = event.top,$
                       title = 'Enter file name for your macro',$
                       /write,filter = '*.mf',$
                       path = (*pState).workDir)
            if filename eq '' or filename eq ' ' then return
            filename = lrk_addDotExt(filename,'.mf')
            ;extension = nsegetextension(filename)
            ;if strcmp(extension,'mf',/fold_case) eq 0 then filename = filename + '.mf'
			openw,lun,filename,/get_lun
			for i = 0,n_elements(thisexpr)-1 do printf,lun,thisexpr[i]
			free_lun,lun,/force
			end
'RESTORE MACRO': $
			begin
			filename = DIALOG_PICKFILE(dialog_parent = event.top,$
                       title = 'Select macro to restore',$
                       /read,filter = '*.mf',$
                       path = (*pState).workDir)
            if filename eq '' or filename eq ' ' then return
            counter = 0L & str = ''
			openr,lun,filename,/get_lun
            while not(eof(lun)) do begin
	            readf,lun,str
				if counter eq 0L then this_expr = str else this_expr = [this_expr,str]
				counter = counter+1L
            endwhile
			free_lun,lun
			widget_control,(*pState).expression,set_value = this_expr
			end
else:
endcase
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function entermacro,group_leader = group_leader,directory = directory, type=type
if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,title = 'User fit macro entry',/tlb_frame_attr)
endif else begin
  tlb = widget_base(group_leader = group_leader, /col,/modal, $
        title = 'User fit macro entry',/tlb_frame_attr)
endelse
thisFont = "Comic Sans MS*22*Bold"

if (n_elements(type) eq 0) then type=0
if (type eq 0) then filename = !DAVE_AUXILIARY_DIR+'sample1DFitMacro.mf'
if (type eq 1) then filename = !DAVE_AUXILIARY_DIR+'sample2DFitMacro.mf'
samplemacro = strarr(file_lines(filename))
Openr,unit, filename, /get_lun
Readf, unit, samplemacro
Free_lun, unit, /force

;strout = ["parmnames = ['area','center','fwhm','bg']","initParms=[1.0,0.0,1.0,0.0]", $
;	'area = parms[0]','center = parms[1]','fwhm = parms[2]','bg = parms[3]', $
;	'sig = fwhm/2.354', $
;	'yg = (area/sqrt(2.0*!dpi*sig^2))*exp(-0.5*((x-center)/sig)^2)',$
;	'ymodel = yg+bg']

expression = cw_field(tlb,title = 'Macro', $
             value = samplemacro,/col,xsize = 120, $
             fieldfont = thisFont,font = thisFont,ysize = 15)
rowBase = widget_base(tlb,/row)


void = widget_button(rowBase,value = 'Save Macro')
void = widget_button(rowBase,value = 'Restore Macro')
void = widget_button(rowBase,value = 'Accept')
void = widget_button(rowBase,value = 'Cancel')

widget_control,tlb,/realize

out = {pexpr:ptr_new(''),cancel:1}
state = {out:out,expression:expression,workDir:directory}
pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState
xmanager,'entermacro',tlb

out = (*pState).out
ptr_free,pState
return,out
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;