; ***********************
function tdi_makepts,xlo,xhi,nx
return,xlo+((xhi-xlo)/(nx-1.0))*dindgen(nx)
end
; ***********************
pro test_double_integral
nx = 150
ny = 140
nz = 100

x = tdi_makepts(0.0,1.0,nx)
y = tdi_makepts(0.0,2.0,ny)
z = tdi_makepts(-1.0,1.0,nz)

f = fltarr(nz,nx,ny)

for i = 0,nz-1 do f[i,*,*] = z[i]*(x#y)

help,x##y

dx = x[1]-x[0]
dy = y[1]-y[0]

fz = (total(total(temporary(f*dx*dy),2),2))

plot,z,fz,psym = 4
oplot,z,z,thick = 2.0

end