; $Id$
; POD.pro
;
; Application that allows user to digitize data from a scanned
; data plot using the mouse.  This program only reads in JPEG files.
;
; Uses:		RMDPlot.pro
;
; Written by R.M.Dimeo (08/17/01)
;
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro podCleanup,tlb
widget_control,tlb,get_uvalue = pState,/no_copy
tvlct,(*pState).rorig,(*pState).gorig,(*pState).borig
;z = ptr_valid(count = n) & print,'Pointers remaining: ',n
;s = size((*pState).notifyIDs)
;if s[0] eq 1 then count = 0 else count = s[2] - 1
;for j = 0,count do begin
;  pseudoEvent = {PODEvent,$
;                         ID:(*pState).notifyIDs[0,j],$
;                         top:(*pState).notifyIDs[1,j],$
;                         handler:0l,$
;                         inPtr:ptr_new(*(*pState).inPtr)}
;  if widget_info((*pState).notifyIDs[0,j],/valid_id) then $
;     widget_control,(*pState).notifyIDs[0,j],send_event = pseudoEvent,/no_copy
;endfor
ptr_free,(*pState).imgPtr
ptr_free,(*pState).dataPtr
ptr_free,pState
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro DTExit,event
widget_control,event.top,get_uvalue = pState,/no_copy
;s = size((*pState).notifyIDs)
;if s[0] eq 1 then count = 0 else count = s[2] - 1
;for j = 0,count do begin
;  pseudoEvent = {PODEvent,$
;                         ID:(*pState).notifyIDs[0,j],$
;                         top:(*pState).notifyIDs[1,j],$
;                         handler:0l,$
;                         inPtr:ptr_new(*(*pState).inPtr)}
;  if widget_info((*pState).notifyIDs[0,j],/valid_id) then $
;     widget_control,(*pState).notifyIDs[0,j],send_event = pseudoEvent,/no_copy
;endfor
widget_control,event.top,set_uvalue = pState,/no_copy
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro callDT,event
widget_control,event.top,get_uvalue = pState,/no_copy
limPtr = DTGetLimits(group_leader = event.top,(*pState).imgPtr)
dataPtr = DTGetPoints(group_leader = event.top,(*pState).imgPtr,limPtr)
if n_elements(*dataPtr) lt 2 then begin
  widget_control,event.top,set_uvalue = pState,/no_copy
  return
endif
data = *dataPtr
ptr_free,dataPtr
datSize = size(data)
npts = datSize[2]
x = fltarr(npts) & y = fltarr(npts)
xnew = fltarr(npts) & ynew = fltarr(npts)
x[*] = data[0,*]
y[*] = data[1,*]
lims = *limPtr
ptr_free,limPtr
a = lims[0] & b = lims[1] & c = lims[2] & d = lims[3]
xnew = a*x+b & ynew = c*y+d
dataNew = fltarr(2,npts)
dataNew[0,*] = xnew[*]
dataNew[1,*] = ynew[*]
*(*pState).dataPtr = dataNew
widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro DTLoadJPEGFile,event
widget_control,event.top,get_uvalue = pState,/no_copy
catch,errno
if (errno ne 0) then begin
  catch,/cancel
  void = dialog_message(/error,["Unknown error detected",!err_string])
  flag = 1
  widget_control,event.top,set_uvalue = pState,/no_copy
  return
endif

path = (*pState).workDir
file = DIALOG_PICKFILE(title = 'Name of file',filter='*.jpg',$
                       /read,dialog_parent = event.top,$
                       path = path)
if file eq '' then begin
  widget_control,event.top,set_uvalue = pState,/no_copy
  return
endif
read_jpeg,file,thisImage
catch,/cancel

if n_elements(thisImage) gt 0 then *(*pState).imgPtr = thisImage
widget_control,event.top,set_uvalue = pState,/no_copy
callDT,event
widget_control,event.top,get_uvalue = pState,/no_copy

widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro DTWriteFile,event
widget_control,event.top,get_uvalue = pState,/no_copy
if not ptr_valid((*pState).dataPtr) then begin
  widget_control,event.top,set_uvalue = pState,/no_copy
  return
endif
path = (*pState).workDir
filename = DIALOG_PICKFILE(FILTER = '*.txt',/write,$
                dialog_parent = event.top,$
                title = 'Digitized Data File Name',$
                path = path)
filename = filename+'.txt'
openw,lun,filename,/get_lun
datSize = size(*(*pState).dataPtr)
npts = datSize[2]
data = *(*pState).dataPtr
x = fltarr(npts)
x[*] = data[0,*]
y = fltarr(npts)
y[*] = data[1,*]
xsort = sort(x)
x = x[xsort]
y = y[xsort]
for i = 0,npts-1 do begin
  printf,lun,x[i],y[i]
endfor
free_lun,lun

widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro DTPlotPoints,event
widget_control,event.top,get_uvalue = pState,/no_copy
if not ptr_valid((*pState).dataPtr) then begin
  widget_control,event.top,set_uvalue = pState,/no_copy
  return
endif

datSize = size(*(*pState).dataPtr)
npts = datSize[2]
data = *(*pState).dataPtr
x = fltarr(npts)
x[*] = data[0,*]
y = fltarr(npts)
y[*] = data[1,*]
xsort = sort(x)
x = x[xsort]
y = y[xsort]
result = RMDPlot((*pState).dataPtr, workDir=(*pState).workDir)
widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro POD_event,event

uname = widget_info(event.id,/uname)

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'POD_event: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif

case uname of
    'LOAD': DTLoadJPEGFile, event
    'WRITE': DTWriteFile, event
    'PLOT': DTPlotPoints, event
    'EXIT': DTExit, event
    else:
endcase

return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;pro POD,notifyIDs,inPtr,group_leader = group_leader
pro POD, group_leader = group_leader, workDir=workDir, _EXTRA=etc

tvlct,rorig,gorig,borig,/get
butsize = 200

;cd,current  = homeDirectory

;if !d.name eq 'X' then begin
;  device,pseudo = 8
;  device,get_visual_depth=visDepth
;;  if ((visDepth eq 16) or (visDepth eq 8)) then begin
;;    device,true_color = 24
;    device,pseudo = 8
;;  endif else begin
;;    device,true_color = 24
;;  endelse
;endif

if (n_elements(workDir) eq 0) then begin
    workDir = (n_elements((*!dave_defaults).workDir) gt 0)? (*!dave_defaults).workDir : ''
endif

tlb = widget_base(/col,title = 'POD',/base_align_center,group_leader = group_leader,$
                           tlb_frame_attr = 1)
void = widget_button(tlb,value = 'Load JPEG File',uname='LOAD', $ ;event_pro = 'DTLoadJPEGFile',
                     xsize = butsize)

void = widget_button(tlb,value = 'Write Digitized Points to a File',uname='WRITE', $ ;event_pro = 'DTLoadJPEGFile',
                     xsize = butsize)
void = widget_button(tlb,value = 'Plot Digitized Points',uname='PLOT', $ ; event_pro = 'DTPlotPoints',
                     xsize = butsize)
void = widget_button(tlb,value = 'Exit',uname='EXIT',xsize = butsize) ; , event_pro = 'DTExit'

centertlb,tlb
widget_control,tlb,/realize
xsize = 500
ysize = 450
state = {imgPtr:ptr_new(/allocate_heap),$
         winxsize:xsize,$
         winysize:ysize,$
         dataPtr:ptr_new(/allocate_heap),$
         rorig:rorig,$
         gorig:gorig,$
         borig:borig,$
         workDir:workDir $
;         inPtr:inPtr,$
;         notifyIDs:notifyIDs
         }

widget_control,tlb,set_uvalue = ptr_new(state,/no_copy)
xmanager,'POD',tlb,/no_block,cleanup = 'podCleanup'

end
