; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; Written by J.R.D. Copley.
;************************************************************************************************
pro dave_cross_sections_cleanup,tlb
;************************************************************************************************
;
compile_opt strictarr
;
end


;************************************************************************************************
pro dave_cross_sections_handler,event
;************************************************************************************************
;
compile_opt strictarr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'dave_cross_sections_handler: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif

;
widget_control,event.top,get_uvalue=state
;
redo_table=0
;
if (event.id eq state.write) then begin
;	if (lmgr(/vm)) then begin
;		path=sourceroot()
;	endif else begin
;		path=(*!dave_defaults).workDir
;	endelse
    path = state.workDir
	filename=dialog_pickfile(title="Select output file name",path=path)
	if (filename eq "") then return
	openw,unit,filename,/get_lun
	ntags=n_tags(state.xsecs)
	tags=tag_names(state.xsecs)
	title=strarr(ntags-1)
	title[0]="Isotope"
	for j=1,ntags-2 do begin
		title[j]=state.column_labels[j-1]
	endfor
	maxlength=intarr(ntags-1)
	format=strarr(ntags-1)+'('
	for j=0,ntags-2 do begin
		maxlength[j]=max(strlen(state.xsecs.(j))) > strlen(title[j])
		format[j]=format[j]+'A'+strcompress(maxlength[j],/remove_all)
	endfor
	format=format+')'
	list=''
	for j=0,ntags-2 do begin
		list=list+string(title[j],format=format[j])
	endfor
	printf,unit,list
	nlines=n_elements(state.xsecs.(0))
	for k=0,nlines-1 do begin
		list=''
		for j=0,ntags-2 do begin
			xsecs_j=state.xsecs.(j)[k]
			list=list+string(xsecs_j,format=format[j])
		endfor
		printf,unit,list
	endfor
	close,unit
	free_lun,unit
	res=dialog_message("File "+filename+" has been written.",/information)
endif
;
if (event.id eq state.search) then begin
	state.linenumber=where(state.row_labels eq ' nat-'+state.elements[event.index],count)
	if (count eq 0) then return
	widget_control,state.table,set_table_view=[0,state.linenumber[0]]
endif
;
if (event.id eq state.all) then begin
	for k=0,state.nquans-2 do begin
		widget_control,state.butt[k],set_button=1
	endfor
	state.show=intarr(state.nquans-1)+1
	redo_table=1
endif
;
if (event.id eq state.clear) then begin
	for k=0,state.nquans-2 do begin
		widget_control,state.butt[k],set_button=0
	endfor
	state.show=intarr(state.nquans-1)
endif
;
for k=0,state.nquans-2 do begin
	if (event.id eq state.butt[k]) then begin
		state.show[k]=1-state.show[k]
		redo_table=1
		break
	endif
endfor
;
if (event.id eq state.getlambda) then begin
	widget_control,state.getlambda,get_value=lambda
	widget_control,state.getlambda,set_value=string(lambda[0],format='(f6.3)')
	state.lambda=lambda[0]
	redo_table=1
endif
;
if (redo_table eq 1) then begin
	indices=where(state.show eq 1,count)
	if (count eq 0) then return
	include_xsabs=(state.show[state.nquans-3] eq 1)
	include_xstot=(state.show[state.nquans-2] eq 1)
	count=count-include_xstot-include_xsabs
;
	xsecs=state.xsecs
	if (count gt 0) then begin
		table_content=transpose(xsecs.(indices[0]+1))
		if (count gt 1) then begin
			for k=1,count-1 do begin
				table_content=[table_content,transpose(xsecs.(indices[k]+1))]
			endfor
		endif
	endif
	rat=state.lambda/state.lambda0
;
	xsabs=strarr(state.nlines)
	for k=0,state.nlines-1 do begin
		nogo=(strpos(xsecs.xsabs[k],'<') ne -1) or (strpos(xsecs.xsabs[k],'+/-') ne -1)	or (strpos(xsecs.xsabs[k],'---') ne -1)
		if (nogo) then xsabs[k]='***' else xsabs[k]=string(float(rat*xsecs.xsabs[k]),format='(f9.3)')
	endfor
	if (include_xsabs) then begin
		if (count eq 0) then begin
			table_content=transpose(xsabs)
		endif else begin
			table_content=[table_content,transpose(xsabs)]
		endelse
	endif
;
	xstot=strarr(state.nlines)
	for k=0,state.nlines-1 do begin
		nogo=(strpos(xsecs.xssct[k],'<') ne -1) or (strpos(xsecs.xssct[k],'+/-') ne -1) or (strpos(xsecs.xssct[k],'---') ne -1)$
			or (strpos(xsabs[k],'***') ne -1)
		if (nogo) then xstot[k]='***' else xstot[k]=string(float(xsecs.xssct[k])+float(xsabs[k]),format='(f9.3)')
	endfor
	if (include_xstot) then begin
		if (count eq 0) then begin
			table_content=transpose(xstot)
		endif else begin
			table_content=[table_content,transpose(xstot)]
		endelse
	endif
;
	column_labels=state.column_labels[indices]
	ncols=count+include_xsabs+include_xstot
	widget_control,state.table,/destroy
	table=widget_table(event.top,xsize=ncols,ysize=state.nlines,$
		x_scroll_size=ncols,y_scroll_size=25, $   ;16,$
		alignment=state.alignment,$
		column_widths=state.column_widths,$
		column_labels=column_labels,$
		row_labels=state.row_labels,/resizeable_columns)
		
		
		
	;-------------------------------------------------
	; RTA
	; 1) make column_width large enough to accommodate the longest entry
	max_col_width = Max(Strlen(table_content))*!d.x_ch_size

	; 2) make use of table colors to improve on the presentation
	nrows = (Size(table_content,/dimensions))[1]
	ncols = (Size(table_content,/dimensions))[0]
	bcolor = Make_array(3,ncols-1,nrows-1,/byte,value=255) ; default to white
  bcolor = Make_array(3,ncols,nrows,/byte,value=255) ; default to white
  bcolor[0, 0:ncols-1:2,*] = 153 ; mint-green to 2nd col
  bcolor[1, 0:ncols-1:2,*] = 255
  bcolor[2, 0:ncols-1:2,*] = 204
	;-------------------------------------------------

	Widget_control,table,set_value=table_content, background_color=bcolor, column_widths=max_col_width

	;widget_control,table,set_value=table_content
	widget_control,table,set_table_view=[0,state.linenumber[0]]
	screensize=get_screen_size()
	geom=widget_info(event.top,/geometry)
	widget_control,event.top,scr_xsize=screensize[0]*0.8 < geom.scr_xsize
	widget_control,table,/realize
	state.table=table
endif
;
if (event.id eq state.done) then begin
	widget_control,event.top,/destroy
	return
endif
;
widget_control,event.top,set_uvalue=state
end


;************************************************************************************************
pro dave_cross_sections,$
;added following 3 keywords to make this a non-modal widget
	group_leader = group_leader,$
	notify_ids = notify_ids,$
	register_name = register_name, $
	DAVETool=oDAVETool, $                ; the DAVE2 tool object
	workDir=workDir, $
	_EXTRA=etc
;************************************************************************************************
;
compile_opt strictarr
;
;
;;;;;;;added following 4 lines for non-modal widget action
if n_elements(group_leader) eq 0 then group_leader = 0L
if n_elements(notify_ids) eq 0 then notify_ids = [0L,0L]
if n_elements(register_name) eq 0 then register_name = 'dave_cross_sections'
if (~obj_valid(oDAVETool)) then oDAVETool = obj_new()
if (n_elements(workDir) eq 0) then begin
    workDir = (lmgr(/vm))? sourcepath() : (*!dave_defaults).workDir
endif
if xregistered(register_name) then return
;
database=-1
xsecsdb,xsecs,xslabels,database=database
;
nquans=n_tags(xsecs)
nlines=n_elements(xsecs.(0))
;
indices=where(strmid(xsecs.atsym,1,3) eq 'nat')
elements=strmid(xsecs.atsym[indices],5)
;
lambda0=1.798
lambda=lambda0
;
alignment=1
column_widths=80
column_labels=xslabels[1:nquans-1]
row_labels=xsecs.(0)
;
tlb_title='Atomic weights and neutron scattering and absorption cross sections'
tlb=widget_base(title=tlb_title,/col,group_leader=group_leader,mbar=bar)
	filemenu=widget_button(bar,/menu,value='File')
		write=widget_button(filemenu,value='Write data file')
		done=widget_button(filemenu,value="Quit")
	base1=widget_base(tlb,/row,space=20)
		base1a=widget_base(base1,/col,/frame)
			void=widget_label(base1a,value='Select an element')
			void=widget_label(base1a,value='to be displayed')
			search=widget_combobox(base1a,value=elements,/align_center)
		base1b=widget_base(base1,/col,/frame)
			void=widget_label(base1b,value='Enter the neutron')
			void=widget_label(base1b,value='wavelength (A)')
			getlambda=widget_text(base1b,value=string(lambda,format='(f6.3)'),xsize=6,/editable)
		base1c=widget_base(base1,/col,/frame)
			base1c1=widget_base(base1c,/row,space=40,/align_center)
				base1c1a=widget_base(base1c1,/row,space=20,/align_center)
					void=widget_label(base1c1a,/align_left,$
						value='Check the quantities to be displayed')
;					redo=widget_button(base1c1a,value="APPLY")
				base1c1b=widget_base(base1c1,/row,space=10)
					all=widget_button(base1c1b,value="Check all")
					clear=widget_button(base1c1b,value="Clear")
			toprow=widget_base(base1c,/row,/nonexclusive)
				butt=lonarr(nquans-1)
				colToBeShown = []
				for k=0,nquans-2 do begin
					butt[k]=widget_button(toprow,value=column_labels[k])
					
					; RTA - let b_coh and b_inc be deselested by default
					if (column_labels[k] ne 'b_coh' && column_labels[k] ne 'b_inc') then begin					
					  widget_control,butt[k],/set_button
					  colToBeShown = [colToBeShown,k]
					endif
				endfor
	table=widget_table(tlb,$
	  xsize=n_elements(column_labels[coltobeshown]), $           ;nquans-1, $
	  ysize=nlines, $
	  x_scroll_size=n_elements(column_labels[coltobeshown]), $   ;nquans-1, $
	  y_scroll_size=20, $                                        ;16,$
		alignment=alignment,$
		column_widths=column_widths,$
		column_labels=column_labels[coltobeshown], $                ;column_labels,$
		row_labels=row_labels,/resizeable_columns)
;
table_content=transpose(xsecs.(1))
show = intarr(nquans-1) + 1
for k=2,nquans-2 do begin
  if (colToBeShown.HasValue(k-1)) then $
	  table_content=[table_content,transpose(xsecs.(k))] else $
	  show[k-1] = 0
endfor
xssct=xsecs.xssct
xsabs=xsecs.xsabs
xstot=strarr(nlines)
for k=0,nlines-1 do begin
	nogo=(strpos(xssct[k],'<') ne -1) or (strpos(xsabs[k],'<') ne -1)$
		or (strpos(xssct[k],'+/-') ne -1) or (strpos(xsabs[k],'+/-') ne -1)$
		or (strpos(xssct[k],'---') ne -1) or (strpos(xsabs[k],'---') ne -1)
	if (nogo) then xstot[k]='***' else xstot[k]=string(float(xssct[k])+(lambda/lambda0)*xsabs[k],format='(f9.3)')
endfor
table_content=[table_content,transpose(xstot)]

;-------------------------------------------------
; RTA 
; 1) make column_width large enough to accommodate the longest entry
max_col_width = max(strlen(table_content))*!d.x_ch_size

; 2) make use of table colors to improve on the presentation
nrows = (Size(table_content,/dimensions))[1]
ncols = (Size(table_content,/dimensions))[0]
bcolor = Make_array(3,ncols,nrows,/byte,value=255) ; default to white
bcolor[0, 0:ncols-1:2,*] = 153 ; mint-green to 2nd col
bcolor[1, 0:ncols-1:2,*] = 255
bcolor[2, 0:ncols-1:2,*] = 204
;-------------------------------------------------

widget_control,table,set_value=table_content, background_color=bcolor, column_widths=max_col_width
screensize=get_screen_size()
geom=widget_info(tlb,/geometry)
widget_control,tlb,scr_xsize=screensize[0]*0.8 < geom.scr_xsize
centertlb,tlb
widget_control,tlb,/realize
;
state={done:done,$
;	redo:redo,$
	all:all,$
	clear:clear,$
	butt:butt,$
	show:show, $               ;intarr(nquans-1)+1,$
	search:search,$
	elements:elements,$
	getlambda:getlambda,$
	lambda:lambda,$
	lambda0:lambda0,$
	nlines:nlines,$
	nquans:nquans,$
	alignment:alignment,$
	column_widths:column_widths,$
	row_labels:row_labels,$
	column_labels:column_labels,$
	table:table,$
	linenumber:0,$
	write:write,$
	DAVETool:oDAVETool, $  ; object reference of DAVE2 Main Tool 
	workDir:workDir, $
	xsecs:xsecs}
widget_control,tlb,set_uvalue=state
;
xmanager,register_name,tlb,/no_block,cleanup='dave_cross_sections_cleanup',$
	event_handler="dave_cross_sections_handler"
;
end
