; $Id$
;###############################################################################
;
; NAME:
;  DHTML_CREATE_DIR
;
; PURPOSE:
;  Dialog allowing user to create a new directory.
;
; CATEGORY:
;  DAVE, electronic notebook.
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dhtml_cd_accept,event
widget_control,event.top,get_uvalue = pstate
(*pstate).cancel = 0
cur_dir_id = widget_info(event.top,find_by_uname = 'CURRENT_DIR')
new_dir_id = widget_info(event.top,find_by_uname = 'NEW_DIR')
widget_control,new_dir_id,get_value = new_dir_val
if new_dir_val[0] eq '' then begin
   strout = 'Not a valid filename'
   void = dialog_message(dialog_parent = event.top,strout)
   return
endif
widget_control,cur_dir_id,get_value = cur_dir_val
cur_dir = cur_dir_val[0]
new_dir = cur_dir+new_dir_val[0]+path_sep()
(*pstate).dir = new_dir
file_mkdir,new_dir
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dhtml_cd_cancel,event
widget_control,event.top,get_uvalue = pstate
(*pstate).cancel = 1
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dhtml_c_d_event,event
uname = widget_info(event.id,/uname)
case uname of
'ACCEPT':   dhtml_cd_accept,event
'CANCEL':   dhtml_cd_cancel,event
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dhtml_create_dir,    group_leader = group_leader,     $
                              current_dir = current_dir
reg_name = 'dhtml_create_dir'
if xregistered(reg_name) then return,0
if n_elements(group_leader) eq 0 then return,0
if n_elements(current_dir) eq 0 then cd,current = current_dir

tlb = widget_base(group_leader = group_leader,/tlb_frame_attr, $
   title = 'Create directory',/modal,/col)
void = cw_field(tlb,value = current_dir,title = 'Current directory', $
   uname = 'CURRENT_DIR',/col,xsize = 60)
void = cw_field(tlb,value = '',title = 'New directory name', $
   uname = 'NEW_DIR',/col,xsize = 20)
row_base = widget_base(tlb,/row)
void = widget_button(row_base,value = 'Accept',uname = 'ACCEPT')
void = widget_button(row_base,value = 'Cancel',uname = 'CANCEL')

centertlb,tlb
widget_control,tlb,/realize

state = {dir:current_dir,cancel:1}
pstate = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate
xmanager,reg_name,tlb,event_handler = 'dhtml_c_d_event'

dir = (*pstate).dir
cancel = (*pstate).cancel
ptr_free,pstate
return,{dir:dir,cancel:cancel}
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;