; $Id$
; **************************************************** ;
; NAME:
;
;  DAVE_CALCULATOR
;
; PURPOSE:
;
;  Application which allows the user to type general expressions
;  using IDL syntax and obtain a mathematical result.
;
; AUTHOR:
;
;  Robert Dimeo
;  National Institute of Standards and Technology
;  Center for Neutron Research
;  100 Bureau Drive, Mail Stop 8562
;  Gaithersburg, MD 20899
;  Tel: (301) 975-8135
;  Email: robert.dimeo@nist.gov
;
; CATEGORY:
;
;  DAVE application
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
; -
; **************************************************** ;
pro dave_calculator_cleanup,tlb
widget_control,tlb,get_uvalue = pstate
heap_free,pstate
end
; **************************************************** ;
pro dave_calculator_calculate,event
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   strout = ['Syntax error.','Could not evaluate expression.']
   void = dialog_message(dialog_parent = event.top,strout)
   return
endif
widget_control,event.top,get_uvalue = pstate
widget_control,(*pstate).expr_id,get_value = text
text = text[0]
expr = '_y='+text
r = execute(expr,1)
if n_elements(_y) gt 1 then begin
   result = '['+strjoin(string(_y),',')+']'
endif else begin
   result = string(_y)
endelse
widget_control,(*pstate).result_id,set_value = result
catch,/cancel
end
; **************************************************** ;
pro dave_calculator_help,event
text = 'Type the expression using IDL syntax in the field'
text = [text,'labeled EXPRESSION and press the CALCULATE button.']
text = [text,'Your result, if typed correctly, should appear']
text = [text,'in the field labeled RESULT.','','']
str = 'Example expressions include the following:'
text = [text,str]
str = '0.1^5' & text = [text,str]
str = 'sqrt(254.0)' & text = [text,str]
str = 'exp(-0.5*[0.1,0.2,0.3,0.4,0.5]^2)' & text = [text,str]
str = 'cos(([20.0,40.0,60.0,80.0,100.]^2)*!dtor)' & text = [text,str,'']
str = 'Note the use of array arguments.  This will lead to a resulting array.'
text = [text,str]
title = 'DAVE calculator help'
xdisplayfile,group = event.top,text = text,title = title
end
; **************************************************** ;
pro dave_calculator_load,event
widget_control,event.top,get_uvalue = pstate

;defsysv,'!dave_defaults',exists = exists
path = (*pState).workDir

text = ''
;if exists then begin
;   if ptr_valid((!dave_defaults)) then begin
;      path = (*!dave_defaults).workDir
;      void = dialog_pickfile(dialog_parent = event.top,        $
;         title = 'Select expression file',path = path,   $
;         filter = '*.calc',/read)
;      if void eq '' then return
;      openr,lun,text,/get_lun
;      readf,lun,text
;      free_lun,lun,/force
;   endif else begin
;      void = dialog_pickfile(dialog_parent = event.top,        $
;         title = 'Select expression file',path = path,   $
;         filter = '*.calc',/read)
;      if void eq '' then return
;      openr,lun,void,/get_lun
;      readf,lun,text
;      free_lun,lun,/force
;   endelse
;endif else begin
   void = dialog_pickfile(dialog_parent = event.top,        $
      title = 'Select expression file',path = path,   $
      filter = '*.calc',/read)
   if void eq '' then return
   openr,lun,void,/get_lun
   readf,lun,text
   free_lun,lun,/force
;endelse
widget_control,(*pstate).expr_id,set_value = text
widget_control,(*pstate).result_id,set_value = ''
end
; **************************************************** ;
pro dave_calculator_save,event
widget_control,event.top,get_uvalue = pstate
widget_control,(*pstate).expr_id,get_value = text
text = text[0]

;defsysv,'!dave_defaults',exists = exists
path = (*pState).workDir

;if exists and ptr_valid((!dave_defaults)) then begin
   path = (*!dave_defaults).workDir
   void = dialog_pickfile(dialog_parent = event.top,        $
      title = 'Type name of expression file',path = path,   $
      filter = '*.calc',/write)
   if void eq '' then return
   calc_pos = strpos(void,'.calc')
   if calc_pos eq -1 then void = void+'.calc'
   openw,lun,void,/get_lun
   printf,lun,text
   free_lun,lun,/force
;endif else begin
;   void = dialog_pickfile(dialog_parent = event.top,        $
;      title = 'Type name of expression file',path = path,   $
;      filter = '*.calc',/write)
;   if void eq '' then return
;   calc_pos = strpos(void,'.calc')
;   if calc_pos eq -1 then void = void+'.calc'
;   openw,lun,void,/get_lun
;   printf,lun,text
;   free_lun,lun,/force
;endelse
end
; **************************************************** ;
pro dave_calculator_about,event
strout = ['DAVE Calculator','Written by Rob Dimeo', $
          'June 28, 2005']
void = dialog_message(dialog_parent = event.top,strout,  $
   /information)
end
; **************************************************** ;
pro dave_calculator_event,event

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'dave_calculator_event: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif

uname = widget_info(event.id,/uname)
case uname of
'QUIT':  widget_control,event.top,/destroy
'EXPRESSION': dave_calculator_calculate,event
'CALC':  dave_calculator_calculate,event
'SAVE':  dave_calculator_save,event
'LOAD':  dave_calculator_load,event
'ABOUT': dave_calculator_about,event
'HELP':  dave_calculator_help,event
else:
endcase
end
; **************************************************** ;
pro dave_calculator, group_leader = group_leader, workDir=workDir, _EXTRA=etc
if n_elements(group_leader) eq 0 then group_leader = 0L
if (n_elements(workDir) eq 0) then begin
    workDir = (n_elements((*!dave_defaults).workDir) gt 0)? (*!dave_defaults).workDir : ''
endif

tlb = widget_base(/tlb_frame_attr,/col,title = 'Expression Calculator', $
   group_leader = group_leader,mbar = bar)
filemenu = widget_button(bar,value = 'File',/menu)
void = widget_button(filemenu,value = 'Help',uname = 'HELP')
void = widget_button(filemenu,value = 'Quit',uname = 'QUIT')
void = widget_button(filemenu,value = 'About',uname = 'ABOUT')
value = 'cos([45.0,46.0,47.0]*!dtor)'
;device,get_fontnames = fnames,set_font = '*'
;font = fnames[0]+'*24'

large_font = get_font_name(/huge, /helvetica,/bold)
med_font = get_font_name(/large,/helvetica,/bold)
title = 'Expression e.g.exp(-0.5*5.2^2), cos([45.0,46.0,47.0]*!dtor)'
expr_id = cw_field(tlb,value = value,uname = 'EXPRESSION',        $
   title = title,xsize = 75,/col,fieldfont = large_font,   $
   font = large_font,/return_events)
void = widget_label(tlb,value = 'Result',font = large_font)
result_id = widget_text(tlb,value = '',uname = 'RESULT',    $
   xsize = 75,ysize = 5,/scroll,/editable,font = large_font)
row = widget_base(tlb,/row,/align_center)
void = widget_button(row,value = 'calculate',uname = 'CALC',font = med_font)
void = widget_button(row,value = 'save expression',uname = 'SAVE',font = med_font)
void = widget_button(row,value = 'load expression',uname = 'LOAD',font = med_font)
void = widget_button(row,value = 'help',uname = 'HELP',font = med_font)
void = widget_button(row,value = 'quit',uname = 'QUIT',font = med_font)
centertlb,tlb
widget_control,tlb,/realize
state = {   expr_id:expr_id, workDir:workDir,       $
            result_id:result_id     }
widget_control,tlb,set_uvalue = ptr_new(state,/no_copy),/no_copy

xmanager,'dave_calculator',tlb,/no_block,cleanup = 'dave_calculator_cleanup'

end