; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    cwo_ConvertBT1ToDave_class
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;    inherits idl_container
;
;
;METHODS:
;    cwo_ConvertBT1ToDave_event
;    cwo_ConvertBT1ToDave_class::event
;    cwo_ConvertBT1ToDave_class::displayHelp
;    cwo_ConvertBT1ToDave_class::quit
;    cwo_ConvertBT1ToDave_class::selectFiles
;    cwo_ConvertBT1ToDave_class::convertFiles
;    cwo_ConvertBT1ToDave_class::convertData
;    cwo_ConvertBT1ToDave_class::addDotDave
;    cwo_ConvertBT1ToDave_class::getExt
;    cwo_ConvertBT1ToDave_class::writeDave
;    cwo_ConvertBT1ToDave_class::draw
;    cwo_ConvertBT1ToDave_class::setproperty
;    cwo_ConvertBT1ToDave_class::getproperty
;    cwo_ConvertBT1ToDave_cleanup
;    cwo_ConvertBT1ToDave_class::cleanup
;    cwo_ConvertBT1ToDave_class::init
;    cwo_ConvertBT1ToDave_class__define
;    cwo_ConvertBT1ToDave
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Fri Oct 27 20:53:03 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################




;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_event,event


	catch, catchError
	if (catchError ne 0) then begin
	    ;;print, 'Error handled!'
	    eTitle = 'BT1 To Dave Converter: Error encountered'
	    eMsg = 'An error or unusual condition was encountered at cwo_ConvertBT1ToDave_event!'
	    eMsg = [eMsg,'Please, report the following to Larry (kneller@nist.gov) on the DAVE team:']
	    eMsg = [eMsg,!error_state.msg]
	    void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
	    catch, /cancel
	    return
	endif


    widget_control,event.handler,get_uvalue=obj

    ret = obj->event(event)

    ;DO I HAVE TO PASS THIS EVENT DIRECTLY TO THE PARENT SOMEHOW??????
end;cwo_ConvertBT1ToDave_event
;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_ConvertBT1ToDave_class::event,event

    case event.id of
    self.quitbutton:begin
        self->quit
    end;quitbutton
    self.quitbuttonfile:begin
        self->quit
    end;quitbutton
    self.filebutton:begin
        ;self->selectFiles
        self->selectFilesNew
    end;filebutton
    self.filebuttonfile:begin
        ;self->selectFiles
        self->selectFilesNew
    end;filebutton
    self.workdirbutton:begin
        self->selectWorkingDirectory
    end;workdirbutton
    self.workdirbuttonfile:begin
        self->selectWorkingDirectory
    end;workdirbuttonfile
    self.mergebutton:begin
        ;THIS IS CALLED REGARDLESS OF WHETHER FILES ARE COMBINED OR NOT.
        widget_control,self.combineFilesCheckbox,get_value=writeval
        widget_control,self.defaultFilenameCheckbox,get_value=defaultnameswitch
        self->ConvertFiles,writeCombinedFile=writeval,defaultfilename=defaultnameswitch
    end;mergebutton
    self.mergebuttonfile:begin
        widget_control,self.combineFilesCheckbox,get_value=writeval
        widget_control,self.defaultFilenameCheckbox,get_value=defaultnameswitch
        self->ConvertFiles,writeCombinedFile=writeval,defaultfilename=defaultnameswitch
    end;mergebutton
    self.threecolumnasciibutton:begin
        ;THIS IS CALLED REGARDLESS OF WHETHER FILES ARE COMBINED OR NOT.
        widget_control,self.combineFilesCheckbox,get_value=writeval
        widget_control,self.defaultFilenameCheckbox,get_value=defaultnameswitch
        self->ConvertFiles,writeCombinedFile=0,/threeColAscii,defaultfilename=defaultnameswitch
    end;threecolumnasciibutton
    self.helpbutton:begin
        self->displayHelp
    end;helpbutton
    self.helpbuttonhelp:begin
        self->displayHelp
    end;helpbutton
    self.sortFilesBGroup:begin
        self->selectFilesNew,dir=self.datadir
    end;    
    else:
    endcase

    return,-1
end;cwo_ConvertBT1ToDave_class_event

;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::displayHelp
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::displayHelp

    b = widget_base(group_leader=self.tlb,title='Help on BT-1 to DAVE converter',/floating,/col)
    s = ['ConvertBT1ToDave: Written by Larry Kneller',$
         'Use this to convert BT-1 and GSAS data files to DAVE format',$
         'to facilitate use in DAVE visualizations and PAN.',$
         '',$
         'Currently GSAS files can be converted only into individual .txt or .dave files ',$
         'since there is not enough information in their headers to combine into a ',$
         'single multi-group .dave file.',$
         '',$
         'BT1 files can be combined into single multi-group DAVE files.',$
         '',$
         'To combine multiple single-group DAVE files into a single multi-group',$
         'DAVE file, use the application: ',$
         '',$
         'Misc Tools -> NSE -> NSE Merge DAVE Files',$
         '',$
         '',$
         'This provides the option to enter group yvalues that are missing in the ',$
         'GSAS files.',$
         '']
    text = widget_text(b,xsize=60,ysize = n_elements(s))

    widget_control,text,set_value=s
    widget_control,b,/realize

end;cwo_ConvertBT1ToDave_class::displayHelp


;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::quit
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::quit
    widget_control,self.tlb,/destroy
end;cwo_ConvertBT1ToDave_class::quit

;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::selectFiles
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::selectFilesNew,dir=dir

    if n_elements(dir) eq 0 then begin
      dir = dialog_pickfile(title='Select Input Data File Directory:',$
                           /directory,$
                           path=self.datadir,$
                           dialog_parent=self.tlb)
  ;                         ,$
  ;                         filter = ['*.dave','*.dat','*.iqt'])
   endif;n_elements(dir)

    if dir[0] ne '' then begin
        widget_control,self.text,set_value = 'Data directory: '+dir
        self.datadir = dir;file_dirname(fn[0])
        ;self.workdir = dir;file_dirname(fn[0])


        bt1files = file_search(dir+'*.bt1')
        gsasfiles = file_search(dir+'*.gsas')


        widget_control,self.sortFilesBGroup,get_value=sorttype

        bt1sort = sort(bt1files)
        bt1files = bt1files[bt1sort]
        
        gsassort = sort(gsasfiles)
        gsasfiles = gsasfiles[gsassort]


        files = [bt1files,gsasfiles]
        
        comment = file_basename(files)
        
        ;UPDATE THE SORT BASED ON WHAT THE USER CHECKS.        
        if sorttype eq 0 then begin
          csort = sort(comment)
          comment = comment[csort]
          files = files[csort]
        endif

        s = strarr(3)
        for i=0,n_elements(files)-1 do begin
;            comment[i] = file_basename(files[i])
            if file_test(files[i],/read) gt 0 then begin
                openr,lun,files[i],/get_lun
                readf,lun,s
                free_lun,lun
                ext = self->getExt(files[i])
                case strupcase(ext) of
                'BT1':begin
                comment[i] = comment[i] + '     |     ' + s[2]
                end;BT1
                'GSAS':begin
                comment[i] = comment[i] + '     |     ' + s[0]                  
                end;GSAS
                else:
                endcase
            endif
        endfor;i

        widget_control,self.filelist,set_value=comment,set_uvalue=files
    endif

end;cwo_ConvertBT1ToDave_class::selectFilesNew
;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::selectFiles
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::selectFiles

    dir = dialog_pickfile(title='Select BT-1 Data File Directory:',$
                         /directory,$
                         path=self.datadir,$
                         dialog_parent=self.tlb)
;                         ,$
;                         filter = ['*.dave','*.dat','*.iqt'])

    if dir[0] ne '' then begin
        widget_control,self.text,set_value = 'Data directory: '+dir
        self.datadir = dir;file_dirname(fn[0])
        ;self.workdir = dir;file_dirname(fn[0])


        files = file_search(dir+'*.bt1')

        comment = file_basename(files)

        s = strarr(3)
        for i=0,n_elements(files)-1 do begin
;            comment[i] = file_basename(files[i])
            if file_test(files[i],/read) gt 0 then begin
                openr,lun,files[i],/get_lun
                readf,lun,s
                free_lun,lun
                comment[i] = comment[i] + '     |     ' + s[2]
            endif
        endfor;i

        widget_control,self.filelist,set_value=comment,set_uvalue=files
    endif

end;cwo_ConvertBT1ToDave_class::selectFiles
;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::selectFiles
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::selectWorkingDirectory

    dir = dialog_pickfile(title='Select BT-1 Working Directory:',$
                         /directory,$
                         path=self.workdir,$
                         dialog_parent=self.tlb)

    if dir[0] ne '' then begin
        self.workdir = dir
    endif

end;cwo_ConvertBT1ToDave_class::selectWorkingDirectory


;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::convertFiles
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::convertFiles, writeCombinedFile=writeCombinedFile,$
                                        threeColASCII=threeColASCII,$
                                        defaultfilename=defaultnameswitch,$
                                        _Extra=extra

;CLEANUP NEEDED:
;THESE FLAGS ARE PASSED IN HERE, AFTER GETTING THEM FROM THE SAME WIDGETS IN THE 
;EVENT METHOD!!!!!

    widget_control,self.filelist,get_uvalue=uval
    widget_control,self.combineFilesCheckbox,get_value=combineFilesFlag
    widget_control,self.yaxisbgroup,get_value=val;,get_uvalue=choices
    widget_control,self.defaultFilenameCheckbox,get_value=usedefaultfilenames
    
    
    if n_elements(writeCombinedFile) eq 0 then writeCombinedFile = 0
    if n_elements(threeColASCII) eq 0 then threeColASCII = 0
    
    if threeColASCII eq 1 then combineFilesFlag = 0

    widget_control,self.text,get_value = originalText
    widget_control,self.text,set_value = 'WORKING . . . . . . '



    ;print,'combineFilesFlag=',combineFilesFlag

    selection = widget_info(self.filelist,/list_select)
    

    ;help,uval
    ;print,selection
    if n_elements(selection) le 1 then combineFilesFlag = 0
;print,'cwo_ConvertBT1ToDave_class::convertFiles  --- combineFilesFlag[0]=',combineFilesFlag[0]
    case combineFilesFlag[0] of
    0:begin
      nodavewrite = 0       ;NOTE:   THE nodavewrite VARIABLE IS MEANT TO PREVENT A DAVE FILE WRITE FOR EACH GROUP, BUT NOT THE
                            ;        COMBINED FILE WRITING.  THIS IS WHY I INTRODUCED THE writeCombinedFile KEYWORD, WHICH NOW
                            ;        DISTINGUISHES WHEN TO JUST SEND DATA TO THE DATA MANAGER AND WHEN TO WRITE THE FILE.
      writeCombinedFile = 0
      xIndex = 0
      xT  = 0
      xH  = 0
      xM4 = 0
  
      case val of
      0:xIndex = 1
      1:xT = 1
      2:xH = 1
      3:xM4 = 1
      else:xIndex = 1
      endcase

    end;0
    1:begin
            nodavewrite = 1
            writeCombinedFile = 1
            xIndex = 0
            xT  = 0
            xH  = 0
            xM4 = 0
        
            case val of
            0:xIndex = 1
            1:xT = 1
            2:xH = 1
            3:xM4 = 1
            else:xIndex = 1
            endcase

    end;1
    else:begin
      nodavewrite = 0
      writeCombinedFile = 1
      threeColASCII = 0
    endelse
    endcase
;print,'xIndex=',xIndex
;help,combineFilesFlag[0]
;USE THE NEXT BLOCK TO REPLACE THE ENTIRE BLOCK OF CODE BELOW IT.
;help,uval
;help,selection
    if selection[0] ne -1 then begin
;        print,'cwo_ConvertBT1ToDave_class::convertFiles     files=:'
;        if n_elements(selection) gt 1 then begin
;          print,transpose(uval[selection])
;        endif else begin
;          print,uval[selection[0]]
;        endelse

;        ;GET THE DAVE OBJECT FOR PUTTING DATA IN THE DATA MANAGER.
;        dret = getdavetool(davetool)
;        help,davetool



;
;
;SORT BY EXTENSION AND THEN USE DIFFERENT READERS FOR BT1 AND GSAS FILES.
;
;
;
fext = strarr(n_elements(selection))
files = uval[selection]
;print,files
for i=0,n_elements(selection)-1 do begin
  fext[i] = strupcase(self->getext(uval[selection[i]]))
endfor;i
whbt1  = where(fext eq 'BT1',bt1count)
whgsas = where(fext eq 'GSAS',gsascount)
;print,whbt1
;print,whgsas      
if bt1count  gt 0 then bt1fn  = files[whbt1]
if gsascount gt 0 then begin
  gsasfn = files[whgsas]
  if combineFilesFlag eq 1 then begin
    void = dialog_message('Note: .gsas FILES WILL NOT BE COMBINED.  Only separate files will be written.',dialog_parent=self.tlb,/info)
  endif  
endif;gsascount


;print,'bt1fn=',bt1fn
;print,'gsasfn=',gsasfn

      if bt1count gt 0 then begin
        bt1fn  = files[whbt1]
        readBT1Test,combine=combineFilesFlag,t=xt,h=xh,index=xIndex,nodavewrite=nodavewrite,$
                    writeCombinedFile=writeCombinedFile,$                    
                    datadir=self.datadir,workdir=self.workdir,davePtr=davePtr,$
                    ASCII3Col=threeColASCII,parent=self.tlb,$
                    files=bt1fn,$;uval[selection],$
                    defaultoutputfile=usedefaultfilenames,$
                    davetool=self.davetool;,c=xc,n=xn
      endif
      if gsascount gt 0 then begin
        gsasfn  = files[whgsas]


        ;READ EACH FILE INDIVIDUALLY,
        ;IF DEFAULT FILE IS NOT SELECTED, THEN PROMPT USER FOR A FILENAME
        duh = readBT1Test_convertGSASFiles(gsasfn,workdir=self.workdir,$
                                           defaultoutputfile=usedefaultfilenames,$
                                           threeColASCII=threeColASCII,$
                                           davetool=self.davetool)
        ;print,'duh=',duh                                           

        

      endif

    endif else begin
        void = dialog_message(['No files selected.  ','Please choose data directory and select files from the list.'],dialog_parent=self.tlb,/info)
    endelse

    widget_control,self.text,set_value = originalText



;    nfiles = n_elements(selection)
;
;    resultPtr = ptrarr(nfiles,/allocate)
;
;    if selection[0] ne -1 then begin
;        widget_control,self.text,get_value=savetext
;        for i=0,n_elements(selection)-1 do begin
;            newtext = 'Converting '+file_basename(uval[selection[i]])
;            widget_control,self.text,set_value=newtext
;
;            sel = uval[selection[i]]
;            self->convertData,sel,result,nodavewrite=nodavewrite
;            
;            *resultPtr[i] = result
;        endfor;i
;        if combineFilesFlag eq 1 then begin  
;          readbt1_combineResults,resultPtr,xt=xt,xh=xh,xn=xIndex,xIndex=xIndex,$
;                                 workdir=self.workdir,datadir=self.datadir
;        endif
;
;        widget_control,self.text,set_value=savetext
;    endif else begin
;        void = dialog_message('Please select files from the list.')
;    endelse
;    
;    ptr_free,resultPtr
    
end;cwo_ConvertBT1ToDave_class::convertFiles

;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::convertData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::convertData,fn,result,nodavewrite=nodavewrite

    ;READ A BT-1 FILE INTO A STRUCTURE:
    ;
    ;THEN CREATE A 2d DATA SET WITH
    ;
    ;   I[nQ,nt],sI[nQ,nT]
    ;   IF nt VARIES, THEN FILL IN I AT UNIQUE t'S WITH NaN'S --- WHAT ABOUT ROUNDING FOR Q,t????
    ;                                                             SEE WHAT WAS DONE IN ooEcho.
    ;
    ; THEN WRITE A DAVE FILE.

    if n_elements(nodavewrite) eq 0 then nodavewrite = 0
  
    widget_control,self.yaxisbgroup,get_value=val;,get_uvalue=choices
    ;help,choices[0]


    xIndex = 0
    xT  = 0
    xH  = 0
    xM4 = 0

;print,'val=',val

    case val of
    0:xIndex = 1
    1:xT = 1
    2:xH = 1
    3:xM4 = 1
    else:xIndex = 1
    endcase

;print,'xIndex=',xIndex
;print,'xT=',xT
;print,'xH=',xH
;print,'xM4=',xM4


;help,/traceback
	basename = file_basename(fn)

    if nodavewrite eq 0 then begin
  	  ofn = self.workdir+path_sep()+basename
  
  
      ext = self->getExt(fn,iext=iext,len=len)
      sublen=len-iext
  
      ;void = dialog_message('BEFORE strendsub call cwo_ConvertBT1ToDave_class::convertData')
      ofn = strendsub(ofn,'.dave',sublen)
      ;void = dialog_message('AFTER strendsub call')
  
      exists = file_test(ofn)
      if exists ne 0 then begin
          yn = dialog_message('File '+file_basename(ofn)+' exists.  Overwrite?',/question)
          if yn eq 'No' then begin
              ofn = dialog_pickfile(path=self.workdir,$;file_dirname(ofn),$
              					  filter='*.dave',title='Select DAVE output file for '+file_basename(fn),$
                         dialog_parent=self.tlb)
  			if ofn ne '' then begin
  				self.workdir = file_dirname(ofn)
              	self->addDotDave,ofn
  			endif else begin
  				return
  			endelse
          endif
          self->addDotDave,ofn
      endif
    endif else begin
      ;set ofn to nothing so the next if statement will bypass file write.
      ofn = ''
    endelse

    if ofn ne '' then begin

;        exists = file_test(ofn)
;        if exists ne 0 then begin
;            writeable = file_test(ofn,/write)
;        endif else begin
;            writeable = 1
;        endelse

        writeableDir = file_test(file_dirname(ofn),/write,/directory)

        if writeableDir ne 0 then begin	;and writeable ne 0 then begin
            ;print,val,xIndex,xT,xH,xM4,fn,ofn

            readbt1,result,fn=fn,ofn=ofn,xIndex=xIndex,xT=xT,xH=xH,xM4=xM4

        endif else begin
            void = dialog_message('Directory not writable: '+file_dirname(ofn),dialog_parent=self.tlb)
;            void = dialog_message(file_basename(ofn)+' exists or is not writeable in that directory.')
        endelse

    endif else begin
        ;NEED TO TAKE THIS APPROACH IN CASE THERE IS NO ofn SELECTED BUT THE USER STILL 
        ;WANTS result FOR USE ELSEWHERE (e.g. TO MERGE MULTIPLE FILES INTO A SINGLE DAVE FILE.)
        readbt1,result,fn=fn,ofn=ofn,xIndex=xIndex,xT=xT,xH=xH,xM4=xM4,/nodavewrite
    endelse

end;cwo_ConvertBT1ToDave_class::convertData



pro cwo_ConvertBT1ToDave_class::addDotDave,ofn

        ext = self->getExt(ofn,iext=iext,len=len)
        if ext ne 'dave' then begin
            if iext gt 0 then begin
                sublen=len-iext
                ;print,'ofn before=',ofn
                ;void = dialog_message('BEFORE strendsub call cwo_ConvertBT1ToDave_class::addDotDave')
                ofn = strendsub(ofn,'dave',sublen)
                ;void = dialog_message('AFTER strendsub call')

                ;print,'ofn after=',ofn
            endif else begin
                ofn = ofn+'.dave'
            endelse
        endif

end;cwo_ConvertBT1ToDave_class::addDotDave


;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::getExt
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_ConvertBT1ToDave_class::getExt,s,iext=iext,len=len
        iext = strpos(s,'.',/reverse_search)

        if iext ne -1 then begin
            len  = strlen(s)
            ext  = strmid(s,iext+1,len-iext)
        endif else begin
            ext = ''
        endelse
        return,ext

end;cwo_ConvertBT1ToDave_class::getExt


;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::writeDave
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::writeDave



end;writeDave




;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::draw
end;cwo_ConvertBT1ToDave_class::draw

;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::setproperty,_Extra=extra
    if n_elements(tlb) ne 0 then self.tlb =tlb
end;cwo_ConvertBT1ToDave_class::setproperty


;WHY THE FUCK DOES USING _Extra NOT WORK FOR RETRIEVING VALUES VIA get/setProperty???????????????
;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::getproperty,tlb=tlb,_Extra=extra


    ;print,'CALLED GETPROPERTY'
    if arg_present(tlb) ne 0 then tlb = self.tlb
end;cwo_ConvertBT1ToDave_class::getproperty

;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_cleanup,id
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;cwo_ConvertBT1ToDave_cleanup

;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class::cleanup
    print,'cwo_ConvertBT1ToDave_class::cleanup'
    if ptr_valid(self.pdata) then begin
        if ptr_valid((*self.pdata)[0]) then ptr_free,(*self.pdata)
        ptr_free,self.pdata
    endif
end;cwo_ConvertBT1ToDave_class::cleanup

;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_ConvertBT1ToDave_class::init,parent,$
                                    xsize=xsize,ysize=ysize,$
                                    tlb=tlb,group_leader=group_leader,$
                                    dataDir=dataDir,workDir=workDir,$
                                    daveTool=daveTool,$
                                    _extra=extra     


    if n_elements(davetool) ne 0 then self.davetool = davetool else self.davetool = obj_new()

    nobj = checkforobjinstance('cwo_ConvertBT1ToDave_class',ref=ref)
    if nobj gt 1 then begin
        help,ref[0],output=out0,struct=0
        help,self,output=outself,struct=0

        if strcmp(out0,outself,/fold_case) eq 0 then begin
            ref[0]->getproperty,tlb=tlb
        endif else begin
            ref[1]->getproperty,tlb=tlb
        endelse

        widget_control,tlb,/show
        return,0
    endif else begin

        if n_elements(parent) eq 0 then parent = -1L

        if n_elements(datadir) eq 0 then begin
			defsysv,'!dave_defaults',exists=exists
			if exists ne 0 then begin
				datadir = (*!dave_defaults).datdir
			endif else begin
				datadir = '.'
			endelse
		endif
		self.datadir = datadir

    if n_elements(workdir) eq 0 then begin
			defsysv,'!dave_defaults',exists=exists
			if exists ne 0 then begin
			workdir = (*!dave_defaults).workdir
			endif else begin
				workdir = '.'
			endelse

		endif
        self.workdir = workdir


        if parent ne -1L then begin
            tlb = widget_base(parent,title='ConvertBT1ToDAVE',group_leader=parent,/row,uvalue=self,$
                                kill_notify='cwo_ConvertBT1ToDave_cleanup')
        endif else begin
            tlb = widget_base(title='ConvertBT1ToDAVE',group_leader=group_leader,mbar=bar,/row,uvalue=self,$
                                kill_notify='cwo_ConvertBT1ToDave_cleanup')
        endelse

        llb1 = widget_base(tlb,/col)
        llb2 = widget_base(tlb,/col)

        value=['No Files Selected']
        self.filelist = widget_list(llb1,xsize=80,ysize = 35,$
                                    value=value,$
                                    uvalue=value,$
                                    /multiple)

        if n_elements(bar) ne 0 then begin
            filemenu = widget_button(bar,value='File',/menu)
            self.filebuttonfile = widget_button(filemenu,value='Choose Directory')
            self.workdirbuttonfile = widget_button(filemenu,value='Choose Output Directory')
            self.mergeButtonfile = widget_button(filemenu,value='Make DAVE file(s)')
            self.quitbuttonfile = widget_button(filemenu,value='Quit')

            helpmenu = widget_button(bar,value='Help',/menu)
            self.helpbuttonhelp = widget_button(helpmenu,value='Help')
        endif

        self.fileButton  = Widget_button(llb2,value='Choose Data Directory',$
                                              tooltip='Choose location of files for conversion')
        self.sortFilesBGroup = cw_bgroup(llb2,['Name','Type'],label_left='Sort input files by: ',/row,/exclusive,frame=2,set_value=0)
                                              
        self.workdirButton  = Widget_button(llb2,value='Choose Output Directory',$
                                              tooltip='Choose location of converted output files')

        self.defaultFilenameCheckbox = cw_bgroup(llb2,['Use default filename (<root>.txt or <root>.dave)'],frame=2,$
                                                  /no_release,/nonexclusive,set_value=1)
                                              
        self.mergeButton = Widget_button(llb2,value='Make DAVE file(s) [.dave]',$
                                              tooltip='Create DAVE files from the selected .bt1 files')
        self.threecolumnasciibutton = Widget_button(llb2,value='Make 3Col ASCII file(s) [.txt]',$
                                              tooltip='Create 3Column ASCII files from the selected .bt1 files')

;    result = {x:dblarr(1),$
;              xIndex:dblarr(1),$
;              xT:dblarr(1),$
;              xM4:dblarr(1),$
;              xC:dblarr(1),$
;              xN:dblarr(1),$
;              xH:dblarr(1),$

        combinebase = widget_base(llb2,/col,frame=4)
        s_theta = textoidl('2\theta')
        self.combineFilesCheckbox = cw_bgroup(combinebase,['Combine Multiple BT-1 Files (x=2theta,y=axis choice below)'],$;frame=2,
                                              /no_release,/nonexclusive)
        yaxischoices =  ['Index (Group Index)',$
                        'T (Temp)',$
                        'H (Field)',$
                        'M4 (Motor 4)'];,$
                        ;'C (?????)',$
                        ;'N (Det Blocks)']
        yaxisnames   =  ['Index','T','H','M4'];,'C','N']
        yaxisunits   =  ['Point number','K?','kG?','deg?'];,'???','det blocks']

        yaxisuvalue = {yaxisnames:yaxisnames,naxisunits:yaxisunits}
        self.yaxisbgroup = cw_bgroup(combinebase,yaxischoices,/exclusive,frame=2,$
                                            /no_release,uvalue=yaxisuvalue,$
                                            label_left='Y-Axis/Group Variable:')


        self.helpButton  = widget_button(llb2,value='Help',$
                                              tooltip='Help on ConvertBT1ToDAVE')
        self.quitButton  = widget_button(llb2,value='Quit',$
                                              tooltip='Exit ConvertBT1ToDAVE')

        

        self.text = widget_text(llb1,value='')

        widget_control,self.yaxisbgroup,set_value=1

        centertlb,tlb

        widget_control,tlb,/realize
        xmanager,'cwo_ConvertBT1ToDave',tlb,/no_block;,event_handler='cwo_ConvertBT1ToDave_event'

        self.tlb = tlb

        return,1
    endelse
end;init

;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave_class__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_ConvertBT1ToDave_class__define,class

    class = {cwo_ConvertBT1ToDave_class,$
                inherits idl_container,$
                pdata:ptr_new(),$
                datadir:'',$
                workdir:'',$
                davetool:obj_new(),$
                tlb:0L,$
                filelist:0L,$
                quitbutton:0L,$
                quitbuttonfile:0L,$
                filebutton:0L,$
                workdirbutton:0L,$
                filebuttonfile:0L,$
                workdirbuttonfile:0L,$
                mergebutton:0L,$
                threecolumnasciibutton:0L,$
                mergebuttonfile:0L,$
                combineFilesCheckbox:0L,$
                defaultFilenameCheckbox:0L,$
                sortFilesBGroup:0L,$
                helpbutton:0L,$
                helpbuttonhelp:0L,$
                yaxisbgroup:0L,$
                text:0L}

end;cwo_ConvertBT1ToDave_class__define
;###############################################################################
;
;NAME:
;        cwo_ConvertBT1ToDave
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_ConvertBT1ToDave,parent,obj=obj,xsize=xsize,ysize=ysize,$
                                  group_leader=group_leader,$
                                  dataDir=dataDir,workDir=workDir,$
                                  daveTool=daveTool,$
                                  _extra=extra

    if n_elements(parent) eq 0 then parent = -1L
    ;daveret = getdavetool()
    ;if obj_isa(daveret,'DAVETOOL') ne 1 then daveTool = obj_new() 

    obj = obj_new('cwo_ConvertBT1ToDave_class',parent,$
                                        xsize=ysize,ysize=ysize,$
                                        tlb=tlb,group_leader=group_leader,$
                                        dataDir=dataDir,workDir=workDir,$
                                        daveTool=daveTool,$
                                        _extra=extra)

    return,tlb

end;cwo_ConvertBT1ToDave

