; $Id$
;###############################################################################
;
; NAME:
;  DTAS_NEW_NAME
;
; PURPOSE:
;
; CATEGORY:
;  DAVE, TAS, Data Reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; +
;
; -
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dt_nn_event,event
uname = widget_info(event.id,/uname)
case uname of
'ACCEPT':   $
   begin
      fid = widget_info(event.top,find_by_uname = 'FOLDER_NAME')
      widget_control,fid,get_value = this_val
      widget_control,event.top,get_uvalue = pstate
      (*pstate).field_name = this_val[0]
      widget_control,event.top,/destroy
   end
'CANCEL':   $
   begin
      widget_control,event.top,/destroy
   end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dtas_new_name,field_name,group_leader = group_leader, title = title
if n_elements(group_leader) eq 0 then group_leader = 0L
if n_params() eq 0 then field_name = 'DATA GROUP'
if n_elements(title) eq 0 then $
   title = 'Enter a new name for the data group'
tlb = widget_base(tlb_frame_attr = 9,group_leader = group_leader, $
   title = title,/col,/modal)
void = cw_field(tlb,value = field_name,title = 'New name', $
   uname = 'FOLDER_NAME',xsize = 35)
row_base = widget_base(tlb,/row)
void = widget_button(row_base,value = 'ACCEPT',uname = 'ACCEPT')
void = widget_button(row_base,value = 'CANCEL',uname = 'CANCEL')
centertlb,tlb
widget_control,tlb,/realize

state = {field_name:field_name}
pstate = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate
register_name = 'dtas_new_name'
xmanager,register_name,tlb,event_handler = 'dt_nn_event'
new_name = (*pstate).field_name
ptr_free,pstate
return,new_name
end