; $Id$
;###############################################################################
;
; NAME:
;  DTAS_CHANGE_IVAR
;
; PURPOSE:
;
; CATEGORY:
;  DAVE, TAS, Data Reduction
;
; AUTHOR:
;  Richard Azuah.
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; +
;
; -
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dci_send_info,event
widget_control,event.top,get_uvalue = pstate
notify_ids = (*pstate).notify_ids

;if (*pstate).notify_ids[0] eq 0L then return
;info =   {dci_event,                         $
;          id:notify_ids[0],                  $
;          top:notify_ids[1],                 $
;          handler:0L,                        $
;          selection:(*pstate).select,        $
;          update:(*pstate).update,           $
;          ocontainer:(*pstate).ocontainer    }

if widget_info(notify_ids[0],/valid_id) then begin
   dc2i = (*pstate).dc2i
   info =   (dc2i eq 0)? $
              {dci_event,                         $
              id:notify_ids[0],                  $
              top:notify_ids[1],                 $
              handler:0L,                        $
              selection:event.str, $ ;event.index,        $
                 update:(*pstate).update,           $
                 ocontainer:(*pstate).ocontainer    } : $
              {dc2i_event,                         $
              id:notify_ids[0],                  $
              top:notify_ids[1],                 $
              handler:0L,                        $
              selection:event.str, $ ;event.index,        $
                 update:(*pstate).update,           $
                 ocontainer:(*pstate).ocontainer    }


   widget_control,notify_ids[0],send_event = info
endif

end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dci_cleanup,tlb
widget_control,tlb,get_uvalue = pstate

; send a last event so the calling prog can deal with container initially passed to this dialog sub-program
notify_ids = (*pstate).notify_ids
if widget_info(notify_ids[0],/valid_id) then begin
   dc2i = (*pstate).dc2i
   info =   (dc2i eq 0)? $
              {dci_event,                         $
              id:notify_ids[0],                  $
              top:notify_ids[1],                 $
              handler:0L,                        $
              selection:'', $
              update:(*pstate).update,           $
              ocontainer:(*pstate).ocontainer    } $
              : $
              {dc2i_event,                         $
              id:notify_ids[0],                  $
              top:notify_ids[1],                 $
              handler:0L,                        $
              selection:'', $
              update:(*pstate).update,           $
              ocontainer:(*pstate).ocontainer    }


   widget_control,notify_ids[0],send_event = info
endif

widget_control,(*pstate).notify_ids[1],sensitive = 1
ptr_free,pstate
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;function dtas_ci_ncols,n,n1
;if n le n1 then begin
;   ncols = 1
;endif else begin
;   if n mod n1 eq 0 then ncols = fix(float(n)/n1) else ncols = fix(n/float(n1))+1
;endelse
;return,ncols
;end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dci_event,event

;begin error handler------------------------------------------------------------
; Handler to catch misc. errors and provide a graceful exit so
; that main app does not crash.
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'Error encountered'
        eMsg = 'dci_event: An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif
;end error handler-------------------------------------------------------------

widget_control,event.top,get_uvalue = pstate

uname = widget_info(event.id,/uname)

;match_name = where((*pstate).group_name eq uname,count_match)  ; this gives the column number
;if count_match gt 0 then begin
;   ; First do not allow the user to "un-check" a
;   ; value.
;   old_index = (*pstate).select  ; the old setting for the group widget
;   ; Which column is this?
;   old_col = fix(float(old_index)/(*pstate).n)
;   ; Does the old index match the one the user just selected?
;   new_index = ((*pstate).n * match_name[0]) + event.value
;   old_match_new = new_index eq old_index
;   ; If so then make sure that this remains set!
;   if old_match_new then begin
;      ; Convert the index to the proper value
;      widget_control,event.id,get_value = current_setting
;      current_setting = 0B*current_setting
;      current_setting[new_index-(*pstate).n*match_name[0]] = 1B
;      widget_control,event.id,set_value = current_setting
;      dci_send_info,event
;      return
;   endif
;   ; If we've gotten to this point in the code then the
;   ; user has checked a box that was not previously checked.
;
;   (*pstate).select = new_index
;   ; Now zero out all of the other CW_BGROUPS
;   ncols = n_elements((*pstate).group_name)
;
;   for i = 0,ncols-1 do begin
;      uname = (*pstate).group_name[i]
;      id = widget_info(event.top,find_by_uname = uname)
;      widget_control,id,get_value = this_setting
;      new_setting = 0B*this_setting
;      if match_name[0] eq i then begin
;         ; We're in the same column as the change
;         new_setting[new_index-(*pstate).n*match_name[0]] = 1B
;         widget_control,id,set_value = new_setting
;      endif else begin
;         ; We're in a different column as the change
;         widget_control,id,set_value = new_setting
;      endelse
;
;   endfor
;   dci_send_info,event
;   return
;endif

if (uname eq 'DISMISS') then $
   widget_control,event.top,/destroy $
else $
   dci_send_info,event

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dtas_change_ivar,ocontainer,group_leader = group_leader,   $
   notify_ids = notify_ids,register_name = register_name, $
   no_update = no_update,num_elements = num_elements,title=title, $
   dependent=dependent, init_index=init_index, dc2i=dc2i, var_names=var_names

; I had to modify this dialog significantly in order to accomodate the many
; possible independent variables that are now included in the new ICE data
; files.  This meant that I now use columns of CW_BGROUP widgets and they are
; non-exclusive.  Yet I had to "fake" the exclusivity of them. (RMD-03/14/05)

if n_elements(num_elements) eq 0 then num_elements = 15
if n_elements(no_update) eq 0 then no_update = 0
if no_update eq 1 then update = 0 else update = 1
if n_elements(notify_ids) eq 0 then return
if n_params() eq 0 then return
if not obj_valid(ocontainer) then return
if n_elements(group_leader) eq 0 then return
n = ocontainer->count()
if n eq 0 then return
o = ocontainer->get(/all)
ret = o[0]->get_property(display_name = display_name,var_names = titles, $
   plot_str = plot_str,filename = filename)
n = n_elements(titles)
;if ~is_ice(filename) then titles = titles[0:n-3]
titles = (n_elements(var_names) gt 0)? var_names : titles[0:n-3]
names = titles

if n_elements(register_name) eq 0 then register_name = display_name
if xregistered(register_name) then return
widget_control,group_leader,sensitive = 0

; Create the widgets
if (n_elements(title) eq 0) then title='Select Independent Variable'
tlb = widget_base(group_leader = group_leader,/col,/tlb_frame_attr,title = title )
;if (n_elements(group_leader) gt 0) then begin
;   modal = 1
;   TLB = widget_base(/col,title=title,/base_align_center,group_leader=group_leader,modal=modal)
;endif else begin
;   modal = 0
;   TLB = widget_base(/col,title=title ,/base_align_center,modal=modal)
;endelse

;row_base1 = widget_base(tlb,/row)
;ncols = dtas_ci_ncols(n_elements(names),num_elements)
;group_name = strarr(ncols)
;for i = 0,ncols-1 do begin
;   uname = 'VAR_CHOICE_'+strtrim(string(i),2)
;   group_name[i] = uname
;   if i lt ncols-1 then begin
;      titles_id = cw_bgroup(row_base1,names[i*num_elements:((i+1)*num_elements)-1], $
;         /nonexclusive,uname = uname,/col, xsize = 200)
;   endif else begin
;      titles_id = cw_bgroup(row_base1,names[i*num_elements:n_elements(names)-1], $
;         /nonexclusive,uname = uname,/col, xsize = 200)
;   endelse
;endfor
;row_base2 = widget_base(tlb,/row)
;void = widget_button(row_base2,value = 'DISMISS',uname = 'DISMISS')

void = widget_label(tlb,value='Please make a new selection from the list')
void = widget_label(tlb,value='Click on the FINISH button to exit this dialog')
void = widget_label(tlb,value=' ')
wList = widget_combobox(tlb,value=titles,/dynamic_resize)
void = widget_label(tlb,value=' ')
void = widget_button(tlb,value='FINISH',uname='DISMISS')

centertlb,tlb
widget_control,tlb,/realize

if (n_elements(init_index) eq 0) then begin
   current_title = keyword_set(dependent)? plot_str.ytitle : plot_str.xtitle
   index = where(names eq current_title,count)
   if count eq 0 then begin
       index = 0                   ; default value
       if (keyword_set(dependent)) then $
         index = where(strupcase(names) eq 'COUNTS',count)
       if ( (count eq 0) && keyword_set(dependent)) then $
         index = where(strupcase(names) eq 'DETECTOR',count)
   endif
   index = index[0]
   if (count eq 1) then widget_control, wList, set_combobox_select=index
endif else begin
   widget_control, wList, set_combobox_select=init_index
endelse

;centertlb,tlb
;widget_control,tlb,/realize
;current_title = keyword_set(dependent)? plot_str.ytitle : plot_str.xtitle
;index = where(names eq current_title,count)
;if count eq 0 then begin
;    index = 0                   ; default value
;    if (keyword_set(dependent)) then $
;      index = where(strupcase(names) eq 'COUNTS',count)
;    if ( (count eq 0) && keyword_set(dependent)) then $
;      index = where(strupcase(names) eq 'DETECTOR',count)
;endif
;index = index[0]
;
;; Given the new scheme of things we must figure out which button
;; group to set (RMD-03/13/05)
;
;; Which one do we check?
;col = fix(index/float(num_elements))
;this_name = 'VAR_CHOICE_'+strtrim(string(col),2)
;this_id = widget_info(tlb,find_by_uname = this_name)
;widget_control,this_id,get_value = values
;; Set the correct CW_GROUP widget
;n_names = n_elements(names)
;values = 0B*values
;if n_elements(values) gt n_names then $
;   values[index] = 1B else $
;   values[index - num_elements*col] = 1B
;widget_control,this_id,set_value = values
;
;
;state = {titles_id:titles_id,ocontainer:ocontainer,notify_ids:notify_ids, $
;         select:index,update:update,group_name:group_name,n:num_elements}

if (~keyword_set(dc2i)) then dc2i = 0
state = {ocontainer:ocontainer,notify_ids:notify_ids,update:update,dc2i:dc2i}

pstate = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate,/no_copy
xmanager,register_name,tlb,/no_block,event_handler = 'dci_event', $
   cleanup = 'dci_cleanup'
end
